/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.utils;

import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class WALWriteUtils {
    public static final int BOOLEAN_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int DOUBLE_LEN = 8;
    public static final int FLOAT_LEN = 4;
    private static final int NO_BYTE_TO_READ = -1;

    private WALWriteUtils() {
    }

    public static int write(Boolean flag, IWALByteBufferView buffer) {
        byte a = Boolean.TRUE.equals(flag) ? (byte)1 : 0;
        buffer.put(a);
        return 1;
    }

    public static int write(byte n, IWALByteBufferView buffer) {
        buffer.put(n);
        return 1;
    }

    public static int write(short n, IWALByteBufferView buffer) {
        buffer.putShort(n);
        return 2;
    }

    public static int write(Binary n, IWALByteBufferView buffer) {
        buffer.putInt(n.getLength());
        buffer.put(n.getValues());
        return 4 + n.getLength();
    }

    public static int write(int n, IWALByteBufferView buffer) {
        buffer.putInt(n);
        return 4;
    }

    public static int write(long n, IWALByteBufferView buffer) {
        buffer.putLong(n);
        return 8;
    }

    public static int write(float n, IWALByteBufferView buffer) {
        buffer.putFloat(n);
        return 4;
    }

    public static int write(double n, IWALByteBufferView buffer) {
        buffer.putDouble(n);
        return 8;
    }

    public static int write(String s, IWALByteBufferView buffer) {
        if (s == null) {
            return WALWriteUtils.write(-1, buffer);
        }
        int len = 0;
        byte[] bytes = s.getBytes();
        len += WALWriteUtils.write(bytes.length, buffer);
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(IDeviceID deviceID, IWALByteBufferView buffer) {
        if (deviceID == null) {
            return WALWriteUtils.write(-1, buffer);
        }
        int len = 0;
        byte[] bytes = deviceID.getBytes();
        len += WALWriteUtils.write(bytes.length, buffer);
        buffer.put(bytes);
        return len += bytes.length;
    }

    public static int write(TSDataType dataType, IWALByteBufferView buffer) {
        byte n = dataType.serialize();
        return WALWriteUtils.write(n, buffer);
    }

    public static int write(TSEncoding encoding, IWALByteBufferView buffer) {
        byte n = encoding.serialize();
        return WALWriteUtils.write(n, buffer);
    }

    public static int write(CompressionType compressionType, IWALByteBufferView buffer) {
        byte n = compressionType.serialize();
        return WALWriteUtils.write(n, buffer);
    }

    public static int write(MeasurementSchema measurementSchema, IWALByteBufferView buffer) {
        int len = 0;
        len += WALWriteUtils.write(measurementSchema.getMeasurementId(), buffer);
        len += WALWriteUtils.write(measurementSchema.getType(), buffer);
        len += WALWriteUtils.write(measurementSchema.getEncodingType(), buffer);
        len += WALWriteUtils.write(measurementSchema.getCompressor(), buffer);
        Map props = measurementSchema.getProps();
        if (props == null) {
            len += WALWriteUtils.write(0, buffer);
        } else {
            len += WALWriteUtils.write(props.size(), buffer);
            for (Map.Entry entry : props.entrySet()) {
                len += WALWriteUtils.write((String)entry.getKey(), buffer);
                len += WALWriteUtils.write((String)entry.getValue(), buffer);
            }
        }
        return len;
    }

    public static int sizeToWrite(MeasurementSchema measurementSchema) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.sizeToWrite((String)measurementSchema.getMeasurementId());
        byteLen += 3;
        Map props = measurementSchema.getProps();
        byteLen += 4;
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                byteLen += ReadWriteIOUtils.sizeToWrite((String)((String)entry.getKey()));
                byteLen += ReadWriteIOUtils.sizeToWrite((String)((String)entry.getValue()));
            }
        }
        return byteLen;
    }
}

