/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.filter.basic.Filter;

public class QueryDataSource
implements IQueryDataSource {
    private final List<TsFileResource> seqResources;
    private int curSeqIndex = -1;
    private long curSeqOrderTime = 0L;
    private Boolean curSeqSatisfied = null;
    private final List<TsFileResource> unseqResources;
    private int curUnSeqIndex = -1;
    private long curUnSeqOrderTime = 0L;
    private Boolean curUnSeqSatisfied = null;
    private boolean isSingleDevice;
    private int[] unSeqFileOrderIndex;
    private static final Comparator<Long> descendingComparator = (o1, o2) -> Long.compare(o2, o1);

    public QueryDataSource(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        this.seqResources = seqResources;
        this.unseqResources = unseqResources;
    }

    public QueryDataSource(QueryDataSource other) {
        this.seqResources = other.seqResources;
        this.unseqResources = other.unseqResources;
        this.unSeqFileOrderIndex = other.unSeqFileOrderIndex;
    }

    public List<TsFileResource> getSeqResources() {
        return this.seqResources;
    }

    public List<TsFileResource> getUnseqResources() {
        return this.unseqResources;
    }

    @Override
    public IQueryDataSource clone() {
        QueryDataSource queryDataSource = new QueryDataSource(this.getSeqResources(), this.getUnseqResources());
        queryDataSource.setSingleDevice(this.isSingleDevice());
        return queryDataSource;
    }

    public boolean hasNextSeqResource(int curIndex, boolean ascending, IDeviceID deviceID) {
        boolean res;
        boolean bl = ascending ? curIndex < this.seqResources.size() : (res = curIndex >= 0);
        if (res && curIndex != this.curSeqIndex) {
            this.curSeqIndex = curIndex;
            this.curSeqOrderTime = this.seqResources.get(curIndex).getOrderTimeForSeq(deviceID, ascending);
            this.curSeqSatisfied = null;
        }
        return res;
    }

    public boolean isSeqSatisfied(IDeviceID deviceID, int curIndex, Filter timeFilter, boolean debug) {
        if (curIndex != this.curSeqIndex) {
            throw new IllegalArgumentException(String.format("curIndex %d is not equal to curSeqIndex %d", curIndex, this.curSeqIndex));
        }
        if (this.curSeqSatisfied == null) {
            TsFileResource tsFileResource = this.seqResources.get(this.curSeqIndex);
            this.curSeqSatisfied = tsFileResource != null && (this.isSingleDevice || tsFileResource.isSatisfied(deviceID, timeFilter, true, debug));
        }
        return this.curSeqSatisfied;
    }

    public long getCurrentSeqOrderTime(int curIndex) {
        if (curIndex != this.curSeqIndex) {
            throw new IllegalArgumentException(String.format("curIndex %d is not equal to curSeqIndex %d", curIndex, this.curSeqIndex));
        }
        return this.curSeqOrderTime;
    }

    public TsFileResource getSeqResourceByIndex(int curIndex) {
        if (curIndex < this.seqResources.size()) {
            return this.seqResources.get(curIndex);
        }
        return null;
    }

    public boolean hasNextUnseqResource(int curIndex, boolean ascending, IDeviceID deviceID) {
        boolean res;
        boolean bl = res = curIndex < this.unseqResources.size();
        if (res && curIndex != this.curUnSeqIndex) {
            this.curUnSeqIndex = curIndex;
            this.curUnSeqOrderTime = this.unseqResources.get(this.unSeqFileOrderIndex[curIndex]).getOrderTimeForUnseq(deviceID, ascending);
            this.curUnSeqSatisfied = null;
        }
        return res;
    }

    public boolean isUnSeqSatisfied(IDeviceID deviceID, int curIndex, Filter timeFilter, boolean debug) {
        if (curIndex != this.curUnSeqIndex) {
            throw new IllegalArgumentException(String.format("curIndex %d is not equal to curUnSeqIndex %d", curIndex, this.curUnSeqIndex));
        }
        if (this.curUnSeqSatisfied == null) {
            TsFileResource tsFileResource = this.unseqResources.get(this.unSeqFileOrderIndex[curIndex]);
            this.curUnSeqSatisfied = tsFileResource != null && (this.isSingleDevice || tsFileResource.isSatisfied(deviceID, timeFilter, false, debug));
        }
        return this.curUnSeqSatisfied;
    }

    public long getCurrentUnSeqOrderTime(int curIndex) {
        if (curIndex != this.curUnSeqIndex) {
            throw new IllegalArgumentException(String.format("curIndex %d is not equal to curSeqIndex %d", curIndex, this.curUnSeqIndex));
        }
        return this.curUnSeqOrderTime;
    }

    public TsFileResource getUnseqResourceByIndex(int curIndex) {
        int actualIndex = this.unSeqFileOrderIndex[curIndex];
        if (actualIndex < this.unseqResources.size()) {
            return this.unseqResources.get(actualIndex);
        }
        return null;
    }

    public int getSeqResourcesSize() {
        return this.seqResources.size();
    }

    public int getUnseqResourcesSize() {
        return this.unseqResources.size();
    }

    public void fillOrderIndexes(IDeviceID deviceId, boolean ascending) {
        TreeMap<Long, List> orderTimeToIndexMap = ascending ? new TreeMap<Long, List>() : new TreeMap(descendingComparator);
        int index = 0;
        for (TsFileResource resource : this.unseqResources) {
            orderTimeToIndexMap.computeIfAbsent(resource.getOrderTimeForUnseq(deviceId, ascending), key -> new ArrayList()).add(index++);
        }
        index = 0;
        int[] unSeqFileOrderIndexArray = new int[this.unseqResources.size()];
        for (List orderIndexes : orderTimeToIndexMap.values()) {
            for (Integer orderIndex : orderIndexes) {
                unSeqFileOrderIndexArray[index++] = orderIndex;
            }
        }
        this.unSeqFileOrderIndex = unSeqFileOrderIndexArray;
    }

    public boolean isSingleDevice() {
        return this.isSingleDevice;
    }

    public void setSingleDevice(boolean singleDevice) {
        this.isSingleDevice = singleDevice;
    }
}

