/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller;

import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.BatchCompactionCannotAlignedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.BatchCompactionPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.CompactChunkPlan;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.utils.FollowingBatchCompactionAlignedChunkWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.AbstractCompactionFlushController;
import org.apache.tsfile.file.metadata.IChunkMetadata;

public class FollowedBatchedCompactionFlushController
extends AbstractCompactionFlushController {
    public BatchCompactionPlan batchCompactionPlan;
    public FollowingBatchCompactionAlignedChunkWriter chunkWriter;
    public int currentCompactChunk;

    public FollowedBatchedCompactionFlushController(BatchCompactionPlan batchCompactionPlan, FollowingBatchCompactionAlignedChunkWriter chunkWriter) {
        super(0L, 0L);
        this.batchCompactionPlan = batchCompactionPlan;
        this.chunkWriter = chunkWriter;
        this.currentCompactChunk = 0;
    }

    @Override
    public boolean shouldSealChunkWriter() {
        return this.chunkWriter.checkIsChunkSizeOverThreshold(0L, 0L, true);
    }

    @Override
    public boolean shouldCompactChunkByDirectlyFlush(IChunkMetadata chunkToFlush) {
        CompactChunkPlan compactChunkPlan = this.batchCompactionPlan.getCompactChunkPlan(this.currentCompactChunk);
        if (compactChunkPlan.isCompactedByDirectlyFlush() && chunkToFlush.getStartTime() != compactChunkPlan.getTimeRange().getMin()) {
            throw new BatchCompactionCannotAlignedException(chunkToFlush, compactChunkPlan, this.batchCompactionPlan);
        }
        return compactChunkPlan.isCompactedByDirectlyFlush();
    }

    @Override
    public void nextChunk() {
        ++this.currentCompactChunk;
        if (this.currentCompactChunk < this.batchCompactionPlan.compactedChunkNum()) {
            this.chunkWriter.setCompactChunkPlan(this.batchCompactionPlan.getCompactChunkPlan(this.currentCompactChunk));
        }
    }
}

