/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.read.common.block.TsBlock;

public class NonAlignedPageElement
extends PageElement {
    private PageHeader pageHeader;
    private ByteBuffer pageData;
    private final CompactionChunkReader chunkReader;

    public NonAlignedPageElement(PageHeader pageHeader, ByteBuffer pageData, CompactionChunkReader chunkReader, ChunkMetadataElement chunkMetadataElement, boolean isLastPage) {
        super(chunkMetadataElement, isLastPage);
        this.pageHeader = pageHeader;
        this.pageData = pageData;
        this.chunkReader = chunkReader;
    }

    @Override
    public void deserializePage() throws IOException {
        TsBlock batchData = this.chunkReader.readPageData(this.pageHeader, this.pageData);
        this.pointReader = batchData.getTsBlockSingleColumnIterator();
        this.pageData = null;
    }

    @Override
    public long getStartTime() {
        return this.pageHeader.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.pageHeader.getEndTime();
    }

    public PageHeader getPageHeader() {
        return this.pageHeader;
    }

    public ByteBuffer getPageData() {
        return this.pageData;
    }
}

