/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTime;
import org.apache.iotdb.db.storageengine.dataregion.PartitionLastFlushTime;
import org.apache.tsfile.file.metadata.IDeviceID;

public class DeviceLastFlushTime
implements ILastFlushTime {
    Map<IDeviceID, Long> deviceLastFlushTimeMap = new HashMap<IDeviceID, Long>();

    @Override
    public long getLastFlushTime(IDeviceID deviceId) {
        if (this.deviceLastFlushTimeMap.containsKey(deviceId)) {
            return this.deviceLastFlushTimeMap.get(deviceId);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public void updateLastFlushTime(IDeviceID deviceId, long time) {
        this.deviceLastFlushTimeMap.merge(deviceId, time, Math::max);
    }

    @Override
    public ILastFlushTime degradeLastFlushTime() {
        long maxTime = Long.MIN_VALUE;
        for (long time : this.deviceLastFlushTimeMap.values()) {
            maxTime = Math.max(maxTime, time);
        }
        return new PartitionLastFlushTime(maxTime);
    }

    Map<IDeviceID, Long> getDeviceLastFlushTimeMap() {
        return this.deviceLastFlushTimeMap;
    }
}

