/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.basic.MeasurementTraverser;

public abstract class MeasurementCollector<R, N extends IMNode<N>>
extends MeasurementTraverser<R, N> {
    protected MeasurementCollector(N startNode, PartialPath path, IMTreeStore<N> store, boolean isPrefixMatch, PathPatternTree scope) throws MetadataException {
        super(startNode, path, store, isPrefixMatch, scope);
    }

    protected MeasurementCollector(N startNode, PathPatternTree fullPathTree, IMTreeStore<N> store, PathPatternTree scope) {
        super(startNode, fullPathTree, store, scope);
    }

    protected R generateResult(N nextMatchedNode) {
        return this.collectMeasurement(nextMatchedNode.getAsMeasurementMNode());
    }

    protected abstract R collectMeasurement(IMeasurementMNode<N> var1);

    protected MeasurementPath getCurrentMeasurementPathInTraverse(IMeasurementMNode<N> currentNode) {
        IMNode par = (IMNode)this.getParentOfNextMatchedNode();
        MeasurementPath retPath = new MeasurementPath(this.getPartialPathFromRootToNode((ITreeNode)currentNode.getAsMNode()), currentNode.getSchema());
        retPath.setUnderAlignedEntity(par.getAsDeviceMNode().isAlignedNullable());
        return retPath;
    }
}

