/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotCachedException;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotPinnedException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.MemoryStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.IMemoryManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.buffer.INodeBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.buffer.NodeBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.cache.CacheEntry;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.cache.INodeCache;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.cache.LRUNodeCache;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;

public class MemoryManager
implements IMemoryManager {
    private final LockManager lockManager;
    private final MemoryStatistics memoryStatistics;
    private final INodeCache nodeCache = new LRUNodeCache();
    private final INodeBuffer nodeBuffer = new NodeBuffer();

    public MemoryManager(MemoryStatistics memoryStatistics, LockManager lockManager) {
        this.memoryStatistics = memoryStatistics;
        this.lockManager = lockManager;
    }

    @Override
    public void initRootStatus(ICachedMNode root) {
        this.pinMNodeWithMemStatusUpdate(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatusAfterMemoryRead(ICachedMNode node) throws MNodeNotCachedException {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            throw new MNodeNotCachedException();
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            if (this.getCacheEntry(node) == null) {
                throw new MNodeNotCachedException();
            }
            this.pinMNodeWithMemStatusUpdate(node);
        }
        this.nodeCache.updateCacheStatusAfterAccess(cacheEntry);
    }

    @Override
    public void updateCacheStatusAfterDiskRead(ICachedMNode node) {
        this.pinMNodeWithMemStatusUpdate(node);
        CacheEntry cacheEntry = this.getCacheEntry(node);
        ICachedMNodeContainer.getBelongedContainer(node).addChildToCache(node);
        this.nodeCache.addToNodeCache(cacheEntry, node);
    }

    @Override
    public void updateCacheStatusAfterAppend(ICachedMNode node) {
        this.pinMNodeWithMemStatusUpdate(node);
        CacheEntry cacheEntry = this.getCacheEntry(node);
        cacheEntry.setVolatile(true);
        this.memoryStatistics.addVolatileNode();
        this.removeAncestorsFromCache(node);
        ICachedMNodeContainer.getBelongedContainer(node).appendMNode(node);
        this.nodeBuffer.addNewNodeToBuffer(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheStatusAfterUpdate(ICachedMNode node) {
        CacheEntry cacheEntry;
        if (node.isDatabase()) {
            this.nodeBuffer.updateDatabaseNodeAfterStatusUpdate((IDatabaseMNode<ICachedMNode>)node.getAsDatabaseMNode());
            return;
        }
        CacheEntry cacheEntry2 = cacheEntry = this.getCacheEntry(node);
        synchronized (cacheEntry2) {
            if (cacheEntry.isVolatile()) {
                return;
            }
            cacheEntry.setVolatile(true);
            this.memoryStatistics.addVolatileNode();
            if (!cacheEntry.hasVolatileDescendant()) {
                this.nodeCache.removeFromNodeCache(cacheEntry);
                this.removeAncestorsFromCache(node);
            }
            ICachedMNodeContainer.getBelongedContainer(node).updateMNode(node.getName());
            this.nodeBuffer.addUpdatedNodeToBuffer(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAncestorsFromCache(ICachedMNode node) {
        ICachedMNode current = (ICachedMNode)node.getParent();
        CacheEntry cacheEntry = this.getCacheEntry(current);
        while (!current.isDatabase()) {
            boolean isStatusChange = false;
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                if (!cacheEntry.hasVolatileDescendant()) {
                    cacheEntry.incVolatileDescendant();
                    isStatusChange = true;
                    this.nodeCache.removeFromNodeCache(cacheEntry);
                } else {
                    cacheEntry.incVolatileDescendant();
                }
                if (!isStatusChange || cacheEntry.isVolatile()) {
                    return;
                }
            }
            current = (ICachedMNode)current.getParent();
            cacheEntry = this.getCacheEntry(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAncestorsToCache(ICachedMNode node) {
        ICachedMNode current = (ICachedMNode)node.getParent();
        CacheEntry cacheEntry = this.getCacheEntry(current);
        while (!current.isDatabase()) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                cacheEntry.decVolatileDescendant();
                if (cacheEntry.hasVolatileDescendant() || cacheEntry.isVolatile()) {
                    return;
                }
                this.nodeCache.addToNodeCache(cacheEntry, current);
            }
            current = (ICachedMNode)current.getParent();
            cacheEntry = this.getCacheEntry(current);
        }
    }

    @Override
    public IDatabaseMNode<ICachedMNode> collectUpdatedStorageGroupMNodes() {
        IDatabaseMNode<ICachedMNode> storageGroupMNode = this.nodeBuffer.getUpdatedDatabaseMNode();
        this.nodeBuffer.removeUpdatedDatabaseNode();
        return storageGroupMNode;
    }

    @Override
    public Iterator<ICachedMNode> collectVolatileSubtrees() {
        return new Iterator<ICachedMNode>(){
            private final Iterator<ICachedMNode> nodeBufferIterator;
            private ICachedMNode nextSubtree;
            {
                this.nodeBufferIterator = MemoryManager.this.nodeBuffer.iterator();
                this.nextSubtree = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextSubtree == null) {
                    this.tryGetNext();
                }
                return this.nextSubtree != null;
            }

            @Override
            public ICachedMNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ICachedMNode result = this.nextSubtree;
                this.nextSubtree = null;
                return result;
            }

            private void tryGetNext() {
                if (this.nodeBufferIterator.hasNext()) {
                    ICachedMNode node = this.nodeBufferIterator.next();
                    MemoryManager.this.lockManager.writeLock(node);
                    MemoryManager.this.nodeBuffer.remove(MemoryManager.this.getCacheEntry(node));
                    this.nextSubtree = node;
                }
            }
        };
    }

    @Override
    public Iterator<ICachedMNode> updateCacheStatusAndRetrieveSubtreeAfterPersist(ICachedMNode subtreeRoot) {
        return new VolatileSubtreeIterator(ICachedMNodeContainer.getCachedMNodeContainer(subtreeRoot));
    }

    @Override
    public void updateCacheStatusAfterFlushFailure(ICachedMNode subtreeRoot) {
        this.nodeBuffer.addBackToBufferAfterFlushFailure(subtreeRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ICachedMNode node) {
        CacheEntry cacheEntry;
        CacheEntry cacheEntry2 = cacheEntry = node.getCacheEntry();
        synchronized (cacheEntry2) {
            if (cacheEntry.hasVolatileDescendant()) {
                throw new IllegalStateException(String.format("There should not exist descendant under this node %s", node.getFullPath()));
            }
            if (cacheEntry.isVolatile()) {
                this.addAncestorsToCache(node);
                this.memoryStatistics.removeVolatileNode();
                if (!this.getCacheEntry((ICachedMNode)node.getParent()).hasVolatileDescendant()) {
                    this.nodeBuffer.remove(this.getCacheEntry((ICachedMNode)node.getParent()));
                }
            } else {
                this.nodeCache.removeFromNodeCache(cacheEntry);
            }
            node.setCacheEntry(null);
        }
        if (cacheEntry.isPinned()) {
            this.memoryStatistics.releasePinnedMemResource(node);
        }
        this.memoryStatistics.releaseMemResource(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean evict(AtomicLong releaseNodeNum, AtomicLong releaseMemorySize) {
        this.lockManager.globalReadLock();
        try {
            ICachedMNode node = null;
            CacheEntry cacheEntry = null;
            ArrayList<ICachedMNode> evictedMNodes = new ArrayList<ICachedMNode>();
            boolean isSuccess = false;
            while (!isSuccess && (node = this.nodeCache.getPotentialNodeTobeEvicted()) != null) {
                this.lockManager.threadReadLock((ICachedMNode)node.getParent(), true);
                try {
                    CacheEntry cacheEntry2 = cacheEntry = this.getCacheEntry(node);
                    synchronized (cacheEntry2) {
                        String alias;
                        block14: {
                            if (!cacheEntry.isPinned() && !cacheEntry.isVolatile() && !cacheEntry.hasVolatileDescendant()) break block14;
                            continue;
                        }
                        ICachedMNodeContainer.getBelongedContainer(node).evictMNode(node.getName());
                        if (node.isMeasurement() && (alias = node.getAsMeasurementMNode().getAlias()) != null) {
                            ((ICachedMNode)node.getParent()).getAsDeviceMNode().deleteAliasChild(alias);
                        }
                        this.nodeCache.removeFromNodeCache(this.getCacheEntry(node));
                        node.setCacheEntry(null);
                        evictedMNodes.add(node);
                        isSuccess = true;
                    }
                }
                finally {
                    this.lockManager.threadReadUnlock((ICachedMNode)node.getParent());
                }
            }
            if (node != null) {
                this.collectEvictedMNodes(node, evictedMNodes);
            }
            int sz = this.memoryStatistics.releaseMemResource(evictedMNodes);
            releaseMemorySize.addAndGet(sz);
            releaseNodeNum.addAndGet(evictedMNodes.size());
            boolean bl = !evictedMNodes.isEmpty();
            return bl;
        }
        finally {
            this.lockManager.globalReadUnlock();
        }
    }

    private void collectEvictedMNodes(ICachedMNode node, List<ICachedMNode> evictedMNodes) {
        for (ICachedMNode child : node.getChildren().values()) {
            this.nodeCache.removeFromNodeCache(this.getCacheEntry(child));
            child.setCacheEntry(null);
            evictedMNodes.add(child);
            this.collectEvictedMNodes(child, evictedMNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pinMNode(ICachedMNode node) throws MNodeNotPinnedException {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null || !cacheEntry.isPinned()) {
            throw new MNodeNotPinnedException();
        }
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            cacheEntry = this.getCacheEntry(node);
            if (cacheEntry == null || !cacheEntry.isPinned()) {
                throw new MNodeNotPinnedException();
            }
            this.doPin(node);
        }
    }

    private void pinMNodeWithMemStatusUpdate(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            this.memoryStatistics.requestPinnedMemResource(node);
            this.nodeCache.initCacheEntryForNode(node);
        } else if (!cacheEntry.isPinned()) {
            this.memoryStatistics.upgradeMemResource(node);
        }
        this.doPin(node);
    }

    private void doPin(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (!cacheEntry.isPinned()) {
            ICachedMNode parent = (ICachedMNode)node.getParent();
            if (!node.isDatabase()) {
                this.getCacheEntry(parent).pin();
            }
        }
        cacheEntry.pin();
    }

    @Override
    public boolean unPinMNode(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return false;
        }
        return this.doUnPin(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doUnPin(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        boolean isPinStatusChanged = false;
        CacheEntry cacheEntry2 = cacheEntry;
        synchronized (cacheEntry2) {
            cacheEntry.unPin();
            if (!cacheEntry.isPinned()) {
                isPinStatusChanged = true;
                this.memoryStatistics.releasePinnedMemResource(node);
            }
        }
        if (isPinStatusChanged && !node.isDatabase()) {
            this.doUnPin((ICachedMNode)node.getParent());
        }
        return isPinStatusChanged;
    }

    @Override
    public void clear(ICachedMNode root) {
        this.clearMNodeInMemory(root);
        this.nodeCache.clear();
        this.nodeBuffer.removeUpdatedDatabaseNode();
        this.nodeBuffer.clear();
    }

    private void clearMNodeInMemory(ICachedMNode node) {
        CacheEntry cacheEntry = this.getCacheEntry(node);
        if (cacheEntry == null) {
            return;
        }
        if (cacheEntry.isPinned()) {
            this.memoryStatistics.releasePinnedMemResource(node);
        }
        this.memoryStatistics.releaseMemResource(node);
        Iterator<ICachedMNode> iterator = ICachedMNodeContainer.getCachedMNodeContainer(node).getChildrenIterator();
        while (iterator.hasNext()) {
            this.clearMNodeInMemory(iterator.next());
        }
    }

    protected CacheEntry getCacheEntry(ICachedMNode node) {
        return node.getCacheEntry();
    }

    @Override
    public long getBufferNodeNum() {
        return this.nodeBuffer.getBufferNodeNum();
    }

    @Override
    public long getCacheNodeNum() {
        return this.nodeCache.getCacheNodeNum();
    }

    private class VolatileSubtreeIterator
    implements Iterator<ICachedMNode> {
        private final ICachedMNodeContainer container;
        private Iterator<ICachedMNode> bufferedNodeIterator;
        private STATUS status;
        private ICachedMNode nextSubtree = null;

        private VolatileSubtreeIterator(ICachedMNodeContainer container) {
            this.container = container;
            this.bufferedNodeIterator = container.getNewChildFlushingBuffer().values().iterator();
            this.status = STATUS.ITERATE_NEW_BUFFER;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSubtree == null) {
                this.tryGetNext();
            }
            return this.nextSubtree != null;
        }

        @Override
        public ICachedMNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ICachedMNode result = this.nextSubtree;
            this.nextSubtree = null;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void tryGetNext() {
            while (true) {
                CacheEntry cacheEntry;
                boolean unlockImmediately;
                ICachedMNode node;
                block16: {
                    block17: {
                        if (!this.bufferedNodeIterator.hasNext()) {
                            if (this.status != STATUS.ITERATE_NEW_BUFFER) return;
                        }
                        if (!this.bufferedNodeIterator.hasNext()) {
                            this.bufferedNodeIterator = this.container.getUpdatedChildFlushingBuffer().values().iterator();
                            this.status = STATUS.ITERATE_UPDATE_BUFFER;
                            if (!this.bufferedNodeIterator.hasNext()) {
                                return;
                            }
                        }
                        node = this.bufferedNodeIterator.next();
                        MemoryManager.this.lockManager.writeLock(node);
                        unlockImmediately = true;
                        CacheEntry cacheEntry2 = cacheEntry = MemoryManager.this.getCacheEntry(node);
                        // MONITORENTER : cacheEntry2
                        if (this.status != STATUS.ITERATE_UPDATE_BUFFER || !this.container.getUpdatedChildReceivingBuffer().containsKey(node.getName())) break block16;
                        if (!cacheEntry.hasVolatileDescendant() || !ICachedMNodeContainer.getCachedMNodeContainer(node).hasChildrenInBuffer()) break block17;
                        this.nextSubtree = node;
                        unlockImmediately = false;
                        // MONITOREXIT : cacheEntry2
                        if (!unlockImmediately) return;
                        MemoryManager.this.lockManager.writeUnlock(node);
                        return;
                    }
                    // MONITOREXIT : cacheEntry2
                    if (!unlockImmediately) continue;
                    MemoryManager.this.lockManager.writeUnlock(node);
                    continue;
                }
                cacheEntry.setVolatile(false);
                MemoryManager.this.memoryStatistics.removeVolatileNode();
                if (this.status == STATUS.ITERATE_UPDATE_BUFFER) {
                    this.container.moveMNodeFromUpdateChildBufferToCache(node.getName());
                } else {
                    this.container.moveMNodeFromNewChildBufferToCache(node.getName());
                }
                if (cacheEntry.hasVolatileDescendant() && ICachedMNodeContainer.getCachedMNodeContainer(node).hasChildrenInBuffer()) {
                    this.nextSubtree = node;
                    unlockImmediately = false;
                    // MONITOREXIT : cacheEntry2
                    if (!unlockImmediately) return;
                    MemoryManager.this.lockManager.writeUnlock(node);
                    return;
                }
                try {
                    MemoryManager.this.nodeCache.addToNodeCache(cacheEntry, node);
                    MemoryManager.this.addAncestorsToCache(node);
                    // MONITOREXIT : cacheEntry2
                    continue;
                }
                finally {
                    if (!unlockImmediately) continue;
                    MemoryManager.this.lockManager.writeUnlock(node);
                    continue;
                }
                break;
            }
        }
    }

    static enum STATUS {
        ITERATE_NEW_BUFFER(0),
        ITERATE_UPDATE_BUFFER(1);

        private final byte status;

        private STATUS(byte status) {
            this.status = status;
        }
    }
}

