/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.udf;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFManagementService;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.adapter.PointCollectorAdaptor;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDFParametersFactory;
import org.apache.iotdb.db.queryengine.transformation.dag.util.InputRowUtils;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.iotdb.udf.api.utils.RowImpl;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTFExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTFExecutor.class);
    protected final String functionName;
    protected final UDTFConfigurations configurations;
    protected UDTF udtf;
    protected ElasticSerializableTVList outputStorage;
    protected PointCollectorAdaptor collector;
    protected Column[] cachedColumns;
    protected boolean isFirstIter = true;
    protected boolean useBatch = true;

    public UDTFExecutor(String functionName, ZoneId zoneId) {
        this.functionName = functionName;
        this.configurations = new UDTFConfigurations(zoneId);
    }

    public void beforeStart(String queryId, float collectorMemoryBudgetInMB, List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        this.reflectAndValidateUDF(childExpressions, childExpressionDataTypes, attributes);
        this.configurations.check();
        if (!AccessStrategy.AccessStrategyType.MAPPABLE_ROW_BY_ROW.equals((Object)this.configurations.getAccessStrategy().getAccessStrategyType())) {
            this.outputStorage = ElasticSerializableTVList.construct(UDFDataTypeTransformer.transformToTsDataType((Type)this.configurations.getOutputDataType()), queryId, collectorMemoryBudgetInMB, 1);
        }
    }

    private void reflectAndValidateUDF(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        this.udtf = (UDTF)UDFManagementService.getInstance().reflect(this.functionName);
        UDFParameters parameters = UDFParametersFactory.buildUdfParameters(childExpressions, childExpressionDataTypes, attributes);
        try {
            this.udtf.validate(new UDFParameterValidator(parameters));
        }
        catch (Exception e) {
            this.onError("validate(UDFParameterValidator)", e);
        }
        try {
            this.udtf.beforeStart(parameters, this.configurations);
        }
        catch (Exception e) {
            this.onError("beforeStart(UDFParameters, UDTFConfigurations)", e);
        }
    }

    public void execute(Row row, boolean isCurrentRowNull) {
        try {
            if (isCurrentRowNull) {
                this.collector.putNull(row.getTime());
            } else {
                this.udtf.transform(row, (PointCollector)this.collector);
            }
            TimeColumn timeColumn = this.collector.buildTimeColumn();
            Column valueColumn = this.collector.buildValueColumn();
            this.cachedColumns = new Column[]{valueColumn, timeColumn};
            this.outputStorage.putColumn(timeColumn, valueColumn);
        }
        catch (Exception e) {
            this.onError("transform(Row, PointCollector)", e);
        }
    }

    public void execute(Column[] columns, TimeColumnBuilder timeColumnBuilder, ColumnBuilder valueColumnBuilder) throws Exception {
        if (this.isFirstIter) {
            try {
                this.batchExecuteRow(columns, timeColumnBuilder, valueColumnBuilder);
                this.useBatch = true;
            }
            catch (UnsupportedOperationException e) {
                this.singleExecuteRow(columns, timeColumnBuilder, valueColumnBuilder);
                this.useBatch = false;
            }
            catch (Exception e) {
                this.onError("Mappable UDTF execution error", e);
            }
            this.isFirstIter = false;
        } else {
            try {
                if (this.useBatch) {
                    this.batchExecuteRow(columns, timeColumnBuilder, valueColumnBuilder);
                } else {
                    this.singleExecuteRow(columns, timeColumnBuilder, valueColumnBuilder);
                }
            }
            catch (Exception e) {
                this.onError("Mappable UDTF execution error", e);
            }
        }
    }

    private void singleExecuteRow(Column[] columns, TimeColumnBuilder timeColumnBuilder, ColumnBuilder valueColumnBuilder) throws Exception {
        int i;
        int colCount = columns.length;
        int rowCount = columns[0].getPositionCount();
        TSDataType[] dataTypes = new TSDataType[colCount];
        for (i = 0; i < colCount; ++i) {
            dataTypes[i] = columns[i].getDataType();
        }
        this.collector = new PointCollectorAdaptor((ColumnBuilder)timeColumnBuilder, valueColumnBuilder);
        for (i = 0; i < rowCount; ++i) {
            Object[] values = new Object[colCount];
            for (int j = 0; j < colCount; ++j) {
                values[j] = columns[j].isNull(i) ? null : columns[j].getObject(i);
            }
            RowImpl row = new RowImpl(dataTypes);
            row.setRowRecord(values);
            boolean isAllNull = InputRowUtils.isAllNull(values);
            if (isAllNull) {
                this.collector.putNull(row.getTime());
                continue;
            }
            this.udtf.transform((Row)row, (PointCollector)this.collector);
        }
        TimeColumn timeColumn = this.collector.buildTimeColumn();
        Column valueColumn = this.collector.buildValueColumn();
        if (timeColumn.getPositionCount() != 0) {
            this.cachedColumns = new Column[]{valueColumn, timeColumn};
            this.outputStorage.putColumn(timeColumn, valueColumn);
        } else {
            this.cachedColumns = null;
        }
    }

    private void batchExecuteRow(Column[] columns, TimeColumnBuilder timeColumnBuilder, ColumnBuilder valueColumnBuilder) throws Exception {
        this.udtf.transform(columns, (ColumnBuilder)timeColumnBuilder, valueColumnBuilder);
        Column timeColumn = timeColumnBuilder.build();
        Column valueColumn = valueColumnBuilder.build();
        if (timeColumn.getPositionCount() != 0) {
            this.cachedColumns = new Column[]{valueColumn, timeColumn};
            this.outputStorage.putColumn((TimeColumn)timeColumn, valueColumn);
        } else {
            this.cachedColumns = null;
        }
    }

    public void execute(RowWindow rowWindow, TimeColumnBuilder timeColumnBuilder, ColumnBuilder valueColumnBuilder) {
        try {
            this.collector = new PointCollectorAdaptor((ColumnBuilder)timeColumnBuilder, valueColumnBuilder);
            this.udtf.transform(rowWindow, (PointCollector)this.collector);
            TimeColumn timeColumn = this.collector.buildTimeColumn();
            Column valueColumn = this.collector.buildValueColumn();
            if (timeColumn.getPositionCount() != 0) {
                this.cachedColumns = new Column[]{valueColumn, timeColumn};
                this.outputStorage.putColumn(timeColumn, valueColumn);
            } else {
                this.cachedColumns = null;
            }
        }
        catch (Exception e) {
            this.onError("transform(RowWindow, PointCollector)", e);
        }
    }

    public void execute(Column[] columns, ColumnBuilder builder) {
        try {
            this.udtf.transform(columns, builder);
        }
        catch (Exception e) {
            this.onError("transform(TsBlock, ColumnBuilder)", e);
        }
    }

    public Column[] getCurrentBlock() {
        return this.cachedColumns;
    }

    public void terminate(TimeColumnBuilder timeColumnBuilder, ColumnBuilder valueColumnBuilder) {
        try {
            this.collector = new PointCollectorAdaptor((ColumnBuilder)timeColumnBuilder, valueColumnBuilder);
            this.udtf.terminate((PointCollector)this.collector);
            TimeColumn timeColumn = this.collector.buildTimeColumn();
            Column valueColumn = this.collector.buildValueColumn();
            if (valueColumn.getPositionCount() != 0) {
                this.cachedColumns = new Column[]{valueColumn, timeColumn};
                this.outputStorage.putColumn(timeColumn, valueColumn);
            }
        }
        catch (Exception e) {
            this.onError("terminate(PointCollector)", e);
        }
    }

    public void beforeDestroy() {
        if (this.udtf != null) {
            this.udtf.beforeDestroy();
        }
    }

    private void onError(String methodName, Exception e) {
        LOGGER.warn("Error occurred during executing UDTF, please check whether the implementation of UDF is correct according to the udf-api description.", (Throwable)e);
        throw new RuntimeException(String.format("Error occurred during executing UDTF#%s: %s, please check whether the implementation of UDF is correct according to the udf-api description.", methodName, System.lineSeparator()) + e);
    }

    public UDTFConfigurations getConfigurations() {
        return this.configurations;
    }

    public ElasticSerializableTVList getOutputStorage() {
        return this.outputStorage;
    }
}

