/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.ternary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.ternary.TernaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class CompareTernaryTransformer
extends TernaryTransformer {
    protected final Evaluator evaluator;

    protected CompareTernaryTransformer(LayerReader firstReader, LayerReader secondReader, LayerReader thirdReader) throws UnSupportedDataTypeException {
        super(firstReader, secondReader, thirdReader);
        this.evaluator = TSDataType.TEXT.equals((Object)this.firstReaderDataType) ? this.constructTextEvaluator() : this.constructNumberEvaluator();
    }

    protected abstract Evaluator constructNumberEvaluator();

    protected abstract Evaluator constructTextEvaluator();

    @Override
    protected final void checkType() {
        if (this.firstReaderDataType.equals((Object)this.secondReaderDataType) && this.firstReaderDataType.equals((Object)this.thirdReaderDataType)) {
            return;
        }
        if (this.firstReaderDataType.equals((Object)TSDataType.BOOLEAN) || this.secondReaderDataType.equals((Object)TSDataType.BOOLEAN) || this.thirdReaderDataType.equals((Object)TSDataType.BOOLEAN)) {
            throw new UnSupportedDataTypeException(TSDataType.BOOLEAN.toString());
        }
        if (this.firstReaderDataType.equals((Object)TSDataType.TEXT) || this.secondReaderDataType.equals((Object)TSDataType.TEXT) || this.thirdReaderDataType.equals((Object)TSDataType.TEXT)) {
            throw new UnSupportedDataTypeException(TSDataType.TEXT.toString());
        }
    }

    @Override
    protected final void transformAndCache(Column firstValues, int firstIndex, Column secondValues, int secondIndex, Column thirdValues, int thirdIndex, ColumnBuilder builder) throws QueryProcessException, IOException {
        builder.writeBoolean(this.evaluator.evaluate(firstValues, firstIndex, secondValues, secondIndex, thirdValues, thirdIndex));
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }

    @FunctionalInterface
    public static interface Evaluator {
        public boolean evaluate(Column var1, int var2, Column var3, int var4, Column var5, int var6) throws QueryProcessException, IOException;
    }
}

