/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.multi.UniversalUDFQueryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;

public class UDFQueryRowTransformer
extends UniversalUDFQueryTransformer {
    protected final LayerReader layerReader;

    public UDFQueryRowTransformer(LayerReader layerReader, UDTFExecutor executor) {
        super(executor);
        this.layerReader = layerReader;
    }

    @Override
    protected YieldableState tryExecuteUDFOnce() throws Exception {
        YieldableState yieldableState = this.layerReader.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        Column[] columns = this.layerReader.current();
        this.cachedColumns = this.execute(columns);
        this.layerReader.consumedAll();
        return YieldableState.YIELDABLE;
    }

    private Column[] execute(Column[] columns) throws Exception {
        int count = columns[0].getPositionCount();
        TimeColumnBuilder timeColumnBuilder = new TimeColumnBuilder(null, count);
        ColumnBuilder valueColumnBuilder = TypeUtils.initColumnBuilder(this.tsDataType, count);
        this.executor.execute(columns, timeColumnBuilder, valueColumnBuilder);
        return this.executor.getCurrentBlock();
    }
}

