/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InternalCreateTimeSeriesNode
extends WritePlanNode {
    private final PartialPath devicePath;
    private final MeasurementGroup measurementGroup;
    private final boolean isAligned;
    private TRegionReplicaSet regionReplicaSet;

    public InternalCreateTimeSeriesNode(PlanNodeId id, PartialPath devicePath, MeasurementGroup measurementGroup, boolean isAligned) {
        super(id);
        this.devicePath = devicePath;
        this.measurementGroup = measurementGroup;
        this.isAligned = isAligned;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public MeasurementGroup getMeasurementGroup() {
        return this.measurementGroup;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.INTERNAL_CREATE_TIME_SERIES;
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("Clone of InternalCreateTimeSeriesNode is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInternalCreateTimeSeries(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INTERNAL_CREATE_TIME_SERIES.serialize(byteBuffer);
        this.devicePath.serialize(byteBuffer);
        this.measurementGroup.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.INTERNAL_CREATE_TIME_SERIES.serialize(stream);
        this.devicePath.serialize((OutputStream)stream);
        this.measurementGroup.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (OutputStream)stream);
    }

    public static InternalCreateTimeSeriesNode deserialize(ByteBuffer byteBuffer) {
        PartialPath devicePath = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        MeasurementGroup measurementGroup = new MeasurementGroup();
        measurementGroup.deserialize(byteBuffer);
        boolean isAligned = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new InternalCreateTimeSeriesNode(planNodeId, devicePath, measurementGroup, isAligned);
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        TRegionReplicaSet regionReplicaSet = analysis.getSchemaPartitionInfo().getSchemaRegionReplicaSet(this.devicePath.getFullPath());
        this.setRegionReplicaSet(regionReplicaSet);
        return ImmutableList.of((Object)this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalCreateTimeSeriesNode that = (InternalCreateTimeSeriesNode)o;
        return Objects.equals(this.devicePath, that.devicePath) && Objects.equals(this.measurementGroup, that.measurementGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.devicePath, this.measurementGroup);
    }
}

