/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InExpression
extends UnaryExpression {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InExpression.class);
    private final boolean isNotIn;
    private final LinkedHashSet<String> values;

    public InExpression(Expression expression, boolean isNotIn, LinkedHashSet<String> values) {
        super(expression);
        this.isNotIn = isNotIn;
        this.values = values;
    }

    public InExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
        this.isNotIn = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.values = new LinkedHashSet();
        for (int i = 0; i < size; ++i) {
            this.values.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
    }

    public boolean isNotIn() {
        return this.isNotIn;
    }

    public LinkedHashSet<String> getValues() {
        return this.values;
    }

    @Override
    protected String getExpressionStringInternal() {
        String operator = this.isNotIn ? " NOT IN (" : " IN (";
        StringBuilder stringBuilder = new StringBuilder();
        if (this.expression instanceof FunctionExpression || this.expression instanceof LeafOperand) {
            stringBuilder.append(this.expression.getExpressionString()).append(operator);
        } else {
            stringBuilder.append('(').append(this.expression.getExpressionString()).append(')').append(operator);
        }
        return this.appendValuesToBuild(stringBuilder).toString();
    }

    @NotNull
    private StringBuilder appendValuesToBuild(StringBuilder stringBuilder) {
        Iterator iterator = this.values.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(',').append((String)iterator.next());
        }
        stringBuilder.append(')');
        return stringBuilder;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.IN;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isNotIn, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.values.size(), (ByteBuffer)byteBuffer);
        for (String value : this.values) {
            ReadWriteIOUtils.write((String)value, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isNotIn, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.values.size(), (OutputStream)stream);
        for (String value : this.values) {
            ReadWriteIOUtils.write((String)value, (OutputStream)stream);
        }
    }

    @Override
    public String getOutputSymbolInternal() {
        String operator = this.isNotIn ? " NOT IN (" : " IN (";
        StringBuilder stringBuilder = new StringBuilder();
        if (this.expression instanceof FunctionExpression || this.expression instanceof ConstantOperand || this.expression instanceof TimeSeriesOperand) {
            stringBuilder.append(this.expression.getOutputSymbol()).append(operator);
        } else {
            stringBuilder.append('(').append(this.expression.getOutputSymbol()).append(')').append(operator);
        }
        return this.appendValuesToBuild(stringBuilder).toString();
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInExpression(this, context);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.expression) + (this.values == null ? 0L : this.values.stream().mapToLong(RamUsageEstimator::sizeOf).sum());
    }
}

