/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.partition;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetDatabaseReq;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.partition.StorageGroupCacheResult;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaUtils;
import org.apache.iotdb.db.service.metrics.CacheMetrics;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCache {
    private static final Logger logger = LoggerFactory.getLogger(PartitionCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final List<String> ROOT_PATH = Arrays.asList("root", "**");
    private final String seriesSlotExecutorName = config.getSeriesPartitionExecutorClass();
    private final int seriesPartitionSlotNum = config.getSeriesPartitionSlotNum();
    private final SeriesPartitionExecutor partitionExecutor;
    private final int cacheSize = config.getPartitionCacheSize();
    private final Set<String> storageGroupCache = Collections.synchronizedSet(new HashSet());
    private final Cache<String, SchemaPartitionTable> schemaPartitionCache;
    private final Cache<String, DataPartitionTable> dataPartitionCache;
    private final AtomicLong latestUpdateTime = new AtomicLong(0L);
    private final Map<TConsensusGroupId, TRegionReplicaSet> groupIdToReplicaSetMap = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
    private final ReentrantReadWriteLock storageGroupCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock schemaPartitionCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock dataPartitionCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock regionReplicaSetLock = new ReentrantReadWriteLock();
    private final IClientManager<ConfigRegionId, ConfigNodeClient> configNodeClientManager = ConfigNodeClientManager.getInstance();
    private final CacheMetrics cacheMetrics;

    public PartitionCache() {
        this.schemaPartitionCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize).build();
        this.dataPartitionCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize).build();
        this.partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)this.seriesSlotExecutorName, (int)this.seriesPartitionSlotNum);
        this.cacheMetrics = new CacheMetrics();
    }

    public Map<String, List<String>> getStorageGroupToDevice(List<String> devicePaths, boolean tryToFetch, boolean isAutoCreate, String userName) {
        StorageGroupCacheResult<List<String>> result = new StorageGroupCacheResult<List<String>>(){

            @Override
            public void put(String device, String storageGroupName) {
                this.map.computeIfAbsent(storageGroupName, k -> new ArrayList());
                ((List)this.map.get(storageGroupName)).add(device);
            }
        };
        this.getStorageGroupCacheResult(result, devicePaths, tryToFetch, isAutoCreate, userName);
        return result.getMap();
    }

    public Map<String, String> getDeviceToStorageGroup(List<String> devicePaths, boolean tryToFetch, boolean isAutoCreate, String userName) {
        StorageGroupCacheResult<String> result = new StorageGroupCacheResult<String>(){

            @Override
            public void put(String device, String storageGroupName) {
                this.map.put(device, storageGroupName);
            }
        };
        this.getStorageGroupCacheResult(result, devicePaths, tryToFetch, isAutoCreate, userName);
        return result.getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStorageGroupName(String devicePath) {
        Set<String> set = this.storageGroupCache;
        synchronized (set) {
            for (String storageGroupName : this.storageGroupCache) {
                if (!PathUtils.isStartWith((String)devicePath, (String)storageGroupName)) continue;
                return storageGroupName;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchStorageGroupAndUpdateCache(StorageGroupCacheResult<?> result, List<String> devicePaths) throws ClientManagerException, TException {
        this.storageGroupCacheLock.writeLock().lock();
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetDatabaseReq req;
            TDatabaseSchemaResp storageGroupSchemaResp;
            result.reset();
            this.getStorageGroupMap(result, devicePaths, true);
            if (!result.isSuccess() && (storageGroupSchemaResp = client.getMatchedDatabaseSchemas(req = new TGetDatabaseReq(ROOT_PATH, SchemaConstant.ALL_MATCH_SCOPE_BINARY))).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                Set<String> storageGroupNames = storageGroupSchemaResp.getDatabaseSchemaMap().keySet();
                this.updateStorageCache(storageGroupNames);
                this.getStorageGroupMap(result, devicePaths, true);
            }
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStorageGroupAndUpdateCache(StorageGroupCacheResult<?> result, List<String> devicePaths, String userName) throws ClientManagerException, MetadataException, TException {
        block18: {
            this.storageGroupCacheLock.writeLock().lock();
            try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                result.reset();
                this.getStorageGroupMap(result, devicePaths, false);
                if (result.isSuccess()) break block18;
                HashSet<String> storageGroupNamesNeedCreated = new HashSet<String>();
                for (String devicePath : result.getMissedDevices()) {
                    if (devicePath.equals("root.__system") || devicePath.startsWith("root.__system.")) {
                        storageGroupNamesNeedCreated.add("root.__system");
                        continue;
                    }
                    PartialPath storageGroupNameNeedCreated = MetaUtils.getStorageGroupPathByLevel(new PartialPath(devicePath), config.getDefaultStorageGroupLevel());
                    storageGroupNamesNeedCreated.add(storageGroupNameNeedCreated.getFullPath());
                }
                HashSet<String> successFullyCreatedStorageGroup = new HashSet<String>();
                for (String storageGroupName : storageGroupNamesNeedCreated) {
                    long startTime = System.nanoTime();
                    try {
                        TSStatus status;
                        if (!AuthorityChecker.SUPER_USER.equals(userName) && (status = AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MANAGE_DATABASE.ordinal()), PrivilegeType.MANAGE_DATABASE)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new RuntimeException(new IoTDBException(status.getMessage(), status.getCode()));
                        }
                    }
                    finally {
                        PerformanceOverviewMetrics.getInstance().recordAuthCost(System.nanoTime() - startTime);
                    }
                    TDatabaseSchema storageGroupSchema = new TDatabaseSchema();
                    storageGroupSchema.setName(storageGroupName);
                    if ("root.__system".equals(storageGroupName)) {
                        storageGroupSchema.setMinSchemaRegionGroupNum(1);
                        storageGroupSchema.setMaxSchemaRegionGroupNum(1);
                        storageGroupSchema.setMaxDataRegionGroupNum(1);
                        storageGroupSchema.setMaxDataRegionGroupNum(1);
                    }
                    TSStatus tsStatus = client.setDatabase(storageGroupSchema);
                    if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                        successFullyCreatedStorageGroup.add(storageGroupName);
                        continue;
                    }
                    this.updateStorageCache(successFullyCreatedStorageGroup);
                    logger.warn("[{} Cache] failed to create database {}", (Object)"Database", (Object)storageGroupName);
                    throw new RuntimeException(new IoTDBException(tsStatus.message, tsStatus.code));
                }
                this.updateStorageCache(storageGroupNamesNeedCreated);
                this.getStorageGroupMap(result, devicePaths, false);
            }
            finally {
                this.storageGroupCacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStorageGroupMap(StorageGroupCacheResult<?> result, List<String> devicePaths, boolean failFast) {
        this.storageGroupCacheLock.readLock().lock();
        try {
            result.reset();
            boolean status = true;
            for (String devicePath : devicePaths) {
                String storageGroupName = this.getStorageGroupName(devicePath);
                if (null == storageGroupName) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{} Cache] miss when search device {}", (Object)"Database", (Object)devicePath);
                    }
                    status = false;
                    if (failFast) break;
                    result.addMissedDevice(devicePath);
                    continue;
                }
                result.put(devicePath, storageGroupName);
            }
            if (!status) {
                result.setFailed();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[{} Cache] hit when search device {}", (Object)"Database", devicePaths);
            }
            this.cacheMetrics.record(status, "Database");
        }
        finally {
            this.storageGroupCacheLock.readLock().unlock();
        }
    }

    private void getStorageGroupCacheResult(StorageGroupCacheResult<?> result, List<String> devicePaths, boolean tryToFetch, boolean isAutoCreate, String userName) {
        if (!isAutoCreate) {
            for (String devicePath : devicePaths) {
                if (!devicePath.contains("*")) continue;
                return;
            }
        }
        this.getStorageGroupMap(result, devicePaths, true);
        if (!result.isSuccess() && tryToFetch) {
            try {
                this.fetchStorageGroupAndUpdateCache(result, devicePaths);
                if (!result.isSuccess() && isAutoCreate) {
                    this.createStorageGroupAndUpdateCache(result, devicePaths, userName);
                    if (!result.isSuccess()) {
                        throw new StatementAnalyzeException("Failed to get database Map");
                    }
                }
            }
            catch (MetadataException e) {
                throw new IoTDBRuntimeException("An error occurred when executing getDeviceToDatabase():" + e.getMessage(), e.getErrorCode());
            }
            catch (ClientManagerException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getDeviceToDatabase():" + e.getMessage(), e);
            }
        }
    }

    public void updateStorageCache(Set<String> storageGroupNames) {
        this.storageGroupCacheLock.writeLock().lock();
        try {
            this.storageGroupCache.addAll(storageGroupNames);
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromStorageGroupCache(List<String> storageGroupNames) {
        this.storageGroupCacheLock.writeLock().lock();
        try {
            for (String storageGroupName : storageGroupNames) {
                this.storageGroupCache.remove(storageGroupName);
            }
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    public void removeFromStorageGroupCache() {
        this.storageGroupCacheLock.writeLock().lock();
        try {
            this.storageGroupCache.clear();
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TRegionReplicaSet> getRegionReplicaSet(List<TConsensusGroupId> consensusGroupIds) {
        List<TRegionReplicaSet> result;
        block20: {
            if (consensusGroupIds.isEmpty()) {
                return Collections.emptyList();
            }
            this.regionReplicaSetLock.readLock().lock();
            try {
                result = this.getRegionReplicaSetInternal(consensusGroupIds);
            }
            finally {
                this.regionReplicaSetLock.readLock().unlock();
            }
            if (result.isEmpty()) {
                this.regionReplicaSetLock.writeLock().lock();
                try {
                    result = this.getRegionReplicaSetInternal(consensusGroupIds);
                    if (!result.isEmpty()) break block20;
                    try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                        TRegionRouteMapResp resp = client.getLatestRegionRouteMap();
                        if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == resp.getStatus().getCode()) {
                            this.updateGroupIdToReplicaSetMap(resp.getTimestamp(), resp.getRegionRouteMap());
                        } else {
                            logger.warn("Unexpected error when getRegionReplicaSet: status {}\uff0c regionMap: {}", (Object)resp.getStatus(), (Object)resp.getRegionRouteMap());
                        }
                        result = this.getRegionReplicaSetInternal(consensusGroupIds);
                        if (result.isEmpty()) {
                            throw new RuntimeException("Failed to get replicaSet of consensus groups[ids= " + consensusGroupIds + "]");
                        }
                    }
                    catch (ClientManagerException | TException e) {
                        throw new StatementAnalyzeException("An error occurred when executing getRegionReplicaSet():" + e.getMessage());
                    }
                }
                finally {
                    this.regionReplicaSetLock.writeLock().unlock();
                }
            }
        }
        return result;
    }

    private List<TRegionReplicaSet> getRegionReplicaSetInternal(List<TConsensusGroupId> consensusGroupIds) {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>(consensusGroupIds.size());
        for (TConsensusGroupId groupId : consensusGroupIds) {
            TRegionReplicaSet replicaSet = this.groupIdToReplicaSetMap.get(groupId);
            if (replicaSet != null) {
                result.add(replicaSet);
                continue;
            }
            return Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGroupIdToReplicaSetMap(long timestamp, Map<TConsensusGroupId, TRegionReplicaSet> map) {
        this.regionReplicaSetLock.writeLock().lock();
        try {
            boolean result;
            boolean bl = result = timestamp == this.latestUpdateTime.accumulateAndGet(timestamp, Math::max);
            if (result) {
                this.groupIdToReplicaSetMap.clear();
                this.groupIdToReplicaSetMap.putAll(map);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.regionReplicaSetLock.writeLock().unlock();
        }
    }

    public void invalidReplicaSetCache() {
        this.regionReplicaSetLock.writeLock().lock();
        try {
            this.groupIdToReplicaSetMap.clear();
        }
        finally {
            this.regionReplicaSetLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartition getSchemaPartition(Map<String, List<String>> storageGroupToDeviceMap) {
        this.schemaPartitionCacheLock.readLock().lock();
        try {
            if (storageGroupToDeviceMap.size() == 0) {
                this.cacheMetrics.record(false, "SchemaPartition");
                SchemaPartition schemaPartition = null;
                return schemaPartition;
            }
            HashMap<String, Map> schemaPartitionMap = new HashMap<String, Map>();
            for (Map.Entry<String, List<String>> entry : storageGroupToDeviceMap.entrySet()) {
                String storageGroupName = entry.getKey();
                Map regionReplicaSetMap = schemaPartitionMap.computeIfAbsent(storageGroupName, k -> new HashMap());
                SchemaPartitionTable schemaPartitionTable = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)storageGroupName);
                if (null == schemaPartitionTable) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{} Cache] miss when search database {}", (Object)"SchemaPartition", (Object)storageGroupName);
                    }
                    this.cacheMetrics.record(false, "SchemaPartition");
                    SchemaPartition schemaPartition = null;
                    return schemaPartition;
                }
                Map map = schemaPartitionTable.getSchemaPartitionMap();
                ArrayList<TSeriesPartitionSlot> seriesPartitionSlots = new ArrayList<TSeriesPartitionSlot>(entry.getValue().size());
                ArrayList<TConsensusGroupId> consensusGroupIds = new ArrayList<TConsensusGroupId>(entry.getValue().size());
                for (String device : entry.getValue()) {
                    TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(device);
                    if (!map.containsKey(seriesPartitionSlot)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("[{} Cache] miss when search device {}", (Object)"SchemaPartition", (Object)device);
                        }
                        this.cacheMetrics.record(false, "SchemaPartition");
                        SchemaPartition schemaPartition = null;
                        return schemaPartition;
                    }
                    seriesPartitionSlots.add(seriesPartitionSlot);
                    consensusGroupIds.add((TConsensusGroupId)map.get(seriesPartitionSlot));
                }
                List<TRegionReplicaSet> replicaSets = this.getRegionReplicaSet(consensusGroupIds);
                for (int i = 0; i < replicaSets.size(); ++i) {
                    regionReplicaSetMap.put((TSeriesPartitionSlot)seriesPartitionSlots.get(i), replicaSets.get(i));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[{} Cache] hit", (Object)"SchemaPartition");
            }
            this.cacheMetrics.record(true, "SchemaPartition");
            SchemaPartition schemaPartition = new SchemaPartition(schemaPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return schemaPartition;
        }
        finally {
            this.schemaPartitionCacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchemaPartitionCache(Map<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> schemaPartitionTable) {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            for (Map.Entry<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> entry1 : schemaPartitionTable.entrySet()) {
                String storageGroupName = entry1.getKey();
                SchemaPartitionTable result = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)storageGroupName);
                if (null == result) {
                    result = new SchemaPartitionTable();
                    this.schemaPartitionCache.put((Object)storageGroupName, (Object)result);
                }
                Map seriesPartitionSlotTConsensusGroupIdMap = result.getSchemaPartitionMap();
                seriesPartitionSlotTConsensusGroupIdMap.putAll(entry1.getValue());
            }
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidSchemaPartitionCache(String storageGroupName) {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            this.schemaPartitionCache.invalidate((Object)storageGroupName);
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllSchemaPartitionCache() {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            this.schemaPartitionCache.invalidateAll();
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> storageGroupToQueryParamsMap) {
        this.dataPartitionCacheLock.readLock().lock();
        try {
            if (storageGroupToQueryParamsMap.isEmpty()) {
                this.cacheMetrics.record(false, "DataPartition");
                DataPartition dataPartition = null;
                return dataPartition;
            }
            HashSet<TConsensusGroupId> allConsensusGroupIds = new HashSet<TConsensusGroupId>();
            HashMap<TConsensusGroupId, HashSet> consensusGroupToTimeSlotMap = new HashMap<TConsensusGroupId, HashSet>();
            for (Map.Entry<String, List<DataPartitionQueryParam>> entry : storageGroupToQueryParamsMap.entrySet()) {
                String databaseName = entry.getKey();
                List<DataPartitionQueryParam> params = entry.getValue();
                if (null == params || params.isEmpty()) {
                    this.cacheMetrics.record(false, "DataPartition");
                    DataPartition dataPartition = null;
                    return dataPartition;
                }
                DataPartitionTable dataPartitionTable = (DataPartitionTable)this.dataPartitionCache.getIfPresent((Object)databaseName);
                if (null == dataPartitionTable) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("[{} Cache] miss when search database {}", (Object)"DataPartition", (Object)databaseName);
                    }
                    this.cacheMetrics.record(false, "DataPartition");
                    DataPartition dataPartition = null;
                    return dataPartition;
                }
                Map cachedDatabasePartitionMap = dataPartitionTable.getDataPartitionMap();
                for (DataPartitionQueryParam param : params) {
                    if (null == param.getDevicePath()) {
                        DataPartition dataPartition = null;
                        return dataPartition;
                    }
                    TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(param.getDevicePath());
                    SeriesPartitionTable cachedSeriesPartitionTable = (SeriesPartitionTable)cachedDatabasePartitionMap.get(seriesPartitionSlot);
                    if (null == cachedSeriesPartitionTable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("[{} Cache] miss when search device {}", (Object)"DataPartition", (Object)param.getDevicePath());
                        }
                        this.cacheMetrics.record(false, "DataPartition");
                        DataPartition dataPartition = null;
                        return dataPartition;
                    }
                    Map cachedTimePartitionSlot = cachedSeriesPartitionTable.getSeriesPartitionMap();
                    if (param.getTimePartitionSlotList().isEmpty()) {
                        Iterator iterator = null;
                        return iterator;
                    }
                    for (TTimePartitionSlot timePartitionSlot : param.getTimePartitionSlotList()) {
                        List cacheConsensusGroupIds = (List)cachedTimePartitionSlot.get(timePartitionSlot);
                        if (null == cacheConsensusGroupIds || cacheConsensusGroupIds.isEmpty() || null == timePartitionSlot) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("[{} Cache] miss when search time partition {}", (Object)"DataPartition", (Object)timePartitionSlot);
                            }
                            this.cacheMetrics.record(false, "DataPartition");
                            Iterator iterator = null;
                            return iterator;
                        }
                        for (TConsensusGroupId groupId : cacheConsensusGroupIds) {
                            allConsensusGroupIds.add(groupId);
                            consensusGroupToTimeSlotMap.computeIfAbsent(groupId, k -> new HashSet()).add(new TimeSlotRegionInfo(databaseName, seriesPartitionSlot, timePartitionSlot));
                        }
                    }
                }
            }
            ArrayList<TConsensusGroupId> consensusGroupIds = new ArrayList<TConsensusGroupId>(allConsensusGroupIds);
            List<TRegionReplicaSet> allRegionReplicaSets = this.getRegionReplicaSet(consensusGroupIds);
            HashMap<String, Map> dataPartitionMap = new HashMap<String, Map>();
            for (int i = 0; i < allRegionReplicaSets.size(); ++i) {
                TConsensusGroupId groupId = (TConsensusGroupId)consensusGroupIds.get(i);
                TRegionReplicaSet replicaSet = allRegionReplicaSets.get(i);
                for (TimeSlotRegionInfo info : (HashSet)consensusGroupToTimeSlotMap.get(groupId)) {
                    dataPartitionMap.computeIfAbsent(info.databaseName, k -> new HashMap()).computeIfAbsent(info.seriesPartitionSlot, k -> new HashMap()).computeIfAbsent(info.timePartitionSlot, k -> new ArrayList()).add(replicaSet);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("[{} Cache] hit", (Object)"DataPartition");
            }
            this.cacheMetrics.record(true, "DataPartition");
            DataPartition dataPartition = new DataPartition(dataPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return dataPartition;
        }
        finally {
            this.dataPartitionCacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataPartitionCache(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> dataPartitionTable) {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            for (Map.Entry<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> entry1 : dataPartitionTable.entrySet()) {
                boolean needToUpdateCache;
                String storageGroupName = entry1.getKey();
                if (null == storageGroupName) continue;
                DataPartitionTable result = (DataPartitionTable)this.dataPartitionCache.getIfPresent((Object)storageGroupName);
                boolean bl = needToUpdateCache = null == result;
                if (needToUpdateCache) {
                    result = new DataPartitionTable();
                }
                Map seriesPartitionSlotSeriesPartitionTableMap = result.getDataPartitionMap();
                for (Map.Entry<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>> entry2 : entry1.getValue().entrySet()) {
                    SeriesPartitionTable seriesPartitionTable;
                    TSeriesPartitionSlot seriesPartitionSlot = entry2.getKey();
                    if (null == seriesPartitionSlot) continue;
                    if (!seriesPartitionSlotSeriesPartitionTableMap.containsKey(seriesPartitionSlot)) {
                        seriesPartitionTable = new SeriesPartitionTable(entry2.getValue());
                        seriesPartitionSlotSeriesPartitionTableMap.put(seriesPartitionSlot, seriesPartitionTable);
                        continue;
                    }
                    seriesPartitionTable = (SeriesPartitionTable)seriesPartitionSlotSeriesPartitionTableMap.get(seriesPartitionSlot);
                    Map result3 = seriesPartitionTable.getSeriesPartitionMap();
                    result3.putAll(entry2.getValue());
                }
                if (!needToUpdateCache) continue;
                this.dataPartitionCache.put((Object)storageGroupName, (Object)result);
            }
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidDataPartitionCache(String storageGroup) {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            this.dataPartitionCache.invalidate((Object)storageGroup);
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllDataPartitionCache() {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            this.dataPartitionCache.invalidateAll();
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllCache() {
        if (logger.isDebugEnabled()) {
            logger.debug("[Partition Cache] invalid");
        }
        this.removeFromStorageGroupCache();
        this.invalidAllDataPartitionCache();
        this.invalidAllSchemaPartitionCache();
        this.invalidReplicaSetCache();
        if (logger.isDebugEnabled()) {
            logger.debug("[Partition Cache] is invalid:{}", (Object)this);
        }
    }

    public String toString() {
        return "PartitionCache{cacheSize=" + this.cacheSize + ", storageGroupCache=" + this.storageGroupCache + ", replicaSetCache=" + this.groupIdToReplicaSetMap + ", schemaPartitionCache=" + this.schemaPartitionCache + ", dataPartitionCache=" + this.dataPartitionCache + '}';
    }

    private static class TimeSlotRegionInfo {
        final String databaseName;
        final TSeriesPartitionSlot seriesPartitionSlot;
        final TTimePartitionSlot timePartitionSlot;

        TimeSlotRegionInfo(String databaseName, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot) {
            this.databaseName = databaseName;
            this.seriesPartitionSlot = seriesPartitionSlot;
            this.timePartitionSlot = timePartitionSlot;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSlotRegionInfo that = (TimeSlotRegionInfo)o;
            return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.seriesPartitionSlot, that.seriesPartitionSlot) && Objects.equals(this.timePartitionSlot, that.timePartitionSlot);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.databaseName);
            result = 31 * result + Objects.hashCode(this.seriesPartitionSlot);
            result = 31 * result + Objects.hashCode(this.timePartitionSlot);
            return result;
        }
    }
}

