/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.metric;

import java.util.Arrays;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class QueryPlanCostMetricSet
implements IMetricSet {
    private static final QueryPlanCostMetricSet INSTANCE = new QueryPlanCostMetricSet();
    public static final String ANALYZER = "analyzer";
    public static final String LOGICAL_PLANNER = "logical_planner";
    public static final String DISTRIBUTION_PLANNER = "distribution_planner";
    public static final String PARTITION_FETCHER = "partition_fetcher";
    public static final String SCHEMA_FETCHER = "schema_fetcher";
    private Timer analyzerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer logicalPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer distributionPlannerTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer partitionFetcherTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer schemaFetcherTimer = DoNothingMetricManager.DO_NOTHING_TIMER;

    private QueryPlanCostMetricSet() {
    }

    public void recordPlanCost(String stage, long costTimeInNanos) {
        switch (stage) {
            case "analyzer": {
                this.analyzerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "logical_planner": {
                this.logicalPlannerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "distribution_planner": {
                this.distributionPlannerTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "partition_fetcher": {
                this.partitionFetcherTimer.updateNanos(costTimeInNanos);
                break;
            }
            case "schema_fetcher": {
                this.schemaFetcherTimer.updateNanos(costTimeInNanos);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported stage: " + stage);
            }
        }
    }

    public void bindTo(AbstractMetricService metricService) {
        this.analyzerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), ANALYZER});
        this.logicalPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), LOGICAL_PLANNER});
        this.distributionPlannerTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), DISTRIBUTION_PLANNER});
        this.partitionFetcherTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), PARTITION_FETCHER});
        this.schemaFetcherTimer = metricService.getOrCreateTimer(Metric.QUERY_PLAN_COST.toString(), MetricLevel.IMPORTANT, new String[]{Tag.STAGE.toString(), SCHEMA_FETCHER});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Arrays.asList(ANALYZER, LOGICAL_PLANNER, DISTRIBUTION_PLANNER, PARTITION_FETCHER, SCHEMA_FETCHER).forEach(stage -> metricService.remove(MetricType.TIMER, Metric.QUERY_PLAN_COST.toString(), new String[]{Tag.STAGE.toString(), stage}));
    }

    public static QueryPlanCostMetricSet getInstance() {
        return INSTANCE;
    }
}

