/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.queryengine.common.TimeseriesContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractRegionScanForActiveDataUtil;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractDeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.DeviceStartEndTime;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileDeviceStartEndTimeIterator;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.RamUsageEstimator;

public class RegionScanForActiveTimeSeriesUtil
extends AbstractRegionScanForActiveDataUtil {
    private final Map<IDeviceID, Set<String>> timeSeriesForCurrentTsFile;
    private final Map<IDeviceID, List<String>> activeTimeSeries;
    private final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Map.class) + RamUsageEstimator.shallowSizeOfInstance(Map.class);

    public RegionScanForActiveTimeSeriesUtil(Filter timeFilter, Map<IDeviceID, Long> ttlCache) {
        super(timeFilter, ttlCache);
        this.timeSeriesForCurrentTsFile = new HashMap<IDeviceID, Set<String>>();
        this.activeTimeSeries = new HashMap<IDeviceID, List<String>>();
    }

    public boolean nextTsFileHandle(Map<IDeviceID, Map<String, TimeseriesContext>> targetTimeseries) throws IOException {
        if (!this.queryDataSource.hasNext()) {
            return false;
        }
        this.curFileScanHandle = this.queryDataSource.next();
        this.deviceChunkMetaDataIterator = null;
        TsFileDeviceStartEndTimeIterator iterator = this.curFileScanHandle.getDeviceStartEndTimeIterator();
        while (iterator.hasNext()) {
            DeviceStartEndTime deviceStartEndTime = iterator.next();
            IDeviceID deviceID = deviceStartEndTime.getDevicePath();
            long startTime = deviceStartEndTime.getStartTime();
            long endTime = deviceStartEndTime.getEndTime();
            if (!targetTimeseries.containsKey(deviceID) || endTime >= 0L && !this.timeFilter.satisfyStartEndTime(startTime, endTime, deviceID)) continue;
            this.timeSeriesForCurrentTsFile.put(deviceID, new HashSet<String>(targetTimeseries.get(deviceID).keySet()));
        }
        return true;
    }

    @Override
    public boolean isCurrentTsFileFinished() {
        return this.timeSeriesForCurrentTsFile.isEmpty();
    }

    @Override
    public void processDeviceChunkMetadata(AbstractDeviceChunkMetaData deviceChunkMetaData) throws IllegalPathException {
        if (this.timeSeriesForCurrentTsFile.containsKey(deviceChunkMetaData.getDevicePath())) {
            this.checkChunkMetaDataOfTimeSeries(deviceChunkMetaData.getDevicePath(), deviceChunkMetaData);
        }
    }

    @Override
    public boolean isCurrentChunkHandleValid() {
        IDeviceID deviceID = this.currentChunkHandle.getDeviceID();
        String measurementId = this.currentChunkHandle.getMeasurement();
        Set<String> measurements = this.timeSeriesForCurrentTsFile.get(deviceID);
        return measurements != null && measurements.contains(measurementId);
    }

    @Override
    public void processActiveChunk(IDeviceID deviceID, String measurementPath) {
        this.removeTimeSeriesForCurrentTsFile(deviceID, measurementPath);
        this.activeTimeSeries.computeIfAbsent(deviceID, k -> new ArrayList()).add(measurementPath);
        this.currentChunkHandle = null;
    }

    @Override
    public void finishCurrentFile() {
        super.finishCurrentFile();
        this.queryDataSource.releaseFileScanHandle();
        this.timeSeriesForCurrentTsFile.clear();
        this.activeTimeSeries.clear();
    }

    private void checkChunkMetaDataOfTimeSeries(IDeviceID deviceID, AbstractDeviceChunkMetaData deviceChunkMetaData) throws IllegalPathException {
        ArrayList<AbstractChunkOffset> chunkOffsetsForCurrentDevice = new ArrayList<AbstractChunkOffset>();
        ArrayList<Statistics> chunkStatisticsForCurrentDevice = new ArrayList<Statistics>();
        while (deviceChunkMetaData.hasNextValueChunkMetadata()) {
            IChunkMetadata valueChunkMetaData = deviceChunkMetaData.nextValueChunkMetadata();
            String measurementId = valueChunkMetaData.getMeasurementUid();
            long startTime = valueChunkMetaData.getStartTime();
            long endTime = valueChunkMetaData.getEndTime();
            Set<String> measurementForCurrentTsFile = this.timeSeriesForCurrentTsFile.get(deviceID);
            if (measurementForCurrentTsFile == null || !measurementForCurrentTsFile.contains(measurementId) || !this.timeFilter.satisfyStartEndTime(startTime, endTime, deviceID)) continue;
            if (this.timeFilter.satisfy(startTime, deviceID) && !this.curFileScanHandle.isTimeSeriesTimeDeleted(deviceID, measurementId, startTime) || this.timeFilter.satisfy(endTime, deviceID) && !this.curFileScanHandle.isTimeSeriesTimeDeleted(deviceID, measurementId, endTime)) {
                this.removeTimeSeriesForCurrentTsFile(deviceID, measurementId);
                this.activeTimeSeries.computeIfAbsent(deviceID, k -> new ArrayList()).add(measurementId);
                continue;
            }
            chunkOffsetsForCurrentDevice.add(deviceChunkMetaData.getChunkOffset());
            chunkStatisticsForCurrentDevice.add(valueChunkMetaData.getStatistics());
        }
        this.chunkToBeScanned.addAll(chunkOffsetsForCurrentDevice);
        this.chunkStatistics.addAll(chunkStatisticsForCurrentDevice);
    }

    public Map<IDeviceID, List<String>> getActiveTimeSeries() {
        return this.activeTimeSeries;
    }

    private void removeTimeSeriesForCurrentTsFile(IDeviceID deviceID, String measurementPath) {
        Set<String> measurements = this.timeSeriesForCurrentTsFile.get(deviceID);
        if (measurements != null) {
            measurements.remove(measurementPath);
            if (measurements.isEmpty()) {
                this.timeSeriesForCurrentTsFile.remove(deviceID);
                this.timeFilter.removeTTLCache(deviceID);
            }
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.INSTANCE_SIZE + super.ramBytesUsed();
    }
}

