/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SchemaQueryMergeOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SchemaQueryMergeOperator.class);
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private int currentIndex;

    public SchemaQueryMergeOperator(OperatorContext operatorContext, List<Operator> children) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.currentIndex = 0;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.children.get(this.currentIndex).hasNextWithTimer()) {
            return this.children.get(this.currentIndex).nextWithTimer();
        }
        ++this.currentIndex;
        return null;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.currentIndex < this.children.size();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.currentIndex < this.children.size() ? this.children.get(this.currentIndex).isBlocked() : NOT_BLOCKED;
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext);
    }
}

