/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.transformation.dag.column.CaseWhenThenColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.IdentityColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.multi.MappableUDFColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ternary.TernaryColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;

public class FilterAndProjectOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FilterAndProjectOperator.class);
    private final Operator inputOperator;
    private final List<LeafColumnTransformer> filterLeafColumnTransformerList;
    private final ColumnTransformer filterOutputTransformer;
    private final List<ColumnTransformer> commonTransformerList;
    private final List<LeafColumnTransformer> projectLeafColumnTransformerList;
    private final List<ColumnTransformer> projectOutputTransformerList;
    private final TsBlockBuilder filterTsBlockBuilder;
    private final boolean hasNonMappableUDF;
    private final OperatorContext operatorContext;
    private final boolean hasFilter;
    private long filteredRowCount = 0L;

    public FilterAndProjectOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> filterOutputDataTypes, List<LeafColumnTransformer> filterLeafColumnTransformerList, ColumnTransformer filterOutputTransformer, List<ColumnTransformer> commonTransformerList, List<LeafColumnTransformer> projectLeafColumnTransformerList, List<ColumnTransformer> projectOutputTransformerList, boolean hasNonMappableUDF, boolean hasFilter) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.filterLeafColumnTransformerList = filterLeafColumnTransformerList;
        this.filterOutputTransformer = filterOutputTransformer;
        this.commonTransformerList = commonTransformerList;
        this.projectLeafColumnTransformerList = projectLeafColumnTransformerList;
        this.projectOutputTransformerList = projectOutputTransformerList;
        this.hasNonMappableUDF = hasNonMappableUDF;
        this.filterTsBlockBuilder = new TsBlockBuilder(8, filterOutputDataTypes);
        this.hasFilter = hasFilter;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock input = this.inputOperator.nextWithTimer();
        if (input == null) {
            return null;
        }
        if (!this.hasFilter) {
            return this.getTransformedTsBlock(input);
        }
        long inputRowCount = input.getPositionCount();
        TsBlock filterResult = this.getFilterTsBlock(input);
        this.filteredRowCount += inputRowCount - (long)filterResult.getPositionCount();
        this.operatorContext.recordSpecifiedInfo("Filtered Rows", Long.toString(this.filteredRowCount));
        if (this.hasNonMappableUDF) {
            return filterResult;
        }
        return this.getTransformedTsBlock(filterResult);
    }

    private TsBlock getFilterTsBlock(TsBlock input) {
        TimeColumn originTimeColumn = input.getTimeColumn();
        int positionCount = originTimeColumn.getPositionCount();
        for (LeafColumnTransformer leafColumnTransformer : this.filterLeafColumnTransformerList) {
            leafColumnTransformer.initFromTsBlock(input);
        }
        this.filterOutputTransformer.tryEvaluate();
        Column filterColumn = this.filterOutputTransformer.getColumn();
        this.filterTsBlockBuilder.reset();
        TimeColumnBuilder timeBuilder = this.filterTsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = this.filterTsBlockBuilder.getValueColumnBuilders();
        ArrayList<Column> resultColumns = new ArrayList<Column>();
        int n = input.getValueColumnCount();
        for (int i = 0; i < n; ++i) {
            resultColumns.add(input.getColumn(i));
        }
        if (!this.hasNonMappableUDF) {
            for (ColumnTransformer columnTransformer : this.commonTransformerList) {
                resultColumns.add(columnTransformer.getColumn());
            }
        }
        int rowCount = this.constructFilteredTsBlock(resultColumns, timeBuilder, filterColumn, originTimeColumn, columnBuilders, positionCount);
        this.filterTsBlockBuilder.declarePositions(rowCount);
        return this.filterTsBlockBuilder.build();
    }

    private int constructFilteredTsBlock(List<Column> resultColumns, TimeColumnBuilder timeBuilder, Column filterColumn, TimeColumn originTimeColumn, ColumnBuilder[] columnBuilders, int positionCount) {
        int rowCount = 0;
        int n = resultColumns.size();
        for (int i = 0; i < n; ++i) {
            Column curColumn = resultColumns.get(i);
            for (int j = 0; j < positionCount; ++j) {
                if (!this.satisfy(filterColumn, j)) continue;
                if (i == 0) {
                    ++rowCount;
                    timeBuilder.writeLong(originTimeColumn.getLong(j));
                }
                if (curColumn.isNull(j)) {
                    columnBuilders[i].appendNull();
                    continue;
                }
                columnBuilders[i].write(curColumn, j);
            }
        }
        return rowCount;
    }

    private boolean satisfy(Column filterColumn, int rowIndex) {
        return !filterColumn.isNull(rowIndex) && filterColumn.getBoolean(rowIndex);
    }

    private TsBlock getTransformedTsBlock(TsBlock input) {
        TimeColumn originTimeColumn = input.getTimeColumn();
        int positionCount = originTimeColumn.getPositionCount();
        for (LeafColumnTransformer leafColumnTransformer : this.projectLeafColumnTransformerList) {
            leafColumnTransformer.initFromTsBlock(input);
        }
        ArrayList<Column> resultColumns = new ArrayList<Column>();
        for (ColumnTransformer columnTransformer : this.projectOutputTransformerList) {
            columnTransformer.tryEvaluate();
            resultColumns.add(columnTransformer.getColumn());
        }
        return TsBlock.wrapBlocksWithoutCopy((int)positionCount, (TimeColumn)originTimeColumn, (Column[])resultColumns.toArray(new Column[0]));
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.inputOperator.hasNextWithTimer();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.inputOperator.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.inputOperator.isBlocked();
    }

    @Override
    public void close() throws Exception {
        for (ColumnTransformer columnTransformer : this.projectOutputTransformerList) {
            columnTransformer.close();
        }
        if (this.filterOutputTransformer != null) {
            this.filterOutputTransformer.close();
        }
        this.inputOperator.close();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = this.inputOperator.calculateMaxReturnSize();
        int maxCachedColumn = 0;
        if (!this.hasFilter) {
            for (int i = 0; i < this.projectOutputTransformerList.size(); ++i) {
                ColumnTransformer c = this.projectOutputTransformerList.get(i);
                maxCachedColumn = Math.max(maxCachedColumn, 1 + i + this.getMaxLevelOfColumnTransformerTree(c));
            }
            return Math.max(maxPeekMemory, (long)maxCachedColumn * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()) + this.inputOperator.calculateRetainedSizeAfterCallingNext();
        }
        maxCachedColumn = Math.max(1 + this.getMaxLevelOfColumnTransformerTree(this.filterOutputTransformer), 1 + this.commonTransformerList.size());
        if (!this.hasNonMappableUDF) {
            for (int i = 0; i < this.projectOutputTransformerList.size(); ++i) {
                ColumnTransformer c = this.projectOutputTransformerList.get(i);
                maxCachedColumn = Math.max(maxCachedColumn, 1 + i + this.getMaxLevelOfColumnTransformerTree(c));
            }
        }
        return Math.max(maxPeekMemory, (long)maxCachedColumn * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()) + this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        if (!this.hasFilter || !this.hasNonMappableUDF) {
            return (long)(1 + this.projectOutputTransformerList.size()) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        }
        return (long)(1 + this.filterTsBlockBuilder.getValueColumnBuilders().length) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    private int getMaxLevelOfColumnTransformerTree(ColumnTransformer columnTransformer) {
        if (columnTransformer instanceof LeafColumnTransformer) {
            if (columnTransformer instanceof IdentityColumnTransformer) {
                return 1;
            }
            return 0;
        }
        if (columnTransformer instanceof UnaryColumnTransformer) {
            return Math.max(2, this.getMaxLevelOfColumnTransformerTree(((UnaryColumnTransformer)columnTransformer).getChildColumnTransformer()));
        }
        if (columnTransformer instanceof BinaryColumnTransformer) {
            int childMaxLevel = Math.max(this.getMaxLevelOfColumnTransformerTree(((BinaryColumnTransformer)columnTransformer).getLeftTransformer()), this.getMaxLevelOfColumnTransformerTree(((BinaryColumnTransformer)columnTransformer).getRightTransformer()));
            return Math.max(3, childMaxLevel);
        }
        if (columnTransformer instanceof TernaryColumnTransformer) {
            int childMaxLevel = Math.max(this.getMaxLevelOfColumnTransformerTree(((TernaryColumnTransformer)columnTransformer).getFirstColumnTransformer()), Math.max(this.getMaxLevelOfColumnTransformerTree(((TernaryColumnTransformer)columnTransformer).getSecondColumnTransformer()), this.getMaxLevelOfColumnTransformerTree(((TernaryColumnTransformer)columnTransformer).getThirdColumnTransformer())));
            return Math.max(4, childMaxLevel);
        }
        if (columnTransformer instanceof MappableUDFColumnTransformer) {
            int childMaxLevel = 0;
            for (ColumnTransformer c : ((MappableUDFColumnTransformer)columnTransformer).getInputColumnTransformers()) {
                childMaxLevel = Math.max(childMaxLevel, this.getMaxLevelOfColumnTransformerTree(c));
            }
            return Math.max(1 + ((MappableUDFColumnTransformer)columnTransformer).getInputColumnTransformers().length, childMaxLevel);
        }
        if (columnTransformer instanceof CaseWhenThenColumnTransformer) {
            int childMaxLevel = 0;
            int childCount = 0;
            for (Pair<ColumnTransformer, ColumnTransformer> whenThenColumnTransformer : ((CaseWhenThenColumnTransformer)columnTransformer).getWhenThenColumnTransformers()) {
                childMaxLevel = Math.max(childMaxLevel, this.getMaxLevelOfColumnTransformerTree((ColumnTransformer)whenThenColumnTransformer.left));
                childMaxLevel = Math.max(childMaxLevel, this.getMaxLevelOfColumnTransformerTree((ColumnTransformer)whenThenColumnTransformer.right));
                ++childCount;
            }
            childMaxLevel = Math.max(childMaxLevel, this.getMaxLevelOfColumnTransformerTree(((CaseWhenThenColumnTransformer)columnTransformer).getElseTransformer()));
            childMaxLevel = Math.max(childMaxLevel, childCount + 2);
            return childMaxLevel;
        }
        throw new UnsupportedOperationException("Unsupported ColumnTransformer");
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.filterTsBlockBuilder.getRetainedSizeInBytes();
    }
}

