/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator;

import java.time.ZoneId;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.AggrWindowIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.TimeDuration;

public class PreAggrWindowWithNaturalMonthIterator
implements ITimeRangeIterator {
    private static final int HEAP_MAX_SIZE = 100;
    private final boolean isAscending;
    private final boolean leftCRightO;
    private final TimeSelector timeBoundaryHeap;
    private final AggrWindowIterator aggrWindowIterator;
    private long curStartTimeForIterator;
    private long lastEndTime;
    private TimeRange curTimeRange;
    private boolean hasCachedTimeRange;

    public PreAggrWindowWithNaturalMonthIterator(long startTime, long endTime, TimeDuration interval, TimeDuration slidingStep, boolean isAscending, boolean leftCRightO, ZoneId zoneId) {
        this.isAscending = isAscending;
        this.timeBoundaryHeap = new TimeSelector(100, isAscending);
        this.aggrWindowIterator = new AggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending, leftCRightO, zoneId);
        this.leftCRightO = leftCRightO;
        this.initHeap();
    }

    @Override
    public TimeRange getFirstTimeRange() {
        long retStartTime = this.timeBoundaryHeap.pollFirst();
        this.lastEndTime = this.timeBoundaryHeap.first();
        return new TimeRange(retStartTime, this.lastEndTime);
    }

    @Override
    public boolean hasNextTimeRange() {
        if (this.hasCachedTimeRange) {
            return true;
        }
        if (this.curTimeRange == null) {
            this.curTimeRange = this.getFirstTimeRange();
            this.hasCachedTimeRange = true;
            return true;
        }
        if (this.lastEndTime >= this.curStartTimeForIterator) {
            this.tryToExpandHeap();
        }
        if (this.timeBoundaryHeap.isEmpty()) {
            return false;
        }
        long retStartTime = this.timeBoundaryHeap.pollFirst();
        if (retStartTime >= this.curStartTimeForIterator) {
            this.tryToExpandHeap();
        }
        if (this.timeBoundaryHeap.isEmpty()) {
            return false;
        }
        this.lastEndTime = this.timeBoundaryHeap.first();
        this.curTimeRange = new TimeRange(retStartTime, this.lastEndTime);
        this.hasCachedTimeRange = true;
        return true;
    }

    @Override
    public TimeRange nextTimeRange() {
        if (this.hasCachedTimeRange || this.hasNextTimeRange()) {
            this.hasCachedTimeRange = false;
            return this.getFinalTimeRange(this.curTimeRange, this.leftCRightO);
        }
        return null;
    }

    private void initHeap() {
        TimeRange firstTimeRange = this.aggrWindowIterator.nextTimeRange();
        if (this.leftCRightO) {
            this.timeBoundaryHeap.add(firstTimeRange.getMin());
            this.timeBoundaryHeap.add(firstTimeRange.getMax() + 1L);
            this.curStartTimeForIterator = firstTimeRange.getMin();
        } else {
            this.timeBoundaryHeap.add(firstTimeRange.getMin() - 1L);
            this.timeBoundaryHeap.add(firstTimeRange.getMax());
            this.curStartTimeForIterator = firstTimeRange.getMin() - 1L;
        }
        this.tryToExpandHeap();
    }

    private void tryToExpandHeap() {
        TimeRange timeRangeToExpand = null;
        while (this.aggrWindowIterator.hasNextTimeRange() && this.timeBoundaryHeap.size() < 100) {
            timeRangeToExpand = this.aggrWindowIterator.nextTimeRange();
            if (this.leftCRightO) {
                this.timeBoundaryHeap.add(timeRangeToExpand.getMin());
                this.timeBoundaryHeap.add(timeRangeToExpand.getMax() + 1L);
                this.curStartTimeForIterator = timeRangeToExpand.getMin();
                continue;
            }
            this.timeBoundaryHeap.add(timeRangeToExpand.getMin() - 1L);
            this.timeBoundaryHeap.add(timeRangeToExpand.getMax());
            this.curStartTimeForIterator = timeRangeToExpand.getMin() - 1L;
        }
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public long currentOutputTime() {
        return this.leftCRightO ? this.curTimeRange.getMin() : this.curTimeRange.getMax();
    }

    @Override
    public long getTotalIntervalNum() {
        long tmpInterval = 0L;
        while (this.hasNextTimeRange()) {
            ++tmpInterval;
            this.nextTimeRange();
        }
        this.curTimeRange = null;
        this.timeBoundaryHeap.clear();
        this.aggrWindowIterator.reset();
        this.initHeap();
        return tmpInterval;
    }
}

