/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.container.scan;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.compress.IUnCompressor;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.reader.chunk.AbstractChunkReader;
import org.apache.tsfile.read.reader.page.PageReader;

public class SinglePageWholeChunkReader
extends AbstractChunkReader {
    private final ChunkHeader chunkHeader;
    private final ByteBuffer chunkDataBuffer;

    public SinglePageWholeChunkReader(Chunk chunk) throws IOException {
        super(Long.MIN_VALUE, null);
        this.chunkHeader = chunk.getHeader();
        this.chunkDataBuffer = chunk.getData();
        this.initAllPageReaders();
    }

    private void initAllPageReaders() throws IOException {
        while (this.chunkDataBuffer.remaining() > 0) {
            this.pageReaderList.add(this.constructPageReader(PageHeader.deserializeFrom((ByteBuffer)this.chunkDataBuffer, (Statistics)null)));
        }
    }

    private PageReader constructPageReader(PageHeader pageHeader) throws IOException {
        return new PageReader(pageHeader, SinglePageWholeChunkReader.deserializePageData(pageHeader, this.chunkDataBuffer, this.chunkHeader), this.chunkHeader.getDataType(), Decoder.getDecoderByType((TSEncoding)this.chunkHeader.getEncodingType(), (TSDataType)this.chunkHeader.getDataType()), this.defaultTimeDecoder, null);
    }

    public static ByteBuffer readCompressedPageData(PageHeader pageHeader, ByteBuffer chunkBuffer) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] compressedPageBody = new byte[compressedPageBodyLength];
        if (compressedPageBodyLength > chunkBuffer.remaining()) {
            throw new IOException("do not has a complete page body. Expected:" + compressedPageBodyLength + ". Actual:" + chunkBuffer.remaining());
        }
        chunkBuffer.get(compressedPageBody);
        return ByteBuffer.wrap(compressedPageBody);
    }

    public static ByteBuffer uncompressPageData(PageHeader pageHeader, IUnCompressor unCompressor, ByteBuffer compressedPageData) throws IOException {
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] uncompressedPageData = new byte[pageHeader.getUncompressedSize()];
        try {
            unCompressor.uncompress(compressedPageData.array(), 0, compressedPageBodyLength, uncompressedPageData, 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + pageHeader.getUncompressedSize() + "compressed size: " + pageHeader.getCompressedSize() + "page header: " + pageHeader + e.getMessage());
        }
        return ByteBuffer.wrap(uncompressedPageData);
    }

    public static ByteBuffer deserializePageData(PageHeader pageHeader, ByteBuffer chunkBuffer, ChunkHeader chunkHeader) throws IOException {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor((CompressionType)chunkHeader.getCompressionType());
        ByteBuffer compressedPageBody = SinglePageWholeChunkReader.readCompressedPageData(pageHeader, chunkBuffer);
        return SinglePageWholeChunkReader.uncompressPageData(pageHeader, unCompressor, compressedPageBody);
    }
}

