/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;

public class LeaderCacheUtils {
    private LeaderCacheUtils() {
    }

    public static List<Pair<String, TEndPoint>> parseRecommendedRedirections(TSStatus status) {
        ArrayList<Pair<String, TEndPoint>> redirectList = new ArrayList<Pair<String, TEndPoint>>();
        if (status.getSubStatusSize() != 2) {
            return redirectList;
        }
        for (TSStatus subStatus : status.getSubStatus()) {
            if (subStatus.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
            for (TSStatus innerSubStatus : subStatus.getSubStatus()) {
                if (!innerSubStatus.isSetRedirectNode()) continue;
                redirectList.add((Pair<String, TEndPoint>)new Pair((Object)innerSubStatus.getMessage(), (Object)innerSubStatus.getRedirectNode()));
            }
        }
        return redirectList;
    }
}

