/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.schemaregion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningQueue;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.ConstructSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.DeleteTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.PreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackPreDeactivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.RollbackSchemaBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.AlterLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.ConstructLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.DeleteLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.view.RollbackLogicalViewBlackListNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedNonWritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedWritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeOperateSchemaQueueNode;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.ICreateTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.SchemaRegionWritePlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl.CreateAlignedTimeSeriesPlanImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.write.req.impl.CreateTimeSeriesPlanImpl;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExecutionVisitor
extends PlanVisitor<TSStatus, ISchemaRegion> {
    private static final Logger logger = LoggerFactory.getLogger(SchemaExecutionVisitor.class);

    @Override
    public TSStatus visitCreateTimeSeries(CreateTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.createTimeSeries(node, -1L);
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            if (node.isGeneratedByPipe()) {
                ICreateAlignedTimeSeriesPlan plan = SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan(node.getDevicePath(), node.getMeasurements(), node.getDataTypes(), node.getEncodings(), node.getCompressors(), node.getAliasList(), node.getTagsList(), node.getAttributesList());
                ((CreateAlignedTimeSeriesPlanImpl)plan).setWithMerge(true);
                schemaRegion.createAlignedTimeSeries(plan);
            } else {
                schemaRegion.createAlignedTimeSeries(node);
            }
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, MeasurementGroup> measurementGroupMap = node.getMeasurementGroupMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, MeasurementGroup> entry : measurementGroupMap.entrySet()) {
            PartialPath devicePath = entry.getKey();
            MeasurementGroup measurementGroup = entry.getValue();
            int size = measurementGroup.getMeasurements().size();
            for (int i = 0; i < size; ++i) {
                try {
                    ICreateTimeSeriesPlan createTimeSeriesPlan = this.transformToCreateTimeSeriesPlan(devicePath, measurementGroup, i);
                    ((CreateTimeSeriesPlanImpl)createTimeSeriesPlan).setWithMerge(node.isGeneratedByPipe());
                    schemaRegion.createTimeSeries(createTimeSeriesPlan, -1L);
                    continue;
                }
                catch (MetadataException e) {
                    logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                    failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    private ICreateTimeSeriesPlan transformToCreateTimeSeriesPlan(PartialPath devicePath, MeasurementGroup measurementGroup, int index) {
        return SchemaRegionWritePlanFactory.getCreateTimeSeriesPlan(devicePath.concatNode(measurementGroup.getMeasurements().get(index)), measurementGroup.getDataTypes().get(index), measurementGroup.getEncodings().get(index), measurementGroup.getCompressors().get(index), measurementGroup.getPropsList() == null ? null : measurementGroup.getPropsList().get(index), measurementGroup.getTagsList() == null ? null : measurementGroup.getTagsList().get(index), measurementGroup.getAttributesList() == null ? null : measurementGroup.getAttributesList().get(index), measurementGroup.getAliasList() == null ? null : measurementGroup.getAliasList().get(index));
    }

    @Override
    public TSStatus visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, ISchemaRegion schemaRegion) {
        PartialPath devicePath = node.getDevicePath();
        MeasurementGroup measurementGroup = node.getMeasurementGroup();
        ArrayList<TSStatus> alreadyExistingTimeSeries = new ArrayList<TSStatus>();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        if (node.isAligned()) {
            this.executeInternalCreateAlignedTimeSeries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeSeries, failingStatus, node.isGeneratedByPipe());
        } else {
            this.executeInternalCreateTimeSeries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeSeries, failingStatus, node.isGeneratedByPipe());
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        if (!alreadyExistingTimeSeries.isEmpty()) {
            return RpcUtils.getStatus(alreadyExistingTimeSeries);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, ISchemaRegion schemaRegion) {
        ArrayList<TSStatus> alreadyExistingTimeSeries = new ArrayList<TSStatus>();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, Pair<Boolean, MeasurementGroup>> deviceEntry : node.getDeviceMap().entrySet()) {
            PartialPath devicePath = deviceEntry.getKey();
            MeasurementGroup measurementGroup = (MeasurementGroup)deviceEntry.getValue().right;
            if (Boolean.TRUE.equals(deviceEntry.getValue().left)) {
                this.executeInternalCreateAlignedTimeSeries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeSeries, failingStatus, node.isGeneratedByPipe());
                continue;
            }
            this.executeInternalCreateTimeSeries(devicePath, measurementGroup, schemaRegion, alreadyExistingTimeSeries, failingStatus, node.isGeneratedByPipe());
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        if (!alreadyExistingTimeSeries.isEmpty()) {
            return RpcUtils.getStatus(alreadyExistingTimeSeries);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    private void executeInternalCreateTimeSeries(PartialPath devicePath, MeasurementGroup measurementGroup, ISchemaRegion schemaRegion, List<TSStatus> alreadyExistingTimeSeries, List<TSStatus> failingStatus, boolean withMerge) {
        int size = measurementGroup.getMeasurements().size();
        for (int i = 0; i < size; ++i) {
            try {
                ICreateTimeSeriesPlan createTimeSeriesPlan = this.transformToCreateTimeSeriesPlan(devicePath, measurementGroup, i);
                ((CreateTimeSeriesPlanImpl)createTimeSeriesPlan).setWithMerge(withMerge);
                schemaRegion.createTimeSeries(createTimeSeriesPlan, -1L);
                continue;
            }
            catch (MeasurementAlreadyExistException e) {
                alreadyExistingTimeSeries.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)MeasurementPath.transformDataToString((MeasurementPath)e.getMeasurementPath())));
                continue;
            }
            catch (MetadataException e) {
                logger.warn("{}: MetaData error: ", (Object)e.getMessage(), (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
    }

    private void executeInternalCreateAlignedTimeSeries(PartialPath devicePath, MeasurementGroup measurementGroup, ISchemaRegion schemaRegion, List<TSStatus> alreadyExistingTimeSeries, List<TSStatus> failingStatus, boolean withMerge) {
        List<String> measurementList = measurementGroup.getMeasurements();
        List<TSDataType> dataTypeList = measurementGroup.getDataTypes();
        List<TSEncoding> encodingList = measurementGroup.getEncodings();
        List<CompressionType> compressionTypeList = measurementGroup.getCompressors();
        List<String> aliasList = measurementGroup.getAliasList();
        List<Map<String, String>> tagsList = measurementGroup.getTagsList();
        List<Map<String, String>> attributesList = measurementGroup.getAttributesList();
        ICreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = SchemaRegionWritePlanFactory.getCreateAlignedTimeSeriesPlan(devicePath, measurementList, dataTypeList, encodingList, compressionTypeList, aliasList, tagsList, attributesList);
        ((CreateAlignedTimeSeriesPlanImpl)createAlignedTimeSeriesPlan).setWithMerge(withMerge);
        boolean shouldRetry = true;
        while (shouldRetry) {
            try {
                schemaRegion.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                shouldRetry = false;
            }
            catch (MeasurementAlreadyExistException e) {
                MeasurementPath measurementPath = e.getMeasurementPath();
                alreadyExistingTimeSeries.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)MeasurementPath.transformDataToString((MeasurementPath)e.getMeasurementPath())));
                int index = measurementList.indexOf(measurementPath.getMeasurement());
                measurementList.remove(index);
                dataTypeList.remove(index);
                encodingList.remove(index);
                compressionTypeList.remove(index);
                if (Objects.nonNull(aliasList)) {
                    aliasList.remove(index);
                }
                if (Objects.nonNull(tagsList)) {
                    tagsList.remove(index);
                }
                if (Objects.nonNull(attributesList)) {
                    attributesList.remove(index);
                }
                if (withMerge) {
                    createAlignedTimeSeriesPlan.getMeasurements().remove(index);
                    createAlignedTimeSeriesPlan.getDataTypes().remove(index);
                    createAlignedTimeSeriesPlan.getEncodings().remove(index);
                    createAlignedTimeSeriesPlan.getCompressors().remove(index);
                    if (Objects.nonNull(aliasList)) {
                        createAlignedTimeSeriesPlan.getAliasList().remove(index);
                    }
                    if (Objects.nonNull(tagsList)) {
                        createAlignedTimeSeriesPlan.getTagsList().remove(index);
                    }
                    if (Objects.nonNull(attributesList)) {
                        createAlignedTimeSeriesPlan.getAttributesList().remove(index);
                    }
                }
                if (!measurementList.isEmpty()) continue;
                shouldRetry = false;
            }
            catch (MetadataException e) {
                logger.warn("{}: MetaData error: ", (Object)e.getMessage(), (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                shouldRetry = false;
            }
        }
    }

    @Override
    public TSStatus visitAlterTimeSeries(AlterTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            switch (node.getAlterType()) {
                case RENAME: {
                    String beforeName = node.getAlterMap().keySet().iterator().next();
                    String currentName = node.getAlterMap().get(beforeName);
                    schemaRegion.renameTagOrAttributeKey(beforeName, currentName, node.getPath());
                    break;
                }
                case SET: {
                    schemaRegion.setTagsOrAttributesValue(node.getAlterMap(), node.getPath());
                    break;
                }
                case DROP: {
                    schemaRegion.dropTagsOrAttributes(node.getAlterMap().keySet(), node.getPath());
                    break;
                }
                case ADD_TAGS: {
                    schemaRegion.addTags(node.getAlterMap(), node.getPath());
                    break;
                }
                case ADD_ATTRIBUTES: {
                    schemaRegion.addAttributes(node.getAlterMap(), node.getPath());
                    break;
                }
                case UPSERT: {
                    schemaRegion.upsertAliasAndTagsAndAttributes(node.getAlias(), node.getTagsMap(), node.getAttributesMap(), node.getPath());
                }
            }
        }
        catch (MetadataException e) {
            logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (IOException e) {
            logger.error("{}: IO error: ", (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitActivateTemplate(ActivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            Template template = ClusterTemplateManager.getInstance().getTemplate(node.getTemplateId());
            schemaRegion.activateSchemaTemplate(node, template);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitBatchActivateTemplate(BatchActivateTemplateNode node, ISchemaRegion schemaRegion) {
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        ArrayList<PartialPath> alreadyActivatedDeviceList = new ArrayList<PartialPath>();
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : node.getTemplateActivationMap().entrySet()) {
            Template template = ClusterTemplateManager.getInstance().getTemplate((Integer)entry.getValue().left);
            try {
                schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan(entry.getKey(), (Integer)entry.getValue().right, (Integer)entry.getValue().left), template);
            }
            catch (MetadataException e) {
                if (e.getErrorCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
                    alreadyActivatedDeviceList.add(entry.getKey());
                    continue;
                }
                logger.error(e.getMessage(), (Throwable)e);
                statusList.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!alreadyActivatedDeviceList.isEmpty()) {
            TemplateIsInUseException e = new TemplateIsInUseException(((Object)alreadyActivatedDeviceList).toString());
            logger.error(e.getMessage(), (Throwable)((Object)e));
            statusList.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
        }
        return statusList.isEmpty() ? RpcUtils.SUCCESS_STATUS : RpcUtils.getStatus(statusList);
    }

    @Override
    public TSStatus visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, ISchemaRegion schemaRegion) {
        for (Map.Entry<PartialPath, Pair<Integer, Integer>> entry : node.getTemplateActivationMap().entrySet()) {
            Template template = ClusterTemplateManager.getInstance().getTemplate((Integer)entry.getValue().left);
            try {
                schemaRegion.activateSchemaTemplate(SchemaRegionWritePlanFactory.getActivateTemplateInClusterPlan(entry.getKey(), (Integer)entry.getValue().right, (Integer)entry.getValue().left), template);
            }
            catch (TemplateIsInUseException e) {
                logger.info(String.format("Device Template has already been activated on path %s, there's no need to activate again.", entry.getKey()));
            }
            catch (MetadataException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    @Override
    public TSStatus visitConstructSchemaBlackList(ConstructSchemaBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            Pair<Long, Boolean> preDeletedNumAndIsAllLogicalView = schemaRegion.constructSchemaBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)(Boolean.TRUE.equals(preDeletedNumAndIsAllLogicalView.getRight()) ? TSStatusCode.ONLY_LOGICAL_VIEW : TSStatusCode.SUCCESS_STATUS), (String)String.valueOf(preDeletedNumAndIsAllLogicalView.getLeft()));
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRollbackSchemaBlackList(RollbackSchemaBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.rollbackSchemaBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitDeleteTimeseries(DeleteTimeSeriesNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.deleteTimeseriesInBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitPreDeactivateTemplate(PreDeactivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)String.valueOf(schemaRegion.constructSchemaBlackListWithTemplate(node)));
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRollbackPreDeactivateTemplate(RollbackPreDeactivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.rollbackSchemaBlackListWithTemplate(node);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitDeactivateTemplate(DeactivateTemplateNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.deactivateTemplateInBlackList(node);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitCreateLogicalView(CreateLogicalViewNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, ViewExpression> viewPathToSourceMap = node.getViewPathToSourceExpressionMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, ViewExpression> entry : viewPathToSourceMap.entrySet()) {
            try {
                schemaRegion.createLogicalView(SchemaRegionWritePlanFactory.getCreateLogicalViewPlan(entry.getKey(), entry.getValue()));
            }
            catch (MetadataException e) {
                logger.error("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitAlterLogicalView(AlterLogicalViewNode node, ISchemaRegion schemaRegion) {
        Map<PartialPath, ViewExpression> viewPathToSourceMap = node.getViewPathToSourceMap();
        ArrayList<TSStatus> failingStatus = new ArrayList<TSStatus>();
        for (Map.Entry<PartialPath, ViewExpression> entry : viewPathToSourceMap.entrySet()) {
            try {
                schemaRegion.alterLogicalView(SchemaRegionWritePlanFactory.getAlterLogicalViewPlan(entry.getKey(), entry.getValue()));
            }
            catch (MetadataException e) {
                logger.warn("{}: MetaData error: ", (Object)"IoTDB", (Object)e);
                failingStatus.add(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
        }
        if (!failingStatus.isEmpty()) {
            return RpcUtils.getStatus(failingStatus);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully");
    }

    @Override
    public TSStatus visitConstructLogicalViewBlackList(ConstructLogicalViewBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)String.valueOf(schemaRegion.constructLogicalViewBlackList(node.getPatternTree())));
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRollbackLogicalViewBlackList(RollbackLogicalViewBlackListNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.rollbackLogicalViewBlackList(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitDeleteLogicalView(DeleteLogicalViewNode node, ISchemaRegion schemaRegion) {
        try {
            schemaRegion.deleteLogicalView(node.getPatternTree());
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitPipeEnrichedWritePlanNode(PipeEnrichedWritePlanNode node, ISchemaRegion schemaRegion) {
        WritePlanNode innerNode = node.getWritePlanNode();
        innerNode.markAsGeneratedByPipe();
        return innerNode.accept(this, schemaRegion);
    }

    @Override
    public TSStatus visitPipeEnrichedNonWritePlanNode(PipeEnrichedNonWritePlanNode node, ISchemaRegion schemaRegion) {
        PlanNode innerNode = node.getNonWritePlanNode();
        innerNode.markAsGeneratedByPipe();
        return node.getNonWritePlanNode().accept(this, schemaRegion);
    }

    @Override
    public TSStatus visitPipeOperateSchemaQueueNode(PipeOperateSchemaQueueNode node, ISchemaRegion schemaRegion) {
        SchemaRegionId id = schemaRegion.getSchemaRegionId();
        SchemaRegionListeningQueue queue = PipeDataNodeAgent.runtime().schemaListener(id);
        if (node.isOpen() && !queue.isOpened()) {
            logger.info("Opened pipe listening queue on schema region {}", (Object)id);
            queue.open();
        } else if (!node.isOpen() && queue.isOpened()) {
            logger.info("Closed pipe listening queue on schema region {}", (Object)id);
            queue.close();
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    @Override
    public TSStatus visitPlan(PlanNode node, ISchemaRegion context) {
        return null;
    }
}

