/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TPathPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.db.auth.BasicAuthorityCache;
import org.apache.iotdb.db.auth.ClusterAuthorityFetcher;
import org.apache.iotdb.db.auth.IAuthorityFetcher;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class AuthorityChecker {
    public static final String SUPER_USER = CommonDescriptor.getInstance().getConfig().getAdminName();
    public static final TSStatus SUCCEED = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    private static final String NO_PERMISSION_PROMOTION = "No permissions for this operation, please add privilege ";
    private static final MemoizedSupplier<IAuthorityFetcher> authorityFetcher = MemoizedSupplier.valueOf(() -> new ClusterAuthorityFetcher(new BasicAuthorityCache()));
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    private AuthorityChecker() {
    }

    public static IAuthorityFetcher getAuthorityFetcher() {
        return (IAuthorityFetcher)authorityFetcher.get();
    }

    public static boolean invalidateCache(String username, String rolename) {
        return ((IAuthorityFetcher)authorityFetcher.get()).getAuthorCache().invalidateCache(username, rolename);
    }

    public static TSStatus checkUser(String userName, String password) {
        return ((IAuthorityFetcher)authorityFetcher.get()).checkUser(userName, password);
    }

    public static SettableFuture<ConfigTaskResult> queryPermission(AuthorStatement authorStatement) {
        return ((IAuthorityFetcher)authorityFetcher.get()).queryPermission(authorStatement);
    }

    public static SettableFuture<ConfigTaskResult> operatePermission(AuthorStatement authorStatement) {
        return ((IAuthorityFetcher)authorityFetcher.get()).operatePermission(authorStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TSStatus checkAuthority(Statement statement, IClientSession session) {
        long startTime = System.nanoTime();
        try {
            TSStatus tSStatus = statement.checkPermissionBeforeProcess(session.getUsername());
            return tSStatus;
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordAuthCost(System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TSStatus checkAuthority(Statement statement, String userName) {
        long startTime = System.nanoTime();
        try {
            TSStatus tSStatus = statement.checkPermissionBeforeProcess(userName);
            return tSStatus;
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordAuthCost(System.nanoTime() - startTime);
        }
    }

    public static TSStatus getOptTSStatus(boolean hasGrantOpt, String errMsg) {
        return hasGrantOpt ? SUCCEED : new TSStatus(TSStatusCode.NOT_HAS_PRIVILEGE_GRANTOPT.getStatusCode()).setMessage(errMsg);
    }

    public static TSStatus getTSStatus(boolean hasPermission, String errMsg) {
        return hasPermission ? SUCCEED : new TSStatus(TSStatusCode.NO_PERMISSION.getStatusCode()).setMessage(errMsg);
    }

    public static TSStatus getTSStatus(boolean hasPermission, PrivilegeType neededPrivilege) {
        return hasPermission ? SUCCEED : new TSStatus(TSStatusCode.NO_PERMISSION.getStatusCode()).setMessage(NO_PERMISSION_PROMOTION + neededPrivilege);
    }

    public static TSStatus getTSStatus(boolean hasPermission, PartialPath path, PrivilegeType neededPrivilege) {
        return hasPermission ? SUCCEED : new TSStatus(TSStatusCode.NO_PERMISSION.getStatusCode()).setMessage(NO_PERMISSION_PROMOTION + neededPrivilege + " on " + path);
    }

    public static TSStatus getTSStatus(List<Integer> noPermissionIndexList, List<PartialPath> pathList, PrivilegeType neededPrivilege) {
        if (noPermissionIndexList == null || noPermissionIndexList.isEmpty()) {
            return SUCCEED;
        }
        StringBuilder prompt = new StringBuilder(NO_PERMISSION_PROMOTION);
        prompt.append(neededPrivilege);
        prompt.append(" on [");
        prompt.append(pathList.get(noPermissionIndexList.get(0)));
        for (int i = 1; i < noPermissionIndexList.size(); ++i) {
            prompt.append(", ");
            prompt.append(pathList.get(noPermissionIndexList.get(i)));
        }
        prompt.append("]");
        return new TSStatus(TSStatusCode.NO_PERMISSION.getStatusCode()).setMessage(prompt.toString());
    }

    public static boolean checkFullPathPermission(String userName, PartialPath fullPath, int permission) {
        return ((IAuthorityFetcher)authorityFetcher.get()).checkUserPathPrivileges(userName, Collections.singletonList(fullPath), permission).isEmpty();
    }

    public static List<Integer> checkFullPathListPermission(String userName, List<PartialPath> fullPaths, int permission) {
        return ((IAuthorityFetcher)authorityFetcher.get()).checkUserPathPrivileges(userName, fullPaths, permission);
    }

    public static List<Integer> checkPatternPermission(String userName, List<PartialPath> pathPatterns, int permission) {
        return ((IAuthorityFetcher)authorityFetcher.get()).checkUserPathPrivileges(userName, pathPatterns, permission);
    }

    public static PathPatternTree getAuthorizedPathTree(String userName, int permission) throws AuthException {
        return ((IAuthorityFetcher)authorityFetcher.get()).getAuthorizedPatternTree(userName, permission);
    }

    public static boolean checkSystemPermission(String userName, int permission) {
        return ((IAuthorityFetcher)authorityFetcher.get()).checkUserSysPrivileges(userName, permission).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    public static boolean checkGrantOption(String userName, String[] privilegeList, List<PartialPath> nodeNameList) {
        for (String s : privilegeList) {
            if (((IAuthorityFetcher)authorityFetcher.get()).checkUserPrivilegeGrantOpt(userName, nodeNameList, PrivilegeType.valueOf((String)s.toUpperCase()).ordinal())) continue;
            return false;
        }
        return true;
    }

    public static boolean checkRole(String username, String rolename) {
        return ((IAuthorityFetcher)authorityFetcher.get()).checkRole(username, rolename);
    }

    public static TSStatus checkSuperUserOrMaintain(String userName) {
        if (SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.MAINTAIN.ordinal()), PrivilegeType.MAINTAIN);
    }

    public static void buildTSBlock(TAuthorizerResp authResp, SettableFuture<ConfigTaskResult> future) {
        TsBlockBuilder builder;
        List<Object> types = new ArrayList<TSDataType>();
        boolean listRoleUser = authResp.tag.equals("Role") || authResp.tag.equals("User");
        ArrayList<ColumnHeader> headerList = new ArrayList<ColumnHeader>();
        if (listRoleUser) {
            headerList.add(new ColumnHeader(authResp.getTag(), TSDataType.TEXT));
            types.add(TSDataType.TEXT);
            builder = new TsBlockBuilder(types);
            for (String name : authResp.getMemberInfo()) {
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeBinary(new Binary(name, TSFileConfig.STRING_CHARSET));
                builder.declarePosition();
            }
        } else {
            headerList = ColumnHeaderConstant.LIST_USER_PRIVILEGES_Column_HEADERS;
            types = ColumnHeaderConstant.LIST_USER_PRIVILEGES_Column_HEADERS.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
            builder = new TsBlockBuilder(types);
            TUserResp user = authResp.getPermissionInfo().getUserInfo();
            if (user != null) {
                AuthorityChecker.appendPriBuilder("", "root.**", user.getSysPriSet(), user.getSysPriSetGrantOpt(), builder);
                for (TPathPrivilege path : user.getPrivilegeList()) {
                    AuthorityChecker.appendPriBuilder("", path.getPath(), path.getPriSet(), path.getPriGrantOpt(), builder);
                }
            }
            Iterator it = authResp.getPermissionInfo().getRoleInfo().entrySet().iterator();
            while (it.hasNext()) {
                TRoleResp role = (TRoleResp)it.next().getValue();
                AuthorityChecker.appendPriBuilder(role.getRoleName(), "root.**", role.getSysPriSet(), role.getSysPriSetGrantOpt(), builder);
                for (TPathPrivilege path : role.getPrivilegeList()) {
                    AuthorityChecker.appendPriBuilder(role.getRoleName(), path.getPath(), path.getPriSet(), path.getPriGrantOpt(), builder);
                }
            }
        }
        DatasetHeader datasetHeader = new DatasetHeader(headerList, true);
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static void appendPriBuilder(String name, String path, Set<Integer> priv, Set<Integer> grantOpt, TsBlockBuilder builder) {
        for (int i : priv) {
            builder.getColumnBuilder(0).writeBinary(new Binary(name, TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(path, TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(2).writeBinary(new Binary(PrivilegeType.values()[i].toString(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(3).writeBoolean(grantOpt.contains(i));
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.declarePosition();
        }
    }
}

