/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.subscriptions;

import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.util.Objects;
import java.util.Optional;

public final class SharedSubscription
implements Comparable<SharedSubscription> {
    private final ShareName shareName;
    private final Topic topicFilter;
    private final String clientId;
    private final MqttSubscriptionOption option;
    private final Optional<SubscriptionIdentifier> subscriptionId;

    public SharedSubscription(ShareName shareName, Topic topicFilter, String clientId, MqttSubscriptionOption option) {
        Objects.requireNonNull(option, "option parameter can't be null");
        this.shareName = shareName;
        this.topicFilter = topicFilter;
        this.clientId = clientId;
        this.option = option;
        this.subscriptionId = Optional.empty();
    }

    public SharedSubscription(ShareName shareName, Topic topicFilter, String clientId, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionId) {
        Objects.requireNonNull(option, "option parameter can't be null");
        this.shareName = shareName;
        this.topicFilter = topicFilter;
        this.clientId = clientId;
        this.option = option;
        this.subscriptionId = Optional.of(subscriptionId);
    }

    public String clientId() {
        return this.clientId;
    }

    public Topic topicFilter() {
        return this.topicFilter;
    }

    public MqttQoS requestedQoS() {
        return this.option.qos();
    }

    public MqttSubscriptionOption getOption() {
        return this.option;
    }

    public ShareName getShareName() {
        return this.shareName;
    }

    Subscription createSubscription() {
        if (this.subscriptionId.isPresent()) {
            return new Subscription(this.clientId, this.topicFilter, this.option, this.shareName.getShareName(), this.subscriptionId.get());
        }
        return new Subscription(this.clientId, this.topicFilter, this.option, this.shareName.getShareName());
    }

    public boolean hasSubscriptionIdentifier() {
        return this.subscriptionId.isPresent();
    }

    public SubscriptionIdentifier getSubscriptionIdentifier() {
        return this.subscriptionId.get();
    }

    @Override
    public int compareTo(SharedSubscription o) {
        return this.clientId.compareTo(o.clientId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedSubscription that = (SharedSubscription)o;
        return Objects.equals(this.shareName, that.shareName) && Objects.equals(this.topicFilter, that.topicFilter) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.option, that.option);
    }

    public int hashCode() {
        return Objects.hash(this.shareName, this.topicFilter, this.clientId, this.option);
    }
}

