/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadRequests {
    private static final Logger LOG = LoggerFactory.getLogger(ReadRequests.class);
    private final ReadIndexQueue readIndexQueue;
    private final StateMachine stateMachine;

    ReadRequests(RaftProperties properties, StateMachine stateMachine) {
        this.readIndexQueue = new ReadIndexQueue(RaftServerConfigKeys.Read.timeout((RaftProperties)properties));
        this.stateMachine = stateMachine;
    }

    Consumer<Long> getAppliedIndexConsumer() {
        return this.readIndexQueue::complete;
    }

    CompletableFuture<Long> waitToAdvance(long readIndex) {
        long lastApplied = this.stateMachine.getLastAppliedTermIndex().getIndex();
        if (lastApplied >= readIndex) {
            return CompletableFuture.completedFuture(lastApplied);
        }
        CompletableFuture<Long> f = this.readIndexQueue.add(readIndex);
        long current = this.stateMachine.getLastAppliedTermIndex().getIndex();
        if (current > lastApplied) {
            this.readIndexQueue.complete(current);
        }
        return f;
    }

    static class ReadIndexQueue {
        private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
        private final NavigableMap<Long, CompletableFuture<Long>> sorted = new TreeMap<Long, CompletableFuture<Long>>();
        private final TimeDuration readTimeout;

        ReadIndexQueue(TimeDuration readTimeout) {
            this.readTimeout = readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompletableFuture<Long> add(long readIndex) {
            CompletableFuture<Long> returned;
            boolean create;
            ReadIndexQueue readIndexQueue = this;
            synchronized (readIndexQueue) {
                CompletableFuture<Long> existing = (CompletableFuture<Long>)this.sorted.get(readIndex);
                boolean bl = create = existing == null;
                if (create) {
                    returned = new CompletableFuture<Long>();
                    this.sorted.put(readIndex, returned);
                } else {
                    returned = existing;
                }
            }
            if (create) {
                this.scheduler.onTimeout(this.readTimeout, () -> this.handleTimeout(readIndex), LOG, () -> "Failed to handle read timeout for index " + readIndex);
            }
            return returned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleTimeout(long readIndex) {
            CompletableFuture removed;
            ReadIndexQueue readIndexQueue = this;
            synchronized (readIndexQueue) {
                removed = (CompletableFuture)this.sorted.remove(readIndex);
            }
            if (removed == null) {
                return;
            }
            removed.completeExceptionally((Throwable)new ReadException("Read timeout " + this.readTimeout + " for index " + readIndex));
        }

        synchronized void complete(Long appliedIndex) {
            NavigableMap<Long, CompletableFuture<Long>> headMap = this.sorted.headMap(appliedIndex, true);
            headMap.values().forEach(f -> f.complete(appliedIndex));
            headMap.clear();
        }
    }
}

