/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataSource
implements DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataSource.class);
    private String url;
    private String user;
    private String password;
    private static final String PWD_STR = "password";
    private Properties properties;
    private Integer port = 6667;

    public IoTDBDataSource() {
        this.properties = new Properties();
    }

    public IoTDBDataSource(String url, String user, String password, Integer port) {
        this.url = url;
        this.properties = new Properties();
        this.properties.setProperty("user", user);
        this.properties.setProperty(PWD_STR, password);
        if (port != 0) {
            this.port = port;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.properties.setProperty("user", user);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.properties.setProperty(PWD_STR, password);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return new IoTDBConnection(this.url, this.properties);
        }
        catch (TTransportException e) {
            LOGGER.error("get connection error:", (Throwable)e);
            return null;
        }
    }

    @Override
    public Connection getConnection(String username, String password) {
        try {
            Properties newProp = new Properties();
            newProp.setProperty("user", username);
            newProp.setProperty(PWD_STR, password);
            return new IoTDBConnection(this.url, newProp);
        }
        catch (Exception e) {
            LOGGER.error("get connection error:", (Throwable)e);
            return null;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
    }

    @Override
    public void setLoginTimeout(int i) {
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) {
        return false;
    }
}

