/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis.utils;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.iotdb.consensus.ratis.utils.RetryPolicy;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;

public class Retriable {
    public static <RETURN, THROWABLE extends Throwable> RETURN attempt(CheckedSupplier<RETURN, THROWABLE> supplier, RetryPolicy<RETURN> policy, Supplier<?> name, Logger log) throws THROWABLE, InterruptedException {
        Objects.requireNonNull(supplier, "supplier == null");
        int attempt = 0;
        while (true) {
            try {
                TimeDuration waitTime;
                Object ret = supplier.get();
                if (policy.shouldRetry(ret) && policy.shoudAttempt(attempt)) {
                    waitTime = policy.getWaitTime(attempt);
                    if (log != null && log.isDebugEnabled()) {
                        log.debug("Failed {}, attempt #{}, sleep {} and then retry", new Object[]{name.get(), attempt, waitTime});
                    }
                } else {
                    return (RETURN)ret;
                }
                waitTime.sleep();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (log != null && log.isWarnEnabled()) {
                    log.warn("{}: interrupted when waiting for retry", name.get());
                }
                throw e;
            }
            ++attempt;
        }
    }

    public static void attemptUntilTrue(BooleanSupplier condition, TimeDuration sleepTime, String name, Logger log) throws InterruptedException {
        Retriable.attemptUntilTrue(condition, -1, sleepTime, name, log);
    }

    public static void attemptUntilTrue(BooleanSupplier condition, int maxAttempts, TimeDuration sleepTime, String name, Logger log) throws InterruptedException {
        Objects.requireNonNull(condition, "condition == null");
        Retriable.attempt(() -> null, RetryPolicy.newBuilder().setRetryHandler(ret -> !condition.getAsBoolean()).setWaitTime(sleepTime).setMaxAttempts(maxAttempts).build(), () -> name, log);
    }
}

