/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.topic.TopicMeta;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllSubscriptionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTopicInfoResp;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaRespExceptionMessage;
import org.apache.iotdb.mpp.rpc.thrift.TPushTopicMetaRespExceptionMessage;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionAgentLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionAgentLauncher.class);
    public static final int MAX_RETRY_TIMES = 5;

    private SubscriptionAgentLauncher() {
    }

    public static synchronized void launchSubscriptionTopicAgent() throws StartupException {
        int retry = 0;
        while (retry < 5) {
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TGetAllTopicInfoResp getAllTopicInfoResp = configNodeClient.getAllTopicInfo();
                if (getAllTopicInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    String exceptionMessage = String.format("Failed to get all topic info in config node, status is %s", getAllTopicInfoResp.getStatus());
                    LOGGER.warn(exceptionMessage);
                    throw new SubscriptionException(exceptionMessage);
                }
                TPushTopicMetaRespExceptionMessage exceptionMessage = SubscriptionAgent.topic().handleTopicMetaChanges(getAllTopicInfoResp.getAllTopicInfo().stream().map(byteBuffer -> {
                    TopicMeta topicMeta = TopicMeta.deserialize((ByteBuffer)byteBuffer);
                    LOGGER.info("Pulled topic meta from config node: {}, recovering ...", (Object)topicMeta);
                    return topicMeta;
                }).collect(Collectors.toList()));
                if (Objects.nonNull(exceptionMessage)) {
                    LOGGER.warn(exceptionMessage.getMessage());
                    throw new SubscriptionException(exceptionMessage.getMessage());
                }
                return;
            }
            catch (ClientManagerException | SubscriptionException | TException e) {
                LOGGER.warn("Failed to get topic meta from config node for {} times, will retry at most {} times.", new Object[]{++retry, 5, e});
                try {
                    Thread.sleep((long)retry * SubscriptionConfig.getInstance().getSubscriptionLaunchRetryIntervalMs());
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.info("Interrupted while sleeping, will retry to get topic meta from config node.", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new StartupException("Failed to get topic meta from config node.");
    }

    public static synchronized void launchSubscriptionConsumerAgent() throws StartupException {
        int retry = 0;
        while (retry < 5) {
            try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                TGetAllSubscriptionInfoResp getAllSubscriptionInfoResp = configNodeClient.getAllSubscriptionInfo();
                if (getAllSubscriptionInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    String exceptionMessage = String.format("Failed to get all subscription info in config node, status is %s", getAllSubscriptionInfoResp.getStatus());
                    LOGGER.warn(exceptionMessage);
                    throw new SubscriptionException(exceptionMessage);
                }
                TPushConsumerGroupMetaRespExceptionMessage exceptionMessage = SubscriptionAgent.consumer().handleConsumerGroupMetaChanges(getAllSubscriptionInfoResp.getAllSubscriptionInfo().stream().map(byteBuffer -> {
                    ConsumerGroupMeta consumerGroupMeta = ConsumerGroupMeta.deserialize((ByteBuffer)byteBuffer);
                    LOGGER.info("Pulled consumer group meta from config node: {}, recovering ...", (Object)consumerGroupMeta);
                    return consumerGroupMeta;
                }).collect(Collectors.toList()));
                if (Objects.nonNull(exceptionMessage)) {
                    LOGGER.warn(exceptionMessage.getMessage());
                    throw new SubscriptionException(exceptionMessage.getMessage());
                }
                return;
            }
            catch (ClientManagerException | SubscriptionException | TException e) {
                LOGGER.warn("Failed to get consumer group meta from config node for {} times, will retry at most {} times.", new Object[]{++retry, 5, e});
                try {
                    Thread.sleep((long)retry * SubscriptionConfig.getInstance().getSubscriptionLaunchRetryIntervalMs());
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.info("Interrupted while sleeping, will retry to get consumer group meta from config node.", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw new StartupException("Failed to get consumer group meta from config node.");
    }
}

