/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.template;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public enum TemplateInternalRPCUpdateType {
    ROLLBACK_INVALIDATE_TEMPLATE_SET_INFO(0),
    INVALIDATE_TEMPLATE_SET_INFO(1),
    ADD_TEMPLATE_PRE_SET_INFO(2),
    COMMIT_TEMPLATE_SET_INFO(3),
    UPDATE_TEMPLATE_INFO(4);

    private final byte operationType;

    private TemplateInternalRPCUpdateType(byte operationType) {
        this.operationType = operationType;
    }

    public byte toByte() {
        return this.operationType;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.operationType, (OutputStream)stream);
    }

    public static TemplateInternalRPCUpdateType deserialize(ByteBuffer buffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        return TemplateInternalRPCUpdateType.getType(type);
    }

    public static TemplateInternalRPCUpdateType getType(byte type) {
        switch (type) {
            case 0: {
                return ROLLBACK_INVALIDATE_TEMPLATE_SET_INFO;
            }
            case 1: {
                return INVALIDATE_TEMPLATE_SET_INFO;
            }
            case 2: {
                return ADD_TEMPLATE_PRE_SET_INFO;
            }
            case 3: {
                return COMMIT_TEMPLATE_SET_INFO;
            }
            case 4: {
                return UPDATE_TEMPLATE_INFO;
            }
        }
        throw new IllegalArgumentException("Unknown template update operation type" + type);
    }
}

