/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.ternary;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.ternary.CompareTernaryTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TypeUtils;

public class BetweenTransformer
extends CompareTernaryTransformer {
    boolean isNotBetween;

    public BetweenTransformer(LayerReader firstReader, LayerReader secondReader, LayerReader thirdReader, boolean isNotBetween) {
        super(firstReader, secondReader, thirdReader);
        this.isNotBetween = isNotBetween;
    }

    @Override
    protected CompareTernaryTransformer.Evaluator constructNumberEvaluator() {
        return (firstValues, firstIndex, secondValues, secondIndex, thirdValues, thirdIndex) -> (Double.compare(TypeUtils.castValueToDouble(firstValues, this.firstReaderDataType, firstIndex), TypeUtils.castValueToDouble(secondValues, this.secondReaderDataType, secondIndex)) >= 0 && Double.compare(TypeUtils.castValueToDouble(firstValues, this.firstReaderDataType, firstIndex), TypeUtils.castValueToDouble(thirdValues, this.thirdReaderDataType, thirdIndex)) <= 0) ^ this.isNotBetween;
    }

    @Override
    protected CompareTernaryTransformer.Evaluator constructTextEvaluator() {
        return (firstValues, firstIndex, secondValues, secondIndex, thirdValues, thirdIndex) -> (TransformUtils.compare(firstValues.getBinary(firstIndex), secondValues.getBinary(secondIndex)) >= 0 && TransformUtils.compare(firstValues.getBinary(firstIndex), thirdValues.getBinary(thirdIndex)) <= 0) ^ this.isNotBetween;
    }
}

