/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;

public class PlanNodeUtil {
    private static final String INDENT = "    ";
    private static final String BRO = "  \u251c\u2500\u2500";
    private static final String CORNER = "  \u2514\u2500\u2500";
    private static final String LINE = "  \u2502 ";

    public static String printRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        if (regionReplicaSet == null) {
            return "Not Assigned";
        }
        return String.valueOf(regionReplicaSet.getRegionId());
    }

    public static void printPlanNode(PlanNode root) {
        PlanNodeUtil.printPlanNodeWithLevel(root, 0);
    }

    private static void printPlanNodeWithLevel(PlanNode root, int level) {
        PlanNodeUtil.printTab(level);
        System.out.println(root.toString());
        for (PlanNode child : root.getChildren()) {
            PlanNodeUtil.printPlanNodeWithLevel(child, level + 1);
        }
    }

    private static void printTab(int count) {
        for (int i = 0; i < count; ++i) {
            System.out.print("\t");
        }
    }

    public static String nodeToString(PlanNode root) {
        StringBuilder result = new StringBuilder();
        PlanNodeUtil.nodeToString(root, new PrintContext(false, 0, new TreeMap<Integer, String>()), result);
        return result.toString();
    }

    private static void nodeToString(PlanNode root, int level, StringBuilder result) {
        for (int i = 0; i < level; ++i) {
            result.append(INDENT);
        }
        result.append(root.toString());
        result.append(System.lineSeparator());
        for (PlanNode child : root.getChildren()) {
            PlanNodeUtil.nodeToString(child, level + 1, result);
        }
    }

    private static void nodeToString(PlanNode root, PrintContext ctx, StringBuilder result) {
        int i;
        int level = ctx.level;
        for (i = 0; i < level; ++i) {
            result.append(ctx.codeMap.get(i));
        }
        result.append(root.toString());
        result.append(System.lineSeparator());
        if (root.getChildren() == null) {
            return;
        }
        for (i = 0; i < root.getChildren().size(); ++i) {
            PlanNode child = root.getChildren().get(i);
            PrintContext childCtx = ctx.clone();
            boolean bl = childCtx.isLast = i == root.getChildren().size() - 1;
            if (childCtx.level - 1 >= 0) {
                childCtx.codeMap.put(ctx.level - 1, ctx.isLast ? INDENT : LINE);
            }
            childCtx.codeMap.put(ctx.level, childCtx.isLast ? CORNER : BRO);
            ++childCtx.level;
            PlanNodeUtil.nodeToString(child, childCtx, result);
        }
    }

    public static PlanNode deepCopy(PlanNode root) {
        List<PlanNode> children = root.getChildren().stream().map(PlanNodeUtil::deepCopy).collect(Collectors.toList());
        return root.cloneWithChildren(children);
    }

    private static class PrintContext {
        public boolean isLast;
        public int level;
        public Map<Integer, String> codeMap;

        public PrintContext() {
            this.codeMap = new TreeMap<Integer, String>();
        }

        public PrintContext(boolean isLast, int level, Map<Integer, String> codeMap) {
            this.isLast = isLast;
            this.level = level;
            this.codeMap = codeMap;
        }

        public PrintContext clone() {
            return new PrintContext(this.isLast, this.level, new TreeMap<Integer, String>(this.codeMap));
        }
    }
}

