/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningQueue;
import org.apache.iotdb.db.pipe.metric.schema.PipeSchemaRegionListenerMetrics;

public class PipeSchemaRegionListenerManager {
    private final Map<SchemaRegionId, PipeSchemaRegionListener> id2ListenerMap = new ConcurrentHashMap<SchemaRegionId, PipeSchemaRegionListener>();

    public synchronized Set<SchemaRegionId> regionIds() {
        return this.id2ListenerMap.keySet();
    }

    public synchronized SchemaRegionListeningQueue listener(SchemaRegionId schemaRegionId) {
        return this.id2ListenerMap.computeIfAbsent(schemaRegionId, PipeSchemaRegionListener::new).listeningQueue;
    }

    public synchronized int increaseAndGetReferenceCount(SchemaRegionId schemaRegionId) {
        return this.id2ListenerMap.computeIfAbsent(schemaRegionId, PipeSchemaRegionListener::new).listeningQueueReferenceCount.incrementAndGet();
    }

    public synchronized int decreaseAndGetReferenceCount(SchemaRegionId schemaRegionId) {
        return this.id2ListenerMap.computeIfAbsent(schemaRegionId, PipeSchemaRegionListener::new).listeningQueueReferenceCount.updateAndGet(v -> v > 0 ? v - 1 : 0);
    }

    public synchronized void notifyLeaderReady(SchemaRegionId schemaRegionId) {
        this.id2ListenerMap.computeIfAbsent(schemaRegionId, PipeSchemaRegionListener::new).notifyLeaderReady();
    }

    public synchronized void notifyLeaderUnavailable(SchemaRegionId schemaRegionId) {
        this.id2ListenerMap.computeIfAbsent(schemaRegionId, PipeSchemaRegionListener::new).notifyLeaderUnavailable();
    }

    public synchronized boolean isLeaderReady(SchemaRegionId schemaRegionId) {
        return this.id2ListenerMap.computeIfAbsent(schemaRegionId, PipeSchemaRegionListener::new).isLeaderReady();
    }

    private static class PipeSchemaRegionListener {
        private final SchemaRegionListeningQueue listeningQueue = new SchemaRegionListeningQueue();
        private final AtomicInteger listeningQueueReferenceCount = new AtomicInteger(0);
        private final AtomicBoolean isLeaderReady = new AtomicBoolean(false);

        protected PipeSchemaRegionListener(SchemaRegionId schemaRegionId) {
            PipeSchemaRegionListenerMetrics.getInstance().register(this.listeningQueue, schemaRegionId.getId());
        }

        private boolean isLeaderReady() {
            return this.isLeaderReady.get();
        }

        private void notifyLeaderReady() {
            this.isLeaderReady.set(true);
        }

        private void notifyLeaderUnavailable() {
            this.isLeaderReady.set(false);
        }
    }
}

