/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeAttributes;

public class VariableTypeAttributes
extends NodeAttributes
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=364");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=366");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=365");
    private final Variant value;
    private final NodeId dataType;
    private final Integer valueRank;
    private final UInteger[] arrayDimensions;
    private final Boolean isAbstract;

    public VariableTypeAttributes(UInteger specifiedAttributes, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Variant value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, Boolean isAbstract) {
        super(specifiedAttributes, displayName, description, writeMask, userWriteMask);
        this.value = value;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.isAbstract = isAbstract;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Variant getValue() {
        return this.value;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    protected VariableTypeAttributes(VariableTypeAttributesBuilder<?, ?> b) {
        super((NodeAttributes.NodeAttributesBuilder<?, ?>)b);
        this.value = ((VariableTypeAttributesBuilder)b).value;
        this.dataType = ((VariableTypeAttributesBuilder)b).dataType;
        this.valueRank = ((VariableTypeAttributesBuilder)b).valueRank;
        this.arrayDimensions = ((VariableTypeAttributesBuilder)b).arrayDimensions;
        this.isAbstract = ((VariableTypeAttributesBuilder)b).isAbstract;
    }

    public static VariableTypeAttributesBuilder<?, ?> builder() {
        return new VariableTypeAttributesBuilderImpl();
    }

    public VariableTypeAttributesBuilder<?, ?> toBuilder() {
        return new VariableTypeAttributesBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableTypeAttributes)) {
            return false;
        }
        VariableTypeAttributes other = (VariableTypeAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$valueRank = this.getValueRank();
        Integer other$valueRank = other.getValueRank();
        if (this$valueRank == null ? other$valueRank != null : !((Object)this$valueRank).equals(other$valueRank)) {
            return false;
        }
        Boolean this$isAbstract = this.getIsAbstract();
        Boolean other$isAbstract = other.getIsAbstract();
        if (this$isAbstract == null ? other$isAbstract != null : !((Object)this$isAbstract).equals(other$isAbstract)) {
            return false;
        }
        Variant this$value = this.getValue();
        Variant other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        NodeId this$dataType = this.getDataType();
        NodeId other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        return Arrays.deepEquals(this.getArrayDimensions(), other.getArrayDimensions());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VariableTypeAttributes;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $valueRank = this.getValueRank();
        result = result * 59 + ($valueRank == null ? 43 : ((Object)$valueRank).hashCode());
        Boolean $isAbstract = this.getIsAbstract();
        result = result * 59 + ($isAbstract == null ? 43 : ((Object)$isAbstract).hashCode());
        Variant $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        NodeId $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArrayDimensions());
        return result;
    }

    @Override
    public String toString() {
        return "VariableTypeAttributes(value=" + this.getValue() + ", dataType=" + this.getDataType() + ", valueRank=" + this.getValueRank() + ", arrayDimensions=" + Arrays.deepToString(this.getArrayDimensions()) + ", isAbstract=" + this.getIsAbstract() + ")";
    }

    private static final class VariableTypeAttributesBuilderImpl
    extends VariableTypeAttributesBuilder<VariableTypeAttributes, VariableTypeAttributesBuilderImpl> {
        private VariableTypeAttributesBuilderImpl() {
        }

        @Override
        protected VariableTypeAttributesBuilderImpl self() {
            return this;
        }

        @Override
        public VariableTypeAttributes build() {
            return new VariableTypeAttributes(this);
        }
    }

    public static abstract class VariableTypeAttributesBuilder<C extends VariableTypeAttributes, B extends VariableTypeAttributesBuilder<C, B>>
    extends NodeAttributes.NodeAttributesBuilder<C, B> {
        private Variant value;
        private NodeId dataType;
        private Integer valueRank;
        private UInteger[] arrayDimensions;
        private Boolean isAbstract;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            VariableTypeAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(VariableTypeAttributes instance, VariableTypeAttributesBuilder<?, ?> b) {
            b.value(instance.value);
            b.dataType(instance.dataType);
            b.valueRank(instance.valueRank);
            b.arrayDimensions(instance.arrayDimensions);
            b.isAbstract(instance.isAbstract);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B value(Variant value) {
            this.value = value;
            return (B)this.self();
        }

        public B dataType(NodeId dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        public B valueRank(Integer valueRank) {
            this.valueRank = valueRank;
            return (B)this.self();
        }

        public B arrayDimensions(UInteger[] arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            return (B)this.self();
        }

        public B isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "VariableTypeAttributes.VariableTypeAttributesBuilder(super=" + super.toString() + ", value=" + this.value + ", dataType=" + this.dataType + ", valueRank=" + this.valueRank + ", arrayDimensions=" + Arrays.deepToString(this.arrayDimensions) + ", isAbstract=" + this.isAbstract + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<VariableTypeAttributes> {
        @Override
        public Class<VariableTypeAttributes> getType() {
            return VariableTypeAttributes.class;
        }

        @Override
        public VariableTypeAttributes decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedAttributes = decoder.readUInt32("SpecifiedAttributes");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            Variant value = decoder.readVariant("Value");
            NodeId dataType = decoder.readNodeId("DataType");
            Integer valueRank = decoder.readInt32("ValueRank");
            UInteger[] arrayDimensions = decoder.readUInt32Array("ArrayDimensions");
            Boolean isAbstract = decoder.readBoolean("IsAbstract");
            return new VariableTypeAttributes(specifiedAttributes, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, isAbstract);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, VariableTypeAttributes value) {
            encoder.writeUInt32("SpecifiedAttributes", value.getSpecifiedAttributes());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeVariant("Value", value.getValue());
            encoder.writeNodeId("DataType", value.getDataType());
            encoder.writeInt32("ValueRank", value.getValueRank());
            encoder.writeUInt32Array("ArrayDimensions", value.getArrayDimensions());
            encoder.writeBoolean("IsAbstract", value.getIsAbstract());
        }
    }
}

