/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ResponseHeader
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=392");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=394");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=393");
    private final DateTime timestamp;
    private final UInteger requestHandle;
    private final StatusCode serviceResult;
    private final DiagnosticInfo serviceDiagnostics;
    private final String[] stringTable;
    private final ExtensionObject additionalHeader;

    public ResponseHeader(DateTime timestamp, UInteger requestHandle, StatusCode serviceResult, DiagnosticInfo serviceDiagnostics, String[] stringTable, ExtensionObject additionalHeader) {
        this.timestamp = timestamp;
        this.requestHandle = requestHandle;
        this.serviceResult = serviceResult;
        this.serviceDiagnostics = serviceDiagnostics;
        this.stringTable = stringTable;
        this.additionalHeader = additionalHeader;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public UInteger getRequestHandle() {
        return this.requestHandle;
    }

    public StatusCode getServiceResult() {
        return this.serviceResult;
    }

    public DiagnosticInfo getServiceDiagnostics() {
        return this.serviceDiagnostics;
    }

    public String[] getStringTable() {
        return this.stringTable;
    }

    public ExtensionObject getAdditionalHeader() {
        return this.additionalHeader;
    }

    protected ResponseHeader(ResponseHeaderBuilder<?, ?> b) {
        super(b);
        this.timestamp = ((ResponseHeaderBuilder)b).timestamp;
        this.requestHandle = ((ResponseHeaderBuilder)b).requestHandle;
        this.serviceResult = ((ResponseHeaderBuilder)b).serviceResult;
        this.serviceDiagnostics = ((ResponseHeaderBuilder)b).serviceDiagnostics;
        this.stringTable = ((ResponseHeaderBuilder)b).stringTable;
        this.additionalHeader = ((ResponseHeaderBuilder)b).additionalHeader;
    }

    public static ResponseHeaderBuilder<?, ?> builder() {
        return new ResponseHeaderBuilderImpl();
    }

    public ResponseHeaderBuilder<?, ?> toBuilder() {
        return new ResponseHeaderBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseHeader)) {
            return false;
        }
        ResponseHeader other = (ResponseHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DateTime this$timestamp = this.getTimestamp();
        DateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        UInteger this$requestHandle = this.getRequestHandle();
        UInteger other$requestHandle = other.getRequestHandle();
        if (this$requestHandle == null ? other$requestHandle != null : !((Object)this$requestHandle).equals(other$requestHandle)) {
            return false;
        }
        StatusCode this$serviceResult = this.getServiceResult();
        StatusCode other$serviceResult = other.getServiceResult();
        if (this$serviceResult == null ? other$serviceResult != null : !((Object)this$serviceResult).equals(other$serviceResult)) {
            return false;
        }
        DiagnosticInfo this$serviceDiagnostics = this.getServiceDiagnostics();
        DiagnosticInfo other$serviceDiagnostics = other.getServiceDiagnostics();
        if (this$serviceDiagnostics == null ? other$serviceDiagnostics != null : !((Object)this$serviceDiagnostics).equals(other$serviceDiagnostics)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getStringTable(), other.getStringTable())) {
            return false;
        }
        ExtensionObject this$additionalHeader = this.getAdditionalHeader();
        ExtensionObject other$additionalHeader = other.getAdditionalHeader();
        return !(this$additionalHeader == null ? other$additionalHeader != null : !((Object)this$additionalHeader).equals(other$additionalHeader));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        UInteger $requestHandle = this.getRequestHandle();
        result = result * 59 + ($requestHandle == null ? 43 : ((Object)$requestHandle).hashCode());
        StatusCode $serviceResult = this.getServiceResult();
        result = result * 59 + ($serviceResult == null ? 43 : ((Object)$serviceResult).hashCode());
        DiagnosticInfo $serviceDiagnostics = this.getServiceDiagnostics();
        result = result * 59 + ($serviceDiagnostics == null ? 43 : ((Object)$serviceDiagnostics).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getStringTable());
        ExtensionObject $additionalHeader = this.getAdditionalHeader();
        result = result * 59 + ($additionalHeader == null ? 43 : ((Object)$additionalHeader).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ResponseHeader(timestamp=" + this.getTimestamp() + ", requestHandle=" + this.getRequestHandle() + ", serviceResult=" + this.getServiceResult() + ", serviceDiagnostics=" + this.getServiceDiagnostics() + ", stringTable=" + Arrays.deepToString(this.getStringTable()) + ", additionalHeader=" + this.getAdditionalHeader() + ")";
    }

    private static final class ResponseHeaderBuilderImpl
    extends ResponseHeaderBuilder<ResponseHeader, ResponseHeaderBuilderImpl> {
        private ResponseHeaderBuilderImpl() {
        }

        @Override
        protected ResponseHeaderBuilderImpl self() {
            return this;
        }

        @Override
        public ResponseHeader build() {
            return new ResponseHeader(this);
        }
    }

    public static abstract class ResponseHeaderBuilder<C extends ResponseHeader, B extends ResponseHeaderBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private DateTime timestamp;
        private UInteger requestHandle;
        private StatusCode serviceResult;
        private DiagnosticInfo serviceDiagnostics;
        private String[] stringTable;
        private ExtensionObject additionalHeader;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ResponseHeaderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ResponseHeader instance, ResponseHeaderBuilder<?, ?> b) {
            b.timestamp(instance.timestamp);
            b.requestHandle(instance.requestHandle);
            b.serviceResult(instance.serviceResult);
            b.serviceDiagnostics(instance.serviceDiagnostics);
            b.stringTable(instance.stringTable);
            b.additionalHeader(instance.additionalHeader);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B timestamp(DateTime timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        public B requestHandle(UInteger requestHandle) {
            this.requestHandle = requestHandle;
            return (B)this.self();
        }

        public B serviceResult(StatusCode serviceResult) {
            this.serviceResult = serviceResult;
            return (B)this.self();
        }

        public B serviceDiagnostics(DiagnosticInfo serviceDiagnostics) {
            this.serviceDiagnostics = serviceDiagnostics;
            return (B)this.self();
        }

        public B stringTable(String[] stringTable) {
            this.stringTable = stringTable;
            return (B)this.self();
        }

        public B additionalHeader(ExtensionObject additionalHeader) {
            this.additionalHeader = additionalHeader;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ResponseHeader.ResponseHeaderBuilder(super=" + super.toString() + ", timestamp=" + this.timestamp + ", requestHandle=" + this.requestHandle + ", serviceResult=" + this.serviceResult + ", serviceDiagnostics=" + this.serviceDiagnostics + ", stringTable=" + Arrays.deepToString(this.stringTable) + ", additionalHeader=" + this.additionalHeader + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ResponseHeader> {
        @Override
        public Class<ResponseHeader> getType() {
            return ResponseHeader.class;
        }

        @Override
        public ResponseHeader decode(SerializationContext context, UaDecoder decoder) {
            DateTime timestamp = decoder.readDateTime("Timestamp");
            UInteger requestHandle = decoder.readUInt32("RequestHandle");
            StatusCode serviceResult = decoder.readStatusCode("ServiceResult");
            DiagnosticInfo serviceDiagnostics = decoder.readDiagnosticInfo("ServiceDiagnostics");
            String[] stringTable = decoder.readStringArray("StringTable");
            ExtensionObject additionalHeader = decoder.readExtensionObject("AdditionalHeader");
            return new ResponseHeader(timestamp, requestHandle, serviceResult, serviceDiagnostics, stringTable, additionalHeader);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ResponseHeader value) {
            encoder.writeDateTime("Timestamp", value.getTimestamp());
            encoder.writeUInt32("RequestHandle", value.getRequestHandle());
            encoder.writeStatusCode("ServiceResult", value.getServiceResult());
            encoder.writeDiagnosticInfo("ServiceDiagnostics", value.getServiceDiagnostics());
            encoder.writeStringArray("StringTable", value.getStringTable());
            encoder.writeExtensionObject("AdditionalHeader", value.getAdditionalHeader());
        }
    }
}

