/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.IoTDBConnectorRequestVersion;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class PipeTransferHandshakeV1Req
extends TPipeTransferReq {
    private transient String timestampPrecision;

    public final String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    protected abstract PipeRequestType getPlanType();

    public final PipeTransferHandshakeV1Req convertToTPipeTransferReq(String timestampPrecision) throws IOException {
        this.timestampPrecision = timestampPrecision;
        this.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        this.type = this.getPlanType().getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((String)timestampPrecision, (OutputStream)outputStream);
            this.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return this;
    }

    protected final PipeTransferHandshakeV1Req translateFromTPipeTransferReq(TPipeTransferReq transferReq) {
        this.timestampPrecision = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        this.version = transferReq.version;
        this.type = transferReq.type;
        return this;
    }

    protected final byte[] convertToTransferHandshakeBytes(String timestampPrecision) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)this.getPlanType().getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)timestampPrecision, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferHandshakeV1Req that = (PipeTransferHandshakeV1Req)((Object)obj);
        return this.timestampPrecision.equals(that.timestampPrecision) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.timestampPrecision, this.version, this.type, this.body);
    }
}

