/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSender;
import org.apache.iotdb.common.rpc.thrift.TServiceProvider;
import org.apache.iotdb.common.rpc.thrift.TServiceType;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResult;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.rpc.TSStatusCode;

public class TestConnectionUtils {
    private static int dataNodeServiceRequestTimeout = CommonDescriptor.getInstance().getConfig().getDnConnectionTimeoutInMS();
    private static int configNodeServiceRequestTimeout = CommonDescriptor.getInstance().getConfig().getCnConnectionTimeoutInMS();

    public static <ServiceProviderLocation, RequestType> List<TTestConnectionResult> testConnectionsImpl(List<ServiceProviderLocation> nodeLocations, TSender sender, Function<ServiceProviderLocation, Integer> getId, Function<ServiceProviderLocation, TEndPoint> getEndPoint, TServiceType serviceType, RequestType requestType, Consumer<AsyncRequestContext<Object, TSStatus, RequestType, ServiceProviderLocation>> sendRequest) {
        Map<Integer, Object> nodeLocationMap = nodeLocations.stream().collect(Collectors.toMap(getId, location -> location));
        AsyncRequestContext requestContext = new AsyncRequestContext(requestType, new Object(), nodeLocationMap);
        sendRequest.accept(requestContext);
        Map<Integer, Object> anotherNodeLocationMap = nodeLocations.stream().collect(Collectors.toMap(getId, location -> location));
        ArrayList<TTestConnectionResult> results = new ArrayList<TTestConnectionResult>();
        requestContext.getResponseMap().forEach((nodeId, status) -> {
            TEndPoint endPoint = (TEndPoint)getEndPoint.apply(anotherNodeLocationMap.get(nodeId));
            TServiceProvider serviceProvider = new TServiceProvider(endPoint, serviceType);
            TTestConnectionResult result = new TTestConnectionResult();
            result.setSender(sender);
            result.setServiceProvider(serviceProvider);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setReason(status.getMessage());
            }
            results.add(result);
        });
        return results;
    }

    public static int calculateCnLeaderToAllCnMaxTime() {
        return configNodeServiceRequestTimeout + configNodeServiceRequestTimeout + dataNodeServiceRequestTimeout;
    }

    public static int calculateCnLeaderToAllDnMaxTime() {
        return configNodeServiceRequestTimeout + configNodeServiceRequestTimeout + 3 * dataNodeServiceRequestTimeout;
    }

    public static int calculateCnLeaderToAllNodeMaxTime() {
        return (int)((double)(TestConnectionUtils.calculateCnLeaderToAllCnMaxTime() + TestConnectionUtils.calculateCnLeaderToAllDnMaxTime()) * 1.1);
    }

    public static int calculateDnToCnLeaderMaxTime() {
        return TestConnectionUtils.calculateCnLeaderToAllDnMaxTime() + CommonDescriptor.getInstance().getConfig().getDnConnectionTimeoutInMS();
    }
}

