/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.quotas;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.db.storageengine.rescon.quotas.QuotaLimiter;

public class ThrottleQuotaLimit {
    private Map<String, QuotaLimiter> userQuotaLimiter = new HashMap<String, QuotaLimiter>();
    private final Map<String, Long> memLimit = new HashMap<String, Long>();
    private final Map<String, Integer> cpuLimit = new HashMap<String, Integer>();

    public void setQuotas(TSetThrottleQuotaReq req) {
        if (!req.getThrottleQuota().getThrottleLimit().isEmpty()) {
            this.userQuotaLimiter.put(req.getUserName(), QuotaLimiter.fromThrottle(req.getThrottleQuota().getThrottleLimit()));
        }
        this.memLimit.put(req.getUserName(), req.getThrottleQuota().getMemLimit());
        this.cpuLimit.put(req.getUserName(), req.getThrottleQuota().cpuLimit);
    }

    public Map<String, QuotaLimiter> getUserQuotaLimiter() {
        return this.userQuotaLimiter;
    }

    public void setUserQuotaLimiter(Map<String, QuotaLimiter> userQuotaLimiter) {
        this.userQuotaLimiter = userQuotaLimiter;
    }

    public QuotaLimiter getUserLimiter(String userName) {
        return this.userQuotaLimiter.get(userName);
    }

    public boolean checkCpu(String userName, int cpuNum) {
        return this.cpuLimit.get(userName) == null || this.cpuLimit.get(userName) == 0 || this.cpuLimit.get(userName) > cpuNum;
    }

    public boolean checkMemory(String userName, long estimatedMemory) {
        return this.memLimit.get(userName) == null || this.memLimit.get(userName) == 0L || this.memLimit.get(userName) > estimatedMemory;
    }
}

