/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.LinearFill;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.read.common.block.column.IntColumn;
import org.apache.tsfile.read.common.block.column.IntColumnBuilder;

public class IntLinearFill
extends LinearFill {
    private int previousValue;
    private int nextValue;
    private int nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((int[])array)[index] = column.getInt(index);
    }

    @Override
    void fillValue(Object array, int index, double factor) {
        ((int[])array)[index] = this.getFilledValue(factor);
    }

    @Override
    Object createValueArray(int size) {
        return new int[size];
    }

    @Override
    Column createNullValueColumn() {
        return IntColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn(double[] factors) {
        int size = factors.length;
        int[] filledValue = new int[size];
        for (int i = 0; i < size; ++i) {
            filledValue[i] = this.getFilledValue(factors[i]);
        }
        return new IntColumn(size, Optional.empty(), filledValue);
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new IntColumn(size, Optional.of(isNull), (int[])array);
        }
        return new IntColumn(size, Optional.empty(), (int[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getInt(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getInt(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getInt(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private int getFilledValue(double factor) {
        return (int)((double)this.previousValue + (double)(this.nextValueInCurrentColumn - this.previousValue) * factor);
    }
}

