/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface Pending<I, O> {
    public CompletableFuture<O> getFuture();

    public I getInput();

    public static <I, O> CompletableFuture<List<O>> callback(List<? extends Pending<I, O>> pending) {
        CompletableFuture<List<O>> future = new CompletableFuture<List<O>>();
        future.thenAccept(results -> {
            if (results.size() != pending.size()) {
                String message = String.format("result size (%s) does not match pending size (%s)", results.size(), pending.size());
                throw new RuntimeException(message);
            }
            Iterator pi = pending.iterator();
            Iterator ri = results.iterator();
            while (pi.hasNext() && ri.hasNext()) {
                ((Pending)pi.next()).getFuture().complete(ri.next());
            }
        });
        return future;
    }
}

