/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.runtime;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipePeriodicalJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPipePeriodicalJobExecutor.class);
    private final ScheduledExecutorService executorService;
    private final long minIntervalSeconds;
    private long rounds;
    private Future<?> executorFuture;
    private final List<Pair<WrappedRunnable, Long>> periodicalJobs = new CopyOnWriteArrayList<Pair<WrappedRunnable, Long>>();

    public AbstractPipePeriodicalJobExecutor(ScheduledExecutorService executorService, long minIntervalSeconds) {
        this.executorService = executorService;
        this.minIntervalSeconds = minIntervalSeconds;
    }

    public void register(final String id, final Runnable periodicalJob, long intervalInSeconds) {
        this.periodicalJobs.add((Pair<WrappedRunnable, Long>)new Pair((Object)new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                try {
                    periodicalJob.run();
                }
                catch (Exception e) {
                    LOGGER.warn("Periodical job {} failed.", (Object)id, (Object)e);
                }
            }
        }, (Object)Math.max(intervalInSeconds / this.minIntervalSeconds, 1L)));
        LOGGER.info("Pipe periodical job {} is registered successfully. Interval: {} seconds.", (Object)id, (Object)(Math.max(intervalInSeconds / this.minIntervalSeconds, 1L) * this.minIntervalSeconds));
    }

    public synchronized void start() {
        if (this.executorFuture == null) {
            this.rounds = 0L;
            this.executorFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay(this.executorService, this::execute, this.minIntervalSeconds, this.minIntervalSeconds, TimeUnit.SECONDS);
            LOGGER.info("Pipe periodical job executor is started successfully.");
        }
    }

    protected void execute() {
        ++this.rounds;
        for (Pair<WrappedRunnable, Long> periodicalJob : this.periodicalJobs) {
            if (this.rounds % (Long)periodicalJob.right != 0L) continue;
            ((WrappedRunnable)periodicalJob.left).run();
        }
    }

    public synchronized void stop() {
        if (this.executorFuture != null) {
            this.executorFuture.cancel(false);
            this.executorFuture = null;
            LOGGER.info("Pipe periodical job executor is stopped successfully.");
        }
    }

    public void clear() {
        this.periodicalJobs.clear();
        LOGGER.info("All pipe periodical jobs are cleared successfully.");
    }
}

