/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client.async;

import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.mpp.rpc.thrift.MPPDataExchangeService;
import org.apache.iotdb.rpc.TNonblockingSocketWrapper;
import org.apache.thrift.async.TAsyncClientManager;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataNodeMPPDataExchangeServiceClient
extends MPPDataExchangeService.AsyncClient
implements ThriftClient {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDataNodeMPPDataExchangeServiceClient.class);
    private final boolean printLogWhenEncounterException;
    private final TEndPoint endpoint;
    private final ClientManager<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> clientManager;

    public AsyncDataNodeMPPDataExchangeServiceClient(ThriftClientProperty property, TEndPoint endpoint, TAsyncClientManager tClientManager, ClientManager<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> clientManager) throws IOException {
        super(property.getProtocolFactory(), tClientManager, (TNonblockingTransport)TNonblockingSocketWrapper.wrap((String)endpoint.getIp(), (int)endpoint.getPort(), (int)property.getConnectionTimeoutMs()));
        this.setTimeout(property.getConnectionTimeoutMs());
        this.printLogWhenEncounterException = property.isPrintLogWhenEncounterException();
        this.endpoint = endpoint;
        this.clientManager = clientManager;
    }

    public void onComplete() {
        super.onComplete();
        this.returnSelf();
    }

    public void onError(Exception e) {
        super.onError(e);
        ThriftClient.resolveException(e, this);
        this.returnSelf();
    }

    @Override
    public void invalidate() {
        if (!this.hasError()) {
            super.onError(new Exception("This client has been invalidated"));
        }
    }

    @Override
    public void invalidateAll() {
        this.clientManager.clear(this.endpoint);
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return this.printLogWhenEncounterException;
    }

    private void returnSelf() {
        this.clientManager.returnClient(this.endpoint, this);
    }

    private void close() {
        this.___transport.close();
        this.___currentMethod = null;
    }

    private boolean isReady() {
        try {
            this.checkReady();
            return true;
        }
        catch (Exception e) {
            if (this.printLogWhenEncounterException) {
                logger.error("Unexpected exception occurs in {}, error msg is {}", (Object)this, (Object)ExceptionUtils.getRootCause((Throwable)e).toString());
            }
            return false;
        }
    }

    public String toString() {
        return String.format("AsyncDataNodeMPPDataExchangeServiceClient{%s}", this.endpoint);
    }

    public static class Factory
    extends AsyncThriftClientFactory<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> {
        public Factory(ClientManager<TEndPoint, AsyncDataNodeMPPDataExchangeServiceClient> clientManager, ThriftClientProperty thriftClientProperty, String threadName) {
            super(clientManager, thriftClientProperty, threadName);
        }

        public void destroyObject(TEndPoint endPoint, PooledObject<AsyncDataNodeMPPDataExchangeServiceClient> pooledObject) {
            ((AsyncDataNodeMPPDataExchangeServiceClient)pooledObject.getObject()).close();
        }

        public PooledObject<AsyncDataNodeMPPDataExchangeServiceClient> makeObject(TEndPoint endPoint) throws Exception {
            return new DefaultPooledObject((Object)new AsyncDataNodeMPPDataExchangeServiceClient(this.thriftClientProperty, endPoint, this.tManagers[this.clientCnt.incrementAndGet() % this.tManagers.length], this.clientManager));
        }

        public boolean validateObject(TEndPoint endPoint, PooledObject<AsyncDataNodeMPPDataExchangeServiceClient> pooledObject) {
            return ((AsyncDataNodeMPPDataExchangeServiceClient)pooledObject.getObject()).isReady();
        }
    }
}

