/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.file.lock;

import java.util.List;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.lock.Locker;
import org.apache.seata.server.lock.AbstractLockManager;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.storage.file.lock.FileLocker;
import org.apache.seata.server.storage.raft.lock.RaftLockManager;
import org.slf4j.MDC;

@LoadLevel(name="file")
public class FileLockManager
extends AbstractLockManager {
    public Locker getLocker(BranchSession branchSession) {
        return new FileLocker(branchSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        List branchSessions = globalSession.getBranchSessions();
        boolean releaseLockResult = true;
        for (BranchSession branchSession : branchSessions) {
            try {
                MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(branchSession.getBranchId()));
                releaseLockResult = this instanceof RaftLockManager ? super.releaseLock(branchSession) : this.releaseLock(branchSession);
            }
            finally {
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
        return releaseLockResult;
    }
}

