/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.core.rpc.netty.http.filter.HttpFilterContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilter;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterChain;

public class HttpRequestFilterManager {
    private static final List<HttpRequestFilter> HTTP_REQUEST_FILTERS = new ArrayList<HttpRequestFilter>();
    private static HttpRequestFilterChain HTTP_REQUEST_FILTER_CHAIN;
    private static volatile boolean initialized;

    public static synchronized void initializeFilters() {
        if (initialized) {
            return;
        }
        List httpRequestFilters = EnhancedServiceLoader.loadAll(HttpRequestFilter.class);
        for (HttpRequestFilter filter : httpRequestFilters) {
            if (!filter.shouldApply()) continue;
            HTTP_REQUEST_FILTERS.add(filter);
        }
        HTTP_REQUEST_FILTERS.sort(Comparator.comparingInt(HttpRequestFilter::getOrder));
        HTTP_REQUEST_FILTER_CHAIN = new HttpRequestFilterChain(HTTP_REQUEST_FILTERS, null);
        initialized = true;
    }

    public static HttpRequestFilterChain getFilterChain() {
        if (!initialized) {
            throw new IllegalStateException("HttpRequestFilterManager not initialized.");
        }
        return HTTP_REQUEST_FILTER_CHAIN;
    }

    public static HttpRequestFilterChain getFilterChain(Consumer<HttpFilterContext<?>> finalAction) {
        if (!initialized) {
            throw new IllegalStateException("HttpRequestFilterManager not initialized.");
        }
        return new HttpRequestFilterChain(HTTP_REQUEST_FILTERS, finalAction);
    }

    static {
        initialized = false;
    }
}

