/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.seata.common.executor.HttpCallback;
import org.apache.seata.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final Map<Integer, OkHttpClient> HTTP_CLIENT_MAP = new ConcurrentHashMap<Integer, OkHttpClient>();
    private static final Map<Integer, OkHttpClient> HTTP2_CLIENT_MAP = new ConcurrentHashMap<Integer, OkHttpClient>();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    public static final MediaType MEDIA_TYPE_FORM_URLENCODED = MediaType.parse((String)"application/x-www-form-urlencoded");

    public static Response doPost(String url, Map<String, String> params, Map<String, String> header, int timeout) throws IOException {
        String contentType = header != null ? header.get("Content-Type") : "";
        RequestBody requestBody = HttpClientUtil.createRequestBody(params, contentType);
        Request request = HttpClientUtil.buildRequest(url, header, requestBody, "POST");
        OkHttpClient client = HttpClientUtil.createHttp1ClientWithTimeout(timeout);
        return client.newCall(request).execute();
    }

    public static Response doPost(String url, String body, Map<String, String> header, int timeout) throws IOException {
        String contentType = header != null ? header.get("Content-Type") : "";
        MediaType mediaType = StringUtils.isNotBlank(contentType) ? MediaType.parse((String)contentType) : MEDIA_TYPE_JSON;
        RequestBody requestBody = StringUtils.isNotBlank(body) ? RequestBody.create((String)body, (MediaType)mediaType) : RequestBody.create((byte[])new byte[0], (MediaType)mediaType);
        Request request = HttpClientUtil.buildRequest(url, header, requestBody, "POST");
        OkHttpClient client = HttpClientUtil.createHttp1ClientWithTimeout(timeout);
        return client.newCall(request).execute();
    }

    public static Response doGet(String url, Map<String, String> param, Map<String, String> header, int timeout) throws IOException {
        String urlWithParams = HttpClientUtil.buildUrlWithParams(url, param);
        Request request = HttpClientUtil.buildRequest(urlWithParams, header, null, "GET");
        OkHttpClient client = HttpClientUtil.createHttp1ClientWithTimeout(timeout);
        return client.newCall(request).execute();
    }

    public static Response doPostJson(String url, String jsonBody, Map<String, String> headers, int timeout) throws IOException {
        RequestBody requestBody = jsonBody != null ? RequestBody.create((String)jsonBody, (MediaType)MEDIA_TYPE_JSON) : RequestBody.create((byte[])new byte[0], (MediaType)MEDIA_TYPE_JSON);
        HashMap<String, String> headersWithContentType = headers != null ? new HashMap<String, String>(headers) : new HashMap();
        headersWithContentType.put("Content-Type", "application/json");
        Request request = HttpClientUtil.buildRequest(url, headersWithContentType, requestBody, "POST");
        OkHttpClient client = HttpClientUtil.createHttp1ClientWithTimeout(timeout);
        return client.newCall(request).execute();
    }

    public static void doPostWithHttp2(String url, Map<String, String> params, Map<String, String> headers, HttpCallback<Response> callback) {
        HttpClientUtil.doPostWithHttp2(url, params, headers, callback, 10000);
    }

    public static void doPostWithHttp2(String url, Map<String, String> params, Map<String, String> headers, HttpCallback<Response> callback, int timeoutMillis) {
        try {
            String contentType = headers != null ? headers.get("Content-Type") : "";
            RequestBody requestBody = HttpClientUtil.createRequestBody(params, contentType);
            Request request = HttpClientUtil.buildRequest(url, headers, requestBody, "POST");
            OkHttpClient client = HttpClientUtil.createHttp2ClientWithTimeout(timeoutMillis);
            HttpClientUtil.executeAsync(client, request, callback);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            callback.onFailure(e);
        }
    }

    public static void doPostWithHttp2(String url, String body, Map<String, String> headers, HttpCallback<Response> callback) {
        HttpClientUtil.doPostWithHttp2(url, body, headers, callback, 10000);
    }

    public static void doPostWithHttp2(String url, String body, Map<String, String> headers, HttpCallback<Response> callback, int timeout) {
        RequestBody requestBody = StringUtils.isNotBlank(body) ? RequestBody.create((String)body, (MediaType)MEDIA_TYPE_JSON) : RequestBody.create((byte[])new byte[0], (MediaType)MEDIA_TYPE_JSON);
        Request request = HttpClientUtil.buildRequest(url, headers, requestBody, "POST");
        OkHttpClient client = HttpClientUtil.createHttp2ClientWithTimeout(timeout);
        HttpClientUtil.executeAsync(client, request, callback);
    }

    public static void doGetWithHttp2(String url, Map<String, String> headers, HttpCallback<Response> callback, int timeout) {
        Request request = HttpClientUtil.buildRequest(url, headers, null, "GET");
        OkHttpClient client = HttpClientUtil.createHttp2ClientWithTimeout(timeout);
        HttpClientUtil.executeAsync(client, request, callback);
    }

    private static RequestBody createRequestBody(Map<String, String> params, String contentType) throws JsonProcessingException {
        String mediaTypeOnly;
        if (params == null || params.isEmpty()) {
            return RequestBody.create((byte[])new byte[0]);
        }
        String string = mediaTypeOnly = contentType == null ? "" : contentType.split(";")[0].trim();
        if (MEDIA_TYPE_FORM_URLENCODED.toString().equals(mediaTypeOnly)) {
            FormBody.Builder formBuilder = new FormBody.Builder();
            params.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
            return formBuilder.build();
        }
        String json = OBJECT_MAPPER.writeValueAsString(params);
        return RequestBody.create((String)json, (MediaType)MEDIA_TYPE_JSON);
    }

    private static OkHttpClient createHttp1ClientWithTimeout(int timeoutMillis) {
        return HTTP_CLIENT_MAP.computeIfAbsent(timeoutMillis, k -> new OkHttpClient.Builder().connectTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).build());
    }

    private static OkHttpClient createHttp2ClientWithTimeout(int timeoutMillis) {
        return HTTP2_CLIENT_MAP.computeIfAbsent(timeoutMillis, k -> new OkHttpClient.Builder().protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE)).connectTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout((long)timeoutMillis, TimeUnit.MILLISECONDS).build());
    }

    private static Request buildRequest(String url, Map<String, String> headers, RequestBody requestBody, String method) {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((Headers.Builder)headerBuilder).add(arg_0, arg_1));
        }
        Request.Builder requestBuilder = new Request.Builder().url(url).headers(headerBuilder.build());
        if ("POST".equals(method)) {
            if (requestBody == null) {
                requestBody = RequestBody.create((byte[])new byte[0], (MediaType)MEDIA_TYPE_JSON);
            }
            requestBuilder.post(requestBody);
        } else if ("GET".equals(method)) {
            requestBuilder.get();
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
        return requestBuilder.build();
    }

    private static String buildUrlWithParams(String url, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        boolean first = !url.contains("?");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                urlBuilder.append("?");
                first = false;
            } else {
                urlBuilder.append("&");
            }
            try {
                urlBuilder.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return urlBuilder.toString();
    }

    private static void executeAsync(OkHttpClient client, Request request, final HttpCallback<Response> callback) {
        client.newCall(request).enqueue(new Callback(){

            public void onResponse(Call call, Response response) {
                try {
                    callback.onSuccess(response);
                }
                finally {
                    response.close();
                }
            }

            public void onFailure(Call call, IOException e) {
                if (call.isCanceled()) {
                    callback.onCancelled();
                } else {
                    callback.onFailure(e);
                }
            }
        });
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            HTTP_CLIENT_MAP.values().parallelStream().forEach(client -> {
                try {
                    Thread.sleep(3000L);
                    client.dispatcher().executorService().shutdown();
                    if (!client.dispatcher().executorService().awaitTermination(3L, TimeUnit.SECONDS)) {
                        LOGGER.warn("Timeout waiting for OkHttp executor service to terminate.");
                    }
                    client.connectionPool().evictAll();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("Interrupted while waiting for OkHttp executor service to terminate.", (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            });
            HTTP2_CLIENT_MAP.values().parallelStream().forEach(client -> {
                try {
                    client.dispatcher().executorService().shutdown();
                    if (!client.dispatcher().executorService().awaitTermination(3L, TimeUnit.SECONDS)) {
                        LOGGER.warn("Timeout waiting for OkHttp executor service to terminate.");
                    }
                    client.connectionPool().evictAll();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.error("Interrupted while waiting for OkHttp executor service to terminate.", (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            });
        }));
    }
}

