/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.fory.Fory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.collection.ClassValueCache;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.ScalaTypes;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.unsafe._JDKAccess;

@Internal
public class DefaultValueUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValueUtils.class);
    private static final ClassValueCache<Map<Integer, Object>> cachedCtrDefaultValues = ClassValueCache.newClassKeySoftCache(32);
    private static final ClassValueCache<DefaultValueField[]> defaultValueFieldsCache = ClassValueCache.newClassKeySoftCache(32);
    private static final ClassValueCache<Map<String, Object>> allDefaultValuesCache = ClassValueCache.newClassKeySoftCache(32);
    private static final DefaultValueSupport SCALA_DEFAULT_VALUE_SUPPORT = new ScalaDefaultValueSupport();
    private static DefaultValueSupport KOTLIN_DEFAULT_VALUE_SUPPORT = null;

    public static synchronized DefaultValueSupport getScalaDefaultValueSupport() {
        return SCALA_DEFAULT_VALUE_SUPPORT;
    }

    public static synchronized DefaultValueSupport getKotlinDefaultValueSupport() {
        return KOTLIN_DEFAULT_VALUE_SUPPORT;
    }

    public static synchronized void setKotlinDefaultValueSupport(DefaultValueSupport defaultValueSupport) {
        KOTLIN_DEFAULT_VALUE_SUPPORT = defaultValueSupport;
    }

    public static void setDefaultValues(Object obj, DefaultValueField[] defaultValueFields) {
        block10: for (DefaultValueField defaultField : defaultValueFields) {
            FieldAccessor fieldAccessor = defaultField.getFieldAccessor();
            if (fieldAccessor == null) continue;
            Object defaultValue = defaultField.getDefaultValue();
            short classId = defaultField.getClassId();
            long fieldOffset = fieldAccessor.getFieldOffset();
            switch (classId) {
                case 5: 
                case 14: {
                    Platform.putBoolean(obj, fieldOffset, (Boolean)defaultValue);
                    continue block10;
                }
                case 6: 
                case 15: {
                    Platform.putByte(obj, fieldOffset, (Byte)defaultValue);
                    continue block10;
                }
                case 7: 
                case 16: {
                    Platform.putChar(obj, fieldOffset, ((Character)defaultValue).charValue());
                    continue block10;
                }
                case 8: 
                case 17: {
                    Platform.putShort(obj, fieldOffset, (Short)defaultValue);
                    continue block10;
                }
                case 9: 
                case 18: {
                    Platform.putInt(obj, fieldOffset, (Integer)defaultValue);
                    continue block10;
                }
                case 11: 
                case 20: {
                    Platform.putLong(obj, fieldOffset, (Long)defaultValue);
                    continue block10;
                }
                case 10: 
                case 19: {
                    Platform.putFloat(obj, fieldOffset, ((Float)defaultValue).floatValue());
                    continue block10;
                }
                case 12: 
                case 21: {
                    Platform.putDouble(obj, fieldOffset, (Double)defaultValue);
                    continue block10;
                }
                default: {
                    fieldAccessor.putObject(obj, defaultValue);
                }
            }
        }
    }

    public static Object getScalaDefaultValue(Class<?> cls, String fieldName) {
        return DefaultValueUtils.getScalaDefaultValueSupport().getDefaultValue(cls, fieldName);
    }

    public static Object getKotlinDefaultValue(Class<?> cls, String fieldName) {
        return DefaultValueUtils.getKotlinDefaultValueSupport().getDefaultValue(cls, fieldName);
    }

    public static final class ScalaDefaultValueSupport
    extends DefaultValueSupport {
        @Override
        public boolean hasDefaultValues(Class<?> cls) {
            return this.getAllDefaultValues(cls).size() > 0;
        }

        @Override
        public Object getDefaultValue(Class<?> cls, String fieldName) {
            Map<String, Object> allDefaults = this.getAllDefaultValues(cls);
            return allDefaults.get(fieldName);
        }

        @Override
        public Map<String, Object> getAllDefaultValues(Class<?> cls) {
            Preconditions.checkNotNull(cls, "Class must not be null");
            HashMap<String, Object> allDefaults = (HashMap<String, Object>)allDefaultValuesCache.getIfPresent(cls);
            if (allDefaults != null) {
                return allDefaults;
            }
            allDefaults = new HashMap<String, Object>();
            Constructor<?>[] constructors = cls.getDeclaredConstructors();
            Constructor<?> primaryConstructor = null;
            for (Constructor<?> constructor : constructors) {
                if (primaryConstructor != null && constructor.getParameterCount() <= primaryConstructor.getParameterCount()) continue;
                primaryConstructor = constructor;
            }
            Preconditions.checkNotNull(primaryConstructor, "Primary constructor not found for class " + cls.getName());
            Map<Integer, Object> defaultValues = this.getDefaultValuesForClass(cls);
            int paramCount = primaryConstructor.getParameterCount();
            for (int i = 0; i < paramCount; ++i) {
                String paramName = primaryConstructor.getParameters()[i].getName();
                Object defaultValue = defaultValues.get(i + 1);
                if (defaultValue == null) continue;
                allDefaults.put(paramName, defaultValue);
            }
            allDefaultValuesCache.put(cls, allDefaults);
            return allDefaults;
        }

        private Map<Integer, Object> getDefaultValuesForClass(Class<?> cls) {
            if (cachedCtrDefaultValues.getIfPresent(cls) != null) {
                return (Map)cachedCtrDefaultValues.getIfPresent(cls);
            }
            Map<Integer, Object> defaultValueMethods = ScalaTypes.isScalaProductType(cls) ? ScalaDefaultValueSupport.getDefaultValuesForCaseClass(cls) : ScalaDefaultValueSupport.getDefaultValuesForRegularScalaClass(cls);
            cachedCtrDefaultValues.put(cls, defaultValueMethods);
            return defaultValueMethods;
        }

        private static Map<Integer, Object> getDefaultValuesForCaseClass(Class<?> cls) {
            Object companionInstance;
            Class<?> companionClass;
            HashMap<Integer, Object> values;
            block9: {
                values = new HashMap<Integer, Object>();
                String companionClassName = cls.getName() + "$";
                companionClass = null;
                companionInstance = null;
                try {
                    companionClass = Class.forName(companionClassName, false, cls.getClassLoader());
                    companionInstance = companionClass.getField("MODULE$").get(null);
                }
                catch (Exception e) {
                    Class<?> enclosingClass = cls.getEnclosingClass();
                    if (enclosingClass == null) break block9;
                    for (AccessibleObject accessibleObject : enclosingClass.getDeclaredFields()) {
                        if (!((Field)accessibleObject).getType().getName().equals(companionClassName)) continue;
                        ((Field)accessibleObject).setAccessible(true);
                        try {
                            companionInstance = ((Field)accessibleObject).get(null);
                        }
                        catch (Exception e1) {
                            LOG.warn("Error {} accessing companion object for {}, default values support is disabled when deserializing object of type {}", e1.getMessage(), cls.getName(), cls.getName());
                            return values;
                        }
                        if (companionInstance == null) continue;
                        companionClass = companionInstance.getClass();
                        break;
                    }
                }
            }
            if (companionClass == null) {
                LOG.warn("Companion class not found for {}, default values support is disabled when deserializing object of type {}", (Object)cls.getName(), (Object)cls.getName());
                return values;
            }
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(companionClass);
            Method[] companionMethods = companionClass.getDeclaredMethods();
            for (AccessibleObject accessibleObject : companionMethods) {
                String methodName = ((Method)accessibleObject).getName();
                if (!methodName.contains("$default$")) continue;
                try {
                    String indexStr = methodName.substring(methodName.lastIndexOf("$default$") + "$default$".length());
                    int paramIndex = Integer.parseInt(indexStr);
                    MethodHandle methodHandle = lookup.unreflect((Method)accessibleObject);
                    Object defaultValue = methodHandle.invoke(companionInstance);
                    values.put(paramIndex, defaultValue);
                }
                catch (Throwable e) {
                    LOG.warn("Error: {} finding default value methods for {}, default values support is disabled when deserializing object of type {}", e.getMessage(), cls.getName(), cls.getName());
                    return values;
                }
            }
            return values;
        }

        private static Map<Integer, Object> getDefaultValuesForRegularScalaClass(Class<?> cls) {
            HashMap<Integer, Object> values = new HashMap<Integer, Object>();
            try {
                Method[] classMethods;
                MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(cls);
                for (Method method : classMethods = cls.getDeclaredMethods()) {
                    String methodName = method.getName();
                    if (!methodName.contains("$default$")) continue;
                    try {
                        String indexStr = methodName.substring(methodName.lastIndexOf("$default$") + "$default$".length());
                        int paramIndex = Integer.parseInt(indexStr);
                        MethodHandle methodHandle = lookup.unreflect(method);
                        Object defaultValue = methodHandle.invoke();
                        values.put(paramIndex, defaultValue);
                    }
                    catch (Throwable e) {
                        LOG.warn("Error {} finding default value for {}, default values support is disabled when deserializing object of type {}", e.getMessage(), cls.getName(), cls.getName());
                        return values;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error {} finding default value for {}, default values support is disabled when deserializing object of type {}", e.getMessage(), cls.getName(), cls.getName());
                return values;
            }
            return values;
        }
    }

    public static abstract class DefaultValueSupport {
        public abstract boolean hasDefaultValues(Class<?> var1);

        public abstract Map<String, Object> getAllDefaultValues(Class<?> var1);

        public abstract Object getDefaultValue(Class<?> var1, String var2);

        public final DefaultValueField[] buildDefaultValueFields(Fory fory, Class<?> type, List<Descriptor> descriptors) {
            DefaultValueField[] defaultFieldsArray = (DefaultValueField[])defaultValueFieldsCache.getIfPresent(type);
            if (defaultFieldsArray != null) {
                return defaultFieldsArray;
            }
            try {
                HashSet<String> serializedFieldNames = new HashSet<String>();
                for (Descriptor descriptor : descriptors) {
                    Field field = descriptor.getField();
                    if (field == null) continue;
                    serializedFieldNames.add(field.getName());
                }
                Field[] allFields = type.getDeclaredFields();
                ArrayList<DefaultValueField> defaultFields = new ArrayList<DefaultValueField>();
                Map<String, Object> allDefaults = this.getAllDefaultValues(type);
                for (Field field : allFields) {
                    String fieldName;
                    Object defaultValue;
                    if (serializedFieldNames.contains(field.getName()) || (defaultValue = allDefaults.get(fieldName = field.getName())) == null || !TypeUtils.wrap(field.getType()).isAssignableFrom(defaultValue.getClass())) continue;
                    FieldAccessor fieldAccessor = FieldAccessor.createAccessor(field);
                    Short classId = fory.getClassResolver().getRegisteredClassId(field.getType());
                    defaultFields.add(new DefaultValueField(fieldName, defaultValue, fieldAccessor, classId != null ? classId : (short)0));
                }
                defaultFieldsArray = defaultFields.toArray(new DefaultValueField[0]);
                defaultValueFieldsCache.put(type, defaultFieldsArray);
            }
            catch (Exception e) {
                LOG.warn("Error {} building Scala default value fields for {}, default values support is disabled when deserializing object of type {}", e.getMessage(), type.getName(), type.getName());
                defaultValueFieldsCache.put(type, new DefaultValueField[0]);
            }
            return defaultFieldsArray;
        }
    }

    public static final class DefaultValueField {
        private final Object defaultValue;
        private final String fieldName;
        private final FieldAccessor fieldAccessor;
        private final short classId;

        private DefaultValueField(String fieldName, Object defaultValue, FieldAccessor fieldAccessor, short classId) {
            this.fieldName = fieldName;
            this.defaultValue = defaultValue;
            this.fieldAccessor = fieldAccessor;
            this.classId = classId;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FieldAccessor getFieldAccessor() {
            return this.fieldAccessor;
        }

        public short getClassId() {
            return this.classId;
        }
    }
}

