/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: pushdown.proto
package org.apache.geaflow.state.pushdown.inner;

public final class PushDownPb {
    private PushDownPb() {
    }

    public static void registerAllExtensions(
        com.google.protobuf.ExtensionRegistryLite registry) {
    }

    public static void registerAllExtensions(
        com.google.protobuf.ExtensionRegistry registry) {
        registerAllExtensions(
            (com.google.protobuf.ExtensionRegistryLite) registry);
    }

    /**
     * Protobuf enum {@code FilterType}
     */
    public enum FilterType
        implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>EMPTY = 0;</code>
         */
        EMPTY(0),
        /**
         * <code>ONLY_VERTEX = 1;</code>
         */
        ONLY_VERTEX(1),
        /**
         * <code>IN_EDGE = 2;</code>
         */
        IN_EDGE(2),
        /**
         * <code>OUT_EDGE = 3;</code>
         */
        OUT_EDGE(3),
        /**
         * <code>VERTEX_TS = 4;</code>
         */
        VERTEX_TS(4),
        /**
         * <code>EDGE_TS = 5;</code>
         */
        EDGE_TS(5),
        /**
         * <code>MULTI_EDGE_TS = 6;</code>
         */
        MULTI_EDGE_TS(6),
        /**
         * <code>VERTEX_LABEL = 7;</code>
         */
        VERTEX_LABEL(7),
        /**
         * <code>EDGE_LABEL = 8;</code>
         */
        EDGE_LABEL(8),
        /**
         * <code>VERTEX_VALUE_DROP = 9;</code>
         */
        VERTEX_VALUE_DROP(9),
        /**
         * <code>EDGE_VALUE_DROP = 10;</code>
         */
        EDGE_VALUE_DROP(10),
        /**
         * <code>TTL = 11;</code>
         */
        TTL(11),
        /**
         * <code>AND = 12;</code>
         */
        AND(12),
        /**
         * <code>OR = 13;</code>
         */
        OR(13),
        /**
         * <code>VERTEX_MUST_CONTAIN = 14;</code>
         */
        VERTEX_MUST_CONTAIN(14),
        /**
         * <code>GENERATED = 15;</code>
         */
        GENERATED(15),
        /**
         * <code>OTHER = 16;</code>
         */
        OTHER(16),
        UNRECOGNIZED(-1),
        ;

        /**
         * <code>EMPTY = 0;</code>
         */
        public static final int EMPTY_VALUE = 0;
        /**
         * <code>ONLY_VERTEX = 1;</code>
         */
        public static final int ONLY_VERTEX_VALUE = 1;
        /**
         * <code>IN_EDGE = 2;</code>
         */
        public static final int IN_EDGE_VALUE = 2;
        /**
         * <code>OUT_EDGE = 3;</code>
         */
        public static final int OUT_EDGE_VALUE = 3;
        /**
         * <code>VERTEX_TS = 4;</code>
         */
        public static final int VERTEX_TS_VALUE = 4;
        /**
         * <code>EDGE_TS = 5;</code>
         */
        public static final int EDGE_TS_VALUE = 5;
        /**
         * <code>MULTI_EDGE_TS = 6;</code>
         */
        public static final int MULTI_EDGE_TS_VALUE = 6;
        /**
         * <code>VERTEX_LABEL = 7;</code>
         */
        public static final int VERTEX_LABEL_VALUE = 7;
        /**
         * <code>EDGE_LABEL = 8;</code>
         */
        public static final int EDGE_LABEL_VALUE = 8;
        /**
         * <code>VERTEX_VALUE_DROP = 9;</code>
         */
        public static final int VERTEX_VALUE_DROP_VALUE = 9;
        /**
         * <code>EDGE_VALUE_DROP = 10;</code>
         */
        public static final int EDGE_VALUE_DROP_VALUE = 10;
        /**
         * <code>TTL = 11;</code>
         */
        public static final int TTL_VALUE = 11;
        /**
         * <code>AND = 12;</code>
         */
        public static final int AND_VALUE = 12;
        /**
         * <code>OR = 13;</code>
         */
        public static final int OR_VALUE = 13;
        /**
         * <code>VERTEX_MUST_CONTAIN = 14;</code>
         */
        public static final int VERTEX_MUST_CONTAIN_VALUE = 14;
        /**
         * <code>GENERATED = 15;</code>
         */
        public static final int GENERATED_VALUE = 15;
        /**
         * <code>OTHER = 16;</code>
         */
        public static final int OTHER_VALUE = 16;


        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new java.lang.IllegalArgumentException(
                    "Can't get the number of an unknown enum value.");
            }
            return value;
        }

        /**
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static FilterType valueOf(int value) {
            return forNumber(value);
        }

        public static FilterType forNumber(int value) {
            switch (value) {
                case 0:
                    return EMPTY;
                case 1:
                    return ONLY_VERTEX;
                case 2:
                    return IN_EDGE;
                case 3:
                    return OUT_EDGE;
                case 4:
                    return VERTEX_TS;
                case 5:
                    return EDGE_TS;
                case 6:
                    return MULTI_EDGE_TS;
                case 7:
                    return VERTEX_LABEL;
                case 8:
                    return EDGE_LABEL;
                case 9:
                    return VERTEX_VALUE_DROP;
                case 10:
                    return EDGE_VALUE_DROP;
                case 11:
                    return TTL;
                case 12:
                    return AND;
                case 13:
                    return OR;
                case 14:
                    return VERTEX_MUST_CONTAIN;
                case 15:
                    return GENERATED;
                case 16:
                    return OTHER;
                default:
                    return null;
            }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<FilterType>
        internalGetValueMap() {
            return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<
            FilterType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FilterType>() {
                public FilterType findValueByNumber(int number) {
                    return FilterType.forNumber(number);
                }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
            return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
            return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
            return PushDownPb.getDescriptor().getEnumTypes().get(0);
        }

        private static final FilterType[] VALUES = values();

        public static FilterType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
                throw new java.lang.IllegalArgumentException(
                    "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private final int value;

        private FilterType(int value) {
            this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:FilterType)
    }

    /**
     * Protobuf enum {@code SortType}
     */
    public enum SortType
        implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>SRC_ID = 0;</code>
         */
        SRC_ID(0),
        /**
         * <code>DIRECTION = 1;</code>
         */
        DIRECTION(1),
        /**
         * <code>DESC_TIME = 2;</code>
         */
        DESC_TIME(2),
        /**
         * <code>TIME = 3;</code>
         */
        TIME(3),
        /**
         * <code>LABEL = 4;</code>
         */
        LABEL(4),
        /**
         * <code>DST_ID = 5;</code>
         */
        DST_ID(5),
        UNRECOGNIZED(-1),
        ;

        /**
         * <code>SRC_ID = 0;</code>
         */
        public static final int SRC_ID_VALUE = 0;
        /**
         * <code>DIRECTION = 1;</code>
         */
        public static final int DIRECTION_VALUE = 1;
        /**
         * <code>DESC_TIME = 2;</code>
         */
        public static final int DESC_TIME_VALUE = 2;
        /**
         * <code>TIME = 3;</code>
         */
        public static final int TIME_VALUE = 3;
        /**
         * <code>LABEL = 4;</code>
         */
        public static final int LABEL_VALUE = 4;
        /**
         * <code>DST_ID = 5;</code>
         */
        public static final int DST_ID_VALUE = 5;


        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new java.lang.IllegalArgumentException(
                    "Can't get the number of an unknown enum value.");
            }
            return value;
        }

        /**
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static SortType valueOf(int value) {
            return forNumber(value);
        }

        public static SortType forNumber(int value) {
            switch (value) {
                case 0:
                    return SRC_ID;
                case 1:
                    return DIRECTION;
                case 2:
                    return DESC_TIME;
                case 3:
                    return TIME;
                case 4:
                    return LABEL;
                case 5:
                    return DST_ID;
                default:
                    return null;
            }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<SortType>
        internalGetValueMap() {
            return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<
            SortType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SortType>() {
                public SortType findValueByNumber(int number) {
                    return SortType.forNumber(number);
                }
            };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
            return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
            return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
            return PushDownPb.getDescriptor().getEnumTypes().get(1);
        }

        private static final SortType[] VALUES = values();

        public static SortType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != getDescriptor()) {
                throw new java.lang.IllegalArgumentException(
                    "EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private final int value;

        private SortType(int value) {
            this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:SortType)
    }

    public interface PushDownOrBuilder extends
        // @@protoc_insertion_point(interface_extends:PushDown)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>.FilterNode filter_node = 1;</code>
         */
        boolean hasFilterNode();

        /**
         * <code>.FilterNode filter_node = 1;</code>
         */
        PushDownPb.FilterNode getFilterNode();

        /**
         * <code>.FilterNode filter_node = 1;</code>
         */
        PushDownPb.FilterNodeOrBuilder getFilterNodeOrBuilder();

        /**
         * <code>.FilterNodes filter_nodes = 2;</code>
         */
        boolean hasFilterNodes();

        /**
         * <code>.FilterNodes filter_nodes = 2;</code>
         */
        PushDownPb.FilterNodes getFilterNodes();

        /**
         * <code>.FilterNodes filter_nodes = 2;</code>
         */
        PushDownPb.FilterNodesOrBuilder getFilterNodesOrBuilder();

        /**
         * <code>.EdgeLimit edge_limit = 3;</code>
         */
        boolean hasEdgeLimit();

        /**
         * <code>.EdgeLimit edge_limit = 3;</code>
         */
        PushDownPb.EdgeLimit getEdgeLimit();

        /**
         * <code>.EdgeLimit edge_limit = 3;</code>
         */
        PushDownPb.EdgeLimitOrBuilder getEdgeLimitOrBuilder();

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        java.util.List<PushDownPb.SortType> getSortTypeList();

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        int getSortTypeCount();

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        PushDownPb.SortType getSortType(int index);

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        java.util.List<java.lang.Integer>
        getSortTypeValueList();

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        int getSortTypeValue(int index);

        public PushDownPb.PushDown.FilterCase getFilterCase();
    }

    /**
     * Protobuf type {@code PushDown}
     */
    public static final class PushDown extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:PushDown)
        PushDownOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use PushDown.newBuilder() to construct.
        private PushDown(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private PushDown() {
            sortType_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new PushDown();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private PushDown(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 10: {
                            PushDownPb.FilterNode.Builder subBuilder = null;
                            if (filterCase_ == 1) {
                                subBuilder = ((PushDownPb.FilterNode) filter_).toBuilder();
                            }
                            filter_ =
                                input.readMessage(PushDownPb.FilterNode.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom((PushDownPb.FilterNode) filter_);
                                filter_ = subBuilder.buildPartial();
                            }
                            filterCase_ = 1;
                            break;
                        }
                        case 18: {
                            PushDownPb.FilterNodes.Builder subBuilder = null;
                            if (filterCase_ == 2) {
                                subBuilder = ((PushDownPb.FilterNodes) filter_).toBuilder();
                            }
                            filter_ =
                                input.readMessage(PushDownPb.FilterNodes.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom((PushDownPb.FilterNodes) filter_);
                                filter_ = subBuilder.buildPartial();
                            }
                            filterCase_ = 2;
                            break;
                        }
                        case 26: {
                            PushDownPb.EdgeLimit.Builder subBuilder = null;
                            if (edgeLimit_ != null) {
                                subBuilder = edgeLimit_.toBuilder();
                            }
                            edgeLimit_ = input.readMessage(PushDownPb.EdgeLimit.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom(edgeLimit_);
                                edgeLimit_ = subBuilder.buildPartial();
                            }

                            break;
                        }
                        case 32: {
                            int rawValue = input.readEnum();
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                sortType_ = new java.util.ArrayList<java.lang.Integer>();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            sortType_.add(rawValue);
                            break;
                        }
                        case 34: {
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                int rawValue = input.readEnum();
                                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                    sortType_ = new java.util.ArrayList<java.lang.Integer>();
                                    mutable_bitField0_ |= 0x00000001;
                                }
                                sortType_.add(rawValue);
                            }
                            input.popLimit(oldLimit);
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    sortType_ = java.util.Collections.unmodifiableList(sortType_);
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_PushDown_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_PushDown_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.PushDown.class, PushDownPb.PushDown.Builder.class);
        }

        private int filterCase_ = 0;
        private java.lang.Object filter_;

        public enum FilterCase
            implements com.google.protobuf.Internal.EnumLite {
            FILTER_NODE(1),
            FILTER_NODES(2),
            FILTER_NOT_SET(0);
            private final int value;

            private FilterCase(int value) {
                this.value = value;
            }

            /**
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static FilterCase valueOf(int value) {
                return forNumber(value);
            }

            public static FilterCase forNumber(int value) {
                switch (value) {
                    case 1:
                        return FILTER_NODE;
                    case 2:
                        return FILTER_NODES;
                    case 0:
                        return FILTER_NOT_SET;
                    default:
                        return null;
                }
            }

            public int getNumber() {
                return this.value;
            }
        }

        ;

        public FilterCase
        getFilterCase() {
            return FilterCase.forNumber(
                filterCase_);
        }

        public static final int FILTER_NODE_FIELD_NUMBER = 1;

        /**
         * <code>.FilterNode filter_node = 1;</code>
         */
        public boolean hasFilterNode() {
            return filterCase_ == 1;
        }

        /**
         * <code>.FilterNode filter_node = 1;</code>
         */
        public PushDownPb.FilterNode getFilterNode() {
            if (filterCase_ == 1) {
                return (PushDownPb.FilterNode) filter_;
            }
            return PushDownPb.FilterNode.getDefaultInstance();
        }

        /**
         * <code>.FilterNode filter_node = 1;</code>
         */
        public PushDownPb.FilterNodeOrBuilder getFilterNodeOrBuilder() {
            if (filterCase_ == 1) {
                return (PushDownPb.FilterNode) filter_;
            }
            return PushDownPb.FilterNode.getDefaultInstance();
        }

        public static final int FILTER_NODES_FIELD_NUMBER = 2;

        /**
         * <code>.FilterNodes filter_nodes = 2;</code>
         */
        public boolean hasFilterNodes() {
            return filterCase_ == 2;
        }

        /**
         * <code>.FilterNodes filter_nodes = 2;</code>
         */
        public PushDownPb.FilterNodes getFilterNodes() {
            if (filterCase_ == 2) {
                return (PushDownPb.FilterNodes) filter_;
            }
            return PushDownPb.FilterNodes.getDefaultInstance();
        }

        /**
         * <code>.FilterNodes filter_nodes = 2;</code>
         */
        public PushDownPb.FilterNodesOrBuilder getFilterNodesOrBuilder() {
            if (filterCase_ == 2) {
                return (PushDownPb.FilterNodes) filter_;
            }
            return PushDownPb.FilterNodes.getDefaultInstance();
        }

        public static final int EDGE_LIMIT_FIELD_NUMBER = 3;
        private PushDownPb.EdgeLimit edgeLimit_;

        /**
         * <code>.EdgeLimit edge_limit = 3;</code>
         */
        public boolean hasEdgeLimit() {
            return edgeLimit_ != null;
        }

        /**
         * <code>.EdgeLimit edge_limit = 3;</code>
         */
        public PushDownPb.EdgeLimit getEdgeLimit() {
            return edgeLimit_ == null ? PushDownPb.EdgeLimit.getDefaultInstance() : edgeLimit_;
        }

        /**
         * <code>.EdgeLimit edge_limit = 3;</code>
         */
        public PushDownPb.EdgeLimitOrBuilder getEdgeLimitOrBuilder() {
            return getEdgeLimit();
        }

        public static final int SORT_TYPE_FIELD_NUMBER = 4;
        private java.util.List<java.lang.Integer> sortType_;
        private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, PushDownPb.SortType> sortType_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, PushDownPb.SortType>() {
                public PushDownPb.SortType convert(java.lang.Integer from) {
                    @SuppressWarnings("deprecation")
                    PushDownPb.SortType result = PushDownPb.SortType.valueOf(from);
                    return result == null ? PushDownPb.SortType.UNRECOGNIZED : result;
                }
            };

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        public java.util.List<PushDownPb.SortType> getSortTypeList() {
            return new com.google.protobuf.Internal.ListAdapter<
                java.lang.Integer, PushDownPb.SortType>(sortType_, sortType_converter_);
        }

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        public int getSortTypeCount() {
            return sortType_.size();
        }

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        public PushDownPb.SortType getSortType(int index) {
            return sortType_converter_.convert(sortType_.get(index));
        }

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        public java.util.List<java.lang.Integer>
        getSortTypeValueList() {
            return sortType_;
        }

        /**
         * <code>repeated .SortType sort_type = 4;</code>
         */
        public int getSortTypeValue(int index) {
            return sortType_.get(index);
        }

        private int sortTypeMemoizedSerializedSize;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            getSerializedSize();
            if (filterCase_ == 1) {
                output.writeMessage(1, (PushDownPb.FilterNode) filter_);
            }
            if (filterCase_ == 2) {
                output.writeMessage(2, (PushDownPb.FilterNodes) filter_);
            }
            if (edgeLimit_ != null) {
                output.writeMessage(3, getEdgeLimit());
            }
            if (getSortTypeList().size() > 0) {
                output.writeUInt32NoTag(34);
                output.writeUInt32NoTag(sortTypeMemoizedSerializedSize);
            }
            for (int i = 0; i < sortType_.size(); i++) {
                output.writeEnumNoTag(sortType_.get(i));
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (filterCase_ == 1) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(1, (PushDownPb.FilterNode) filter_);
            }
            if (filterCase_ == 2) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(2, (PushDownPb.FilterNodes) filter_);
            }
            if (edgeLimit_ != null) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(3, getEdgeLimit());
            }
            {
                int dataSize = 0;
                for (int i = 0; i < sortType_.size(); i++) {
                    dataSize += com.google.protobuf.CodedOutputStream
                        .computeEnumSizeNoTag(sortType_.get(i));
                }
                size += dataSize;
                if (!getSortTypeList().isEmpty()) {
                    size += 1;
                    size += com.google.protobuf.CodedOutputStream
                        .computeUInt32SizeNoTag(dataSize);
                }
                sortTypeMemoizedSerializedSize = dataSize;
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.PushDown)) {
                return super.equals(obj);
            }
            PushDownPb.PushDown other = (PushDownPb.PushDown) obj;

            if (hasEdgeLimit() != other.hasEdgeLimit()) return false;
            if (hasEdgeLimit()) {
                if (!getEdgeLimit()
                    .equals(other.getEdgeLimit())) return false;
            }
            if (!sortType_.equals(other.sortType_)) return false;
            if (!getFilterCase().equals(other.getFilterCase())) return false;
            switch (filterCase_) {
                case 1:
                    if (!getFilterNode()
                        .equals(other.getFilterNode())) return false;
                    break;
                case 2:
                    if (!getFilterNodes()
                        .equals(other.getFilterNodes())) return false;
                    break;
                case 0:
                default:
            }
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (hasEdgeLimit()) {
                hash = (37 * hash) + EDGE_LIMIT_FIELD_NUMBER;
                hash = (53 * hash) + getEdgeLimit().hashCode();
            }
            if (getSortTypeCount() > 0) {
                hash = (37 * hash) + SORT_TYPE_FIELD_NUMBER;
                hash = (53 * hash) + sortType_.hashCode();
            }
            switch (filterCase_) {
                case 1:
                    hash = (37 * hash) + FILTER_NODE_FIELD_NUMBER;
                    hash = (53 * hash) + getFilterNode().hashCode();
                    break;
                case 2:
                    hash = (37 * hash) + FILTER_NODES_FIELD_NUMBER;
                    hash = (53 * hash) + getFilterNodes().hashCode();
                    break;
                case 0:
                default:
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.PushDown parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.PushDown parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.PushDown parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.PushDown parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.PushDown parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.PushDown parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.PushDown parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.PushDown parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.PushDown parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.PushDown parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.PushDown parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.PushDown parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.PushDown prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code PushDown}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:PushDown)
            PushDownPb.PushDownOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_PushDown_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_PushDown_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.PushDown.class, PushDownPb.PushDown.Builder.class);
            }

            // Construct using PushDownPb.PushDown.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                if (edgeLimitBuilder_ == null) {
                    edgeLimit_ = null;
                } else {
                    edgeLimit_ = null;
                    edgeLimitBuilder_ = null;
                }
                sortType_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);
                filterCase_ = 0;
                filter_ = null;
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_PushDown_descriptor;
            }

            @java.lang.Override
            public PushDownPb.PushDown getDefaultInstanceForType() {
                return PushDownPb.PushDown.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.PushDown build() {
                PushDownPb.PushDown result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.PushDown buildPartial() {
                PushDownPb.PushDown result = new PushDownPb.PushDown(this);
                if (filterCase_ == 1) {
                    if (filterNodeBuilder_ == null) {
                        result.filter_ = filter_;
                    } else {
                        result.filter_ = filterNodeBuilder_.build();
                    }
                }
                if (filterCase_ == 2) {
                    if (filterNodesBuilder_ == null) {
                        result.filter_ = filter_;
                    } else {
                        result.filter_ = filterNodesBuilder_.build();
                    }
                }
                if (edgeLimitBuilder_ == null) {
                    result.edgeLimit_ = edgeLimit_;
                } else {
                    result.edgeLimit_ = edgeLimitBuilder_.build();
                }
                if (((bitField0_ & 0x00000001) != 0)) {
                    sortType_ = java.util.Collections.unmodifiableList(sortType_);
                    bitField0_ = (bitField0_ & ~0x00000001);
                }
                result.sortType_ = sortType_;
                result.filterCase_ = filterCase_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.PushDown) {
                    return mergeFrom((PushDownPb.PushDown) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.PushDown other) {
                if (other == PushDownPb.PushDown.getDefaultInstance()) return this;
                if (other.hasEdgeLimit()) {
                    mergeEdgeLimit(other.getEdgeLimit());
                }
                if (!other.sortType_.isEmpty()) {
                    if (sortType_.isEmpty()) {
                        sortType_ = other.sortType_;
                        bitField0_ = (bitField0_ & ~0x00000001);
                    } else {
                        ensureSortTypeIsMutable();
                        sortType_.addAll(other.sortType_);
                    }
                    onChanged();
                }
                switch (other.getFilterCase()) {
                    case FILTER_NODE: {
                        mergeFilterNode(other.getFilterNode());
                        break;
                    }
                    case FILTER_NODES: {
                        mergeFilterNodes(other.getFilterNodes());
                        break;
                    }
                    case FILTER_NOT_SET: {
                        break;
                    }
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.PushDown parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.PushDown) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int filterCase_ = 0;
            private java.lang.Object filter_;

            public FilterCase
            getFilterCase() {
                return FilterCase.forNumber(
                    filterCase_);
            }

            public Builder clearFilter() {
                filterCase_ = 0;
                filter_ = null;
                onChanged();
                return this;
            }

            private int bitField0_;

            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder> filterNodeBuilder_;

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public boolean hasFilterNode() {
                return filterCase_ == 1;
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public PushDownPb.FilterNode getFilterNode() {
                if (filterNodeBuilder_ == null) {
                    if (filterCase_ == 1) {
                        return (PushDownPb.FilterNode) filter_;
                    }
                    return PushDownPb.FilterNode.getDefaultInstance();
                } else {
                    if (filterCase_ == 1) {
                        return filterNodeBuilder_.getMessage();
                    }
                    return PushDownPb.FilterNode.getDefaultInstance();
                }
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public Builder setFilterNode(PushDownPb.FilterNode value) {
                if (filterNodeBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    filter_ = value;
                    onChanged();
                } else {
                    filterNodeBuilder_.setMessage(value);
                }
                filterCase_ = 1;
                return this;
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public Builder setFilterNode(
                PushDownPb.FilterNode.Builder builderForValue) {
                if (filterNodeBuilder_ == null) {
                    filter_ = builderForValue.build();
                    onChanged();
                } else {
                    filterNodeBuilder_.setMessage(builderForValue.build());
                }
                filterCase_ = 1;
                return this;
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public Builder mergeFilterNode(PushDownPb.FilterNode value) {
                if (filterNodeBuilder_ == null) {
                    if (filterCase_ == 1 &&
                        filter_ != PushDownPb.FilterNode.getDefaultInstance()) {
                        filter_ = PushDownPb.FilterNode.newBuilder((PushDownPb.FilterNode) filter_)
                            .mergeFrom(value).buildPartial();
                    } else {
                        filter_ = value;
                    }
                    onChanged();
                } else {
                    if (filterCase_ == 1) {
                        filterNodeBuilder_.mergeFrom(value);
                    }
                    filterNodeBuilder_.setMessage(value);
                }
                filterCase_ = 1;
                return this;
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public Builder clearFilterNode() {
                if (filterNodeBuilder_ == null) {
                    if (filterCase_ == 1) {
                        filterCase_ = 0;
                        filter_ = null;
                        onChanged();
                    }
                } else {
                    if (filterCase_ == 1) {
                        filterCase_ = 0;
                        filter_ = null;
                    }
                    filterNodeBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public PushDownPb.FilterNode.Builder getFilterNodeBuilder() {
                return getFilterNodeFieldBuilder().getBuilder();
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            public PushDownPb.FilterNodeOrBuilder getFilterNodeOrBuilder() {
                if ((filterCase_ == 1) && (filterNodeBuilder_ != null)) {
                    return filterNodeBuilder_.getMessageOrBuilder();
                } else {
                    if (filterCase_ == 1) {
                        return (PushDownPb.FilterNode) filter_;
                    }
                    return PushDownPb.FilterNode.getDefaultInstance();
                }
            }

            /**
             * <code>.FilterNode filter_node = 1;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder>
            getFilterNodeFieldBuilder() {
                if (filterNodeBuilder_ == null) {
                    if (!(filterCase_ == 1)) {
                        filter_ = PushDownPb.FilterNode.getDefaultInstance();
                    }
                    filterNodeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder>(
                        (PushDownPb.FilterNode) filter_,
                        getParentForChildren(),
                        isClean());
                    filter_ = null;
                }
                filterCase_ = 1;
                onChanged();
                return filterNodeBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.FilterNodes, PushDownPb.FilterNodes.Builder, PushDownPb.FilterNodesOrBuilder> filterNodesBuilder_;

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public boolean hasFilterNodes() {
                return filterCase_ == 2;
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNodes getFilterNodes() {
                if (filterNodesBuilder_ == null) {
                    if (filterCase_ == 2) {
                        return (PushDownPb.FilterNodes) filter_;
                    }
                    return PushDownPb.FilterNodes.getDefaultInstance();
                } else {
                    if (filterCase_ == 2) {
                        return filterNodesBuilder_.getMessage();
                    }
                    return PushDownPb.FilterNodes.getDefaultInstance();
                }
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public Builder setFilterNodes(PushDownPb.FilterNodes value) {
                if (filterNodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    filter_ = value;
                    onChanged();
                } else {
                    filterNodesBuilder_.setMessage(value);
                }
                filterCase_ = 2;
                return this;
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public Builder setFilterNodes(
                PushDownPb.FilterNodes.Builder builderForValue) {
                if (filterNodesBuilder_ == null) {
                    filter_ = builderForValue.build();
                    onChanged();
                } else {
                    filterNodesBuilder_.setMessage(builderForValue.build());
                }
                filterCase_ = 2;
                return this;
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public Builder mergeFilterNodes(PushDownPb.FilterNodes value) {
                if (filterNodesBuilder_ == null) {
                    if (filterCase_ == 2 &&
                        filter_ != PushDownPb.FilterNodes.getDefaultInstance()) {
                        filter_ = PushDownPb.FilterNodes.newBuilder((PushDownPb.FilterNodes) filter_)
                            .mergeFrom(value).buildPartial();
                    } else {
                        filter_ = value;
                    }
                    onChanged();
                } else {
                    if (filterCase_ == 2) {
                        filterNodesBuilder_.mergeFrom(value);
                    }
                    filterNodesBuilder_.setMessage(value);
                }
                filterCase_ = 2;
                return this;
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public Builder clearFilterNodes() {
                if (filterNodesBuilder_ == null) {
                    if (filterCase_ == 2) {
                        filterCase_ = 0;
                        filter_ = null;
                        onChanged();
                    }
                } else {
                    if (filterCase_ == 2) {
                        filterCase_ = 0;
                        filter_ = null;
                    }
                    filterNodesBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNodes.Builder getFilterNodesBuilder() {
                return getFilterNodesFieldBuilder().getBuilder();
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNodesOrBuilder getFilterNodesOrBuilder() {
                if ((filterCase_ == 2) && (filterNodesBuilder_ != null)) {
                    return filterNodesBuilder_.getMessageOrBuilder();
                } else {
                    if (filterCase_ == 2) {
                        return (PushDownPb.FilterNodes) filter_;
                    }
                    return PushDownPb.FilterNodes.getDefaultInstance();
                }
            }

            /**
             * <code>.FilterNodes filter_nodes = 2;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.FilterNodes, PushDownPb.FilterNodes.Builder, PushDownPb.FilterNodesOrBuilder>
            getFilterNodesFieldBuilder() {
                if (filterNodesBuilder_ == null) {
                    if (!(filterCase_ == 2)) {
                        filter_ = PushDownPb.FilterNodes.getDefaultInstance();
                    }
                    filterNodesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.FilterNodes, PushDownPb.FilterNodes.Builder, PushDownPb.FilterNodesOrBuilder>(
                        (PushDownPb.FilterNodes) filter_,
                        getParentForChildren(),
                        isClean());
                    filter_ = null;
                }
                filterCase_ = 2;
                onChanged();
                return filterNodesBuilder_;
            }

            private PushDownPb.EdgeLimit edgeLimit_;
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.EdgeLimit, PushDownPb.EdgeLimit.Builder, PushDownPb.EdgeLimitOrBuilder> edgeLimitBuilder_;

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public boolean hasEdgeLimit() {
                return edgeLimitBuilder_ != null || edgeLimit_ != null;
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public PushDownPb.EdgeLimit getEdgeLimit() {
                if (edgeLimitBuilder_ == null) {
                    return edgeLimit_ == null ? PushDownPb.EdgeLimit.getDefaultInstance() : edgeLimit_;
                } else {
                    return edgeLimitBuilder_.getMessage();
                }
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public Builder setEdgeLimit(PushDownPb.EdgeLimit value) {
                if (edgeLimitBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    edgeLimit_ = value;
                    onChanged();
                } else {
                    edgeLimitBuilder_.setMessage(value);
                }

                return this;
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public Builder setEdgeLimit(
                PushDownPb.EdgeLimit.Builder builderForValue) {
                if (edgeLimitBuilder_ == null) {
                    edgeLimit_ = builderForValue.build();
                    onChanged();
                } else {
                    edgeLimitBuilder_.setMessage(builderForValue.build());
                }

                return this;
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public Builder mergeEdgeLimit(PushDownPb.EdgeLimit value) {
                if (edgeLimitBuilder_ == null) {
                    if (edgeLimit_ != null) {
                        edgeLimit_ =
                            PushDownPb.EdgeLimit.newBuilder(edgeLimit_).mergeFrom(value).buildPartial();
                    } else {
                        edgeLimit_ = value;
                    }
                    onChanged();
                } else {
                    edgeLimitBuilder_.mergeFrom(value);
                }

                return this;
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public Builder clearEdgeLimit() {
                if (edgeLimitBuilder_ == null) {
                    edgeLimit_ = null;
                    onChanged();
                } else {
                    edgeLimit_ = null;
                    edgeLimitBuilder_ = null;
                }

                return this;
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public PushDownPb.EdgeLimit.Builder getEdgeLimitBuilder() {

                onChanged();
                return getEdgeLimitFieldBuilder().getBuilder();
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            public PushDownPb.EdgeLimitOrBuilder getEdgeLimitOrBuilder() {
                if (edgeLimitBuilder_ != null) {
                    return edgeLimitBuilder_.getMessageOrBuilder();
                } else {
                    return edgeLimit_ == null ?
                        PushDownPb.EdgeLimit.getDefaultInstance() : edgeLimit_;
                }
            }

            /**
             * <code>.EdgeLimit edge_limit = 3;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.EdgeLimit, PushDownPb.EdgeLimit.Builder, PushDownPb.EdgeLimitOrBuilder>
            getEdgeLimitFieldBuilder() {
                if (edgeLimitBuilder_ == null) {
                    edgeLimitBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.EdgeLimit, PushDownPb.EdgeLimit.Builder, PushDownPb.EdgeLimitOrBuilder>(
                        getEdgeLimit(),
                        getParentForChildren(),
                        isClean());
                    edgeLimit_ = null;
                }
                return edgeLimitBuilder_;
            }

            private java.util.List<java.lang.Integer> sortType_ =
                java.util.Collections.emptyList();

            private void ensureSortTypeIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    sortType_ = new java.util.ArrayList<java.lang.Integer>(sortType_);
                    bitField0_ |= 0x00000001;
                }
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public java.util.List<PushDownPb.SortType> getSortTypeList() {
                return new com.google.protobuf.Internal.ListAdapter<
                    java.lang.Integer, PushDownPb.SortType>(sortType_, sortType_converter_);
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public int getSortTypeCount() {
                return sortType_.size();
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public PushDownPb.SortType getSortType(int index) {
                return sortType_converter_.convert(sortType_.get(index));
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder setSortType(
                int index, PushDownPb.SortType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureSortTypeIsMutable();
                sortType_.set(index, value.getNumber());
                onChanged();
                return this;
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder addSortType(PushDownPb.SortType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureSortTypeIsMutable();
                sortType_.add(value.getNumber());
                onChanged();
                return this;
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder addAllSortType(
                java.lang.Iterable<? extends PushDownPb.SortType> values) {
                ensureSortTypeIsMutable();
                for (PushDownPb.SortType value : values) {
                    sortType_.add(value.getNumber());
                }
                onChanged();
                return this;
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder clearSortType() {
                sortType_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public java.util.List<java.lang.Integer>
            getSortTypeValueList() {
                return java.util.Collections.unmodifiableList(sortType_);
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public int getSortTypeValue(int index) {
                return sortType_.get(index);
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder setSortTypeValue(
                int index, int value) {
                ensureSortTypeIsMutable();
                sortType_.set(index, value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder addSortTypeValue(int value) {
                ensureSortTypeIsMutable();
                sortType_.add(value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated .SortType sort_type = 4;</code>
             */
            public Builder addAllSortTypeValue(
                java.lang.Iterable<java.lang.Integer> values) {
                ensureSortTypeIsMutable();
                for (int value : values) {
                    sortType_.add(value);
                }
                onChanged();
                return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:PushDown)
        }

        // @@protoc_insertion_point(class_scope:PushDown)
        private static final PushDownPb.PushDown DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.PushDown();
        }

        public static PushDownPb.PushDown getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<PushDown>
            PARSER = new com.google.protobuf.AbstractParser<PushDown>() {
            @java.lang.Override
            public PushDown parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new PushDown(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<PushDown> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<PushDown> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.PushDown getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface EdgeLimitOrBuilder extends
        // @@protoc_insertion_point(interface_extends:EdgeLimit)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>uint64 in = 1;</code>
         */
        long getIn();

        /**
         * <code>uint64 out = 2;</code>
         */
        long getOut();

        /**
         * <code>bool is_single = 3;</code>
         */
        boolean getIsSingle();
    }

    /**
     * Protobuf type {@code EdgeLimit}
     */
    public static final class EdgeLimit extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:EdgeLimit)
        EdgeLimitOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use EdgeLimit.newBuilder() to construct.
        private EdgeLimit(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private EdgeLimit() {
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new EdgeLimit();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private EdgeLimit(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 8: {

                            in_ = input.readUInt64();
                            break;
                        }
                        case 16: {

                            out_ = input.readUInt64();
                            break;
                        }
                        case 24: {

                            isSingle_ = input.readBool();
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_EdgeLimit_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_EdgeLimit_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.EdgeLimit.class, PushDownPb.EdgeLimit.Builder.class);
        }

        public static final int IN_FIELD_NUMBER = 1;
        private long in_;

        /**
         * <code>uint64 in = 1;</code>
         */
        public long getIn() {
            return in_;
        }

        public static final int OUT_FIELD_NUMBER = 2;
        private long out_;

        /**
         * <code>uint64 out = 2;</code>
         */
        public long getOut() {
            return out_;
        }

        public static final int IS_SINGLE_FIELD_NUMBER = 3;
        private boolean isSingle_;

        /**
         * <code>bool is_single = 3;</code>
         */
        public boolean getIsSingle() {
            return isSingle_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            if (in_ != 0L) {
                output.writeUInt64(1, in_);
            }
            if (out_ != 0L) {
                output.writeUInt64(2, out_);
            }
            if (isSingle_ != false) {
                output.writeBool(3, isSingle_);
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (in_ != 0L) {
                size += com.google.protobuf.CodedOutputStream
                    .computeUInt64Size(1, in_);
            }
            if (out_ != 0L) {
                size += com.google.protobuf.CodedOutputStream
                    .computeUInt64Size(2, out_);
            }
            if (isSingle_ != false) {
                size += com.google.protobuf.CodedOutputStream
                    .computeBoolSize(3, isSingle_);
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.EdgeLimit)) {
                return super.equals(obj);
            }
            PushDownPb.EdgeLimit other = (PushDownPb.EdgeLimit) obj;

            if (getIn()
                != other.getIn()) return false;
            if (getOut()
                != other.getOut()) return false;
            if (getIsSingle()
                != other.getIsSingle()) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + IN_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
                getIn());
            hash = (37 * hash) + OUT_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
                getOut());
            hash = (37 * hash) + IS_SINGLE_FIELD_NUMBER;
            hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
                getIsSingle());
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.EdgeLimit parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.EdgeLimit parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.EdgeLimit parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.EdgeLimit parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.EdgeLimit parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.EdgeLimit parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.EdgeLimit prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code EdgeLimit}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:EdgeLimit)
            PushDownPb.EdgeLimitOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_EdgeLimit_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_EdgeLimit_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.EdgeLimit.class, PushDownPb.EdgeLimit.Builder.class);
            }

            // Construct using PushDownPb.EdgeLimit.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                in_ = 0L;

                out_ = 0L;

                isSingle_ = false;

                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_EdgeLimit_descriptor;
            }

            @java.lang.Override
            public PushDownPb.EdgeLimit getDefaultInstanceForType() {
                return PushDownPb.EdgeLimit.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.EdgeLimit build() {
                PushDownPb.EdgeLimit result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.EdgeLimit buildPartial() {
                PushDownPb.EdgeLimit result = new PushDownPb.EdgeLimit(this);
                result.in_ = in_;
                result.out_ = out_;
                result.isSingle_ = isSingle_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.EdgeLimit) {
                    return mergeFrom((PushDownPb.EdgeLimit) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.EdgeLimit other) {
                if (other == PushDownPb.EdgeLimit.getDefaultInstance()) return this;
                if (other.getIn() != 0L) {
                    setIn(other.getIn());
                }
                if (other.getOut() != 0L) {
                    setOut(other.getOut());
                }
                if (other.getIsSingle() != false) {
                    setIsSingle(other.getIsSingle());
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.EdgeLimit parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.EdgeLimit) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private long in_;

            /**
             * <code>uint64 in = 1;</code>
             */
            public long getIn() {
                return in_;
            }

            /**
             * <code>uint64 in = 1;</code>
             */
            public Builder setIn(long value) {

                in_ = value;
                onChanged();
                return this;
            }

            /**
             * <code>uint64 in = 1;</code>
             */
            public Builder clearIn() {

                in_ = 0L;
                onChanged();
                return this;
            }

            private long out_;

            /**
             * <code>uint64 out = 2;</code>
             */
            public long getOut() {
                return out_;
            }

            /**
             * <code>uint64 out = 2;</code>
             */
            public Builder setOut(long value) {

                out_ = value;
                onChanged();
                return this;
            }

            /**
             * <code>uint64 out = 2;</code>
             */
            public Builder clearOut() {

                out_ = 0L;
                onChanged();
                return this;
            }

            private boolean isSingle_;

            /**
             * <code>bool is_single = 3;</code>
             */
            public boolean getIsSingle() {
                return isSingle_;
            }

            /**
             * <code>bool is_single = 3;</code>
             */
            public Builder setIsSingle(boolean value) {

                isSingle_ = value;
                onChanged();
                return this;
            }

            /**
             * <code>bool is_single = 3;</code>
             */
            public Builder clearIsSingle() {

                isSingle_ = false;
                onChanged();
                return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:EdgeLimit)
        }

        // @@protoc_insertion_point(class_scope:EdgeLimit)
        private static final PushDownPb.EdgeLimit DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.EdgeLimit();
        }

        public static PushDownPb.EdgeLimit getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<EdgeLimit>
            PARSER = new com.google.protobuf.AbstractParser<EdgeLimit>() {
            @java.lang.Override
            public EdgeLimit parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new EdgeLimit(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<EdgeLimit> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<EdgeLimit> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.EdgeLimit getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface FilterNodesOrBuilder extends
        // @@protoc_insertion_point(interface_extends:FilterNodes)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>repeated bytes keys = 1;</code>
         */
        java.util.List<com.google.protobuf.ByteString> getKeysList();

        /**
         * <code>repeated bytes keys = 1;</code>
         */
        int getKeysCount();

        /**
         * <code>repeated bytes keys = 1;</code>
         */
        com.google.protobuf.ByteString getKeys(int index);

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        java.util.List<PushDownPb.FilterNode>
        getFilterNodesList();

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        PushDownPb.FilterNode getFilterNodes(int index);

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        int getFilterNodesCount();

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        java.util.List<? extends PushDownPb.FilterNodeOrBuilder>
        getFilterNodesOrBuilderList();

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        PushDownPb.FilterNodeOrBuilder getFilterNodesOrBuilder(
            int index);
    }

    /**
     * Protobuf type {@code FilterNodes}
     */
    public static final class FilterNodes extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:FilterNodes)
        FilterNodesOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use FilterNodes.newBuilder() to construct.
        private FilterNodes(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private FilterNodes() {
            keys_ = java.util.Collections.emptyList();
            filterNodes_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new FilterNodes();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private FilterNodes(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 10: {
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                keys_ = new java.util.ArrayList<com.google.protobuf.ByteString>();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            keys_.add(input.readBytes());
                            break;
                        }
                        case 18: {
                            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                                filterNodes_ = new java.util.ArrayList<PushDownPb.FilterNode>();
                                mutable_bitField0_ |= 0x00000002;
                            }
                            filterNodes_.add(
                                input.readMessage(PushDownPb.FilterNode.parser(), extensionRegistry));
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    keys_ = java.util.Collections.unmodifiableList(keys_); // C
                }
                if (((mutable_bitField0_ & 0x00000002) != 0)) {
                    filterNodes_ = java.util.Collections.unmodifiableList(filterNodes_);
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_FilterNodes_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_FilterNodes_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.FilterNodes.class, PushDownPb.FilterNodes.Builder.class);
        }

        public static final int KEYS_FIELD_NUMBER = 1;
        private java.util.List<com.google.protobuf.ByteString> keys_;

        /**
         * <code>repeated bytes keys = 1;</code>
         */
        public java.util.List<com.google.protobuf.ByteString>
        getKeysList() {
            return keys_;
        }

        /**
         * <code>repeated bytes keys = 1;</code>
         */
        public int getKeysCount() {
            return keys_.size();
        }

        /**
         * <code>repeated bytes keys = 1;</code>
         */
        public com.google.protobuf.ByteString getKeys(int index) {
            return keys_.get(index);
        }

        public static final int FILTER_NODES_FIELD_NUMBER = 2;
        private java.util.List<PushDownPb.FilterNode> filterNodes_;

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        public java.util.List<PushDownPb.FilterNode> getFilterNodesList() {
            return filterNodes_;
        }

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        public java.util.List<? extends PushDownPb.FilterNodeOrBuilder>
        getFilterNodesOrBuilderList() {
            return filterNodes_;
        }

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        public int getFilterNodesCount() {
            return filterNodes_.size();
        }

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        public PushDownPb.FilterNode getFilterNodes(int index) {
            return filterNodes_.get(index);
        }

        /**
         * <code>repeated .FilterNode filter_nodes = 2;</code>
         */
        public PushDownPb.FilterNodeOrBuilder getFilterNodesOrBuilder(
            int index) {
            return filterNodes_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            for (int i = 0; i < keys_.size(); i++) {
                output.writeBytes(1, keys_.get(i));
            }
            for (int i = 0; i < filterNodes_.size(); i++) {
                output.writeMessage(2, filterNodes_.get(i));
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
                int dataSize = 0;
                for (int i = 0; i < keys_.size(); i++) {
                    dataSize += com.google.protobuf.CodedOutputStream
                        .computeBytesSizeNoTag(keys_.get(i));
                }
                size += dataSize;
                size += 1 * getKeysList().size();
            }
            for (int i = 0; i < filterNodes_.size(); i++) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(2, filterNodes_.get(i));
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.FilterNodes)) {
                return super.equals(obj);
            }
            PushDownPb.FilterNodes other = (PushDownPb.FilterNodes) obj;

            if (!getKeysList()
                .equals(other.getKeysList())) return false;
            if (!getFilterNodesList()
                .equals(other.getFilterNodesList())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getKeysCount() > 0) {
                hash = (37 * hash) + KEYS_FIELD_NUMBER;
                hash = (53 * hash) + getKeysList().hashCode();
            }
            if (getFilterNodesCount() > 0) {
                hash = (37 * hash) + FILTER_NODES_FIELD_NUMBER;
                hash = (53 * hash) + getFilterNodesList().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.FilterNodes parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.FilterNodes parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.FilterNodes parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.FilterNodes parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.FilterNodes parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.FilterNodes parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.FilterNodes parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.FilterNodes parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.FilterNodes parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.FilterNodes parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.FilterNodes parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.FilterNodes parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.FilterNodes prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code FilterNodes}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:FilterNodes)
            PushDownPb.FilterNodesOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_FilterNodes_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_FilterNodes_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.FilterNodes.class, PushDownPb.FilterNodes.Builder.class);
            }

            // Construct using PushDownPb.FilterNodes.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
                    getFilterNodesFieldBuilder();
                }
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                keys_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);
                if (filterNodesBuilder_ == null) {
                    filterNodes_ = java.util.Collections.emptyList();
                    bitField0_ = (bitField0_ & ~0x00000002);
                } else {
                    filterNodesBuilder_.clear();
                }
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_FilterNodes_descriptor;
            }

            @java.lang.Override
            public PushDownPb.FilterNodes getDefaultInstanceForType() {
                return PushDownPb.FilterNodes.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.FilterNodes build() {
                PushDownPb.FilterNodes result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.FilterNodes buildPartial() {
                PushDownPb.FilterNodes result = new PushDownPb.FilterNodes(this);
                if (((bitField0_ & 0x00000001) != 0)) {
                    keys_ = java.util.Collections.unmodifiableList(keys_);
                    bitField0_ = (bitField0_ & ~0x00000001);
                }
                result.keys_ = keys_;
                if (filterNodesBuilder_ == null) {
                    if (((bitField0_ & 0x00000002) != 0)) {
                        filterNodes_ = java.util.Collections.unmodifiableList(filterNodes_);
                        bitField0_ = (bitField0_ & ~0x00000002);
                    }
                    result.filterNodes_ = filterNodes_;
                } else {
                    result.filterNodes_ = filterNodesBuilder_.build();
                }
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.FilterNodes) {
                    return mergeFrom((PushDownPb.FilterNodes) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.FilterNodes other) {
                if (other == PushDownPb.FilterNodes.getDefaultInstance()) return this;
                if (!other.keys_.isEmpty()) {
                    if (keys_.isEmpty()) {
                        keys_ = other.keys_;
                        bitField0_ = (bitField0_ & ~0x00000001);
                    } else {
                        ensureKeysIsMutable();
                        keys_.addAll(other.keys_);
                    }
                    onChanged();
                }
                if (filterNodesBuilder_ == null) {
                    if (!other.filterNodes_.isEmpty()) {
                        if (filterNodes_.isEmpty()) {
                            filterNodes_ = other.filterNodes_;
                            bitField0_ = (bitField0_ & ~0x00000002);
                        } else {
                            ensureFilterNodesIsMutable();
                            filterNodes_.addAll(other.filterNodes_);
                        }
                        onChanged();
                    }
                } else {
                    if (!other.filterNodes_.isEmpty()) {
                        if (filterNodesBuilder_.isEmpty()) {
                            filterNodesBuilder_.dispose();
                            filterNodesBuilder_ = null;
                            filterNodes_ = other.filterNodes_;
                            bitField0_ = (bitField0_ & ~0x00000002);
                            filterNodesBuilder_ =
                                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                    getFilterNodesFieldBuilder() : null;
                        } else {
                            filterNodesBuilder_.addAllMessages(other.filterNodes_);
                        }
                    }
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.FilterNodes parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.FilterNodes) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int bitField0_;

            private java.util.List<com.google.protobuf.ByteString> keys_ = java.util.Collections.emptyList();

            private void ensureKeysIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    keys_ = new java.util.ArrayList<com.google.protobuf.ByteString>(keys_);
                    bitField0_ |= 0x00000001;
                }
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public java.util.List<com.google.protobuf.ByteString>
            getKeysList() {
                return ((bitField0_ & 0x00000001) != 0) ?
                    java.util.Collections.unmodifiableList(keys_) : keys_;
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public int getKeysCount() {
                return keys_.size();
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public com.google.protobuf.ByteString getKeys(int index) {
                return keys_.get(index);
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public Builder setKeys(
                int index, com.google.protobuf.ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureKeysIsMutable();
                keys_.set(index, value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public Builder addKeys(com.google.protobuf.ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureKeysIsMutable();
                keys_.add(value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public Builder addAllKeys(
                java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
                ensureKeysIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                    values, keys_);
                onChanged();
                return this;
            }

            /**
             * <code>repeated bytes keys = 1;</code>
             */
            public Builder clearKeys() {
                keys_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }

            private java.util.List<PushDownPb.FilterNode> filterNodes_ =
                java.util.Collections.emptyList();

            private void ensureFilterNodesIsMutable() {
                if (!((bitField0_ & 0x00000002) != 0)) {
                    filterNodes_ = new java.util.ArrayList<PushDownPb.FilterNode>(filterNodes_);
                    bitField0_ |= 0x00000002;
                }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder> filterNodesBuilder_;

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public java.util.List<PushDownPb.FilterNode> getFilterNodesList() {
                if (filterNodesBuilder_ == null) {
                    return java.util.Collections.unmodifiableList(filterNodes_);
                } else {
                    return filterNodesBuilder_.getMessageList();
                }
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public int getFilterNodesCount() {
                if (filterNodesBuilder_ == null) {
                    return filterNodes_.size();
                } else {
                    return filterNodesBuilder_.getCount();
                }
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNode getFilterNodes(int index) {
                if (filterNodesBuilder_ == null) {
                    return filterNodes_.get(index);
                } else {
                    return filterNodesBuilder_.getMessage(index);
                }
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder setFilterNodes(
                int index, PushDownPb.FilterNode value) {
                if (filterNodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    ensureFilterNodesIsMutable();
                    filterNodes_.set(index, value);
                    onChanged();
                } else {
                    filterNodesBuilder_.setMessage(index, value);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder setFilterNodes(
                int index, PushDownPb.FilterNode.Builder builderForValue) {
                if (filterNodesBuilder_ == null) {
                    ensureFilterNodesIsMutable();
                    filterNodes_.set(index, builderForValue.build());
                    onChanged();
                } else {
                    filterNodesBuilder_.setMessage(index, builderForValue.build());
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder addFilterNodes(PushDownPb.FilterNode value) {
                if (filterNodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    ensureFilterNodesIsMutable();
                    filterNodes_.add(value);
                    onChanged();
                } else {
                    filterNodesBuilder_.addMessage(value);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder addFilterNodes(
                int index, PushDownPb.FilterNode value) {
                if (filterNodesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    ensureFilterNodesIsMutable();
                    filterNodes_.add(index, value);
                    onChanged();
                } else {
                    filterNodesBuilder_.addMessage(index, value);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder addFilterNodes(
                PushDownPb.FilterNode.Builder builderForValue) {
                if (filterNodesBuilder_ == null) {
                    ensureFilterNodesIsMutable();
                    filterNodes_.add(builderForValue.build());
                    onChanged();
                } else {
                    filterNodesBuilder_.addMessage(builderForValue.build());
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder addFilterNodes(
                int index, PushDownPb.FilterNode.Builder builderForValue) {
                if (filterNodesBuilder_ == null) {
                    ensureFilterNodesIsMutable();
                    filterNodes_.add(index, builderForValue.build());
                    onChanged();
                } else {
                    filterNodesBuilder_.addMessage(index, builderForValue.build());
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder addAllFilterNodes(
                java.lang.Iterable<? extends PushDownPb.FilterNode> values) {
                if (filterNodesBuilder_ == null) {
                    ensureFilterNodesIsMutable();
                    com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, filterNodes_);
                    onChanged();
                } else {
                    filterNodesBuilder_.addAllMessages(values);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder clearFilterNodes() {
                if (filterNodesBuilder_ == null) {
                    filterNodes_ = java.util.Collections.emptyList();
                    bitField0_ = (bitField0_ & ~0x00000002);
                    onChanged();
                } else {
                    filterNodesBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public Builder removeFilterNodes(int index) {
                if (filterNodesBuilder_ == null) {
                    ensureFilterNodesIsMutable();
                    filterNodes_.remove(index);
                    onChanged();
                } else {
                    filterNodesBuilder_.remove(index);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNode.Builder getFilterNodesBuilder(
                int index) {
                return getFilterNodesFieldBuilder().getBuilder(index);
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNodeOrBuilder getFilterNodesOrBuilder(
                int index) {
                if (filterNodesBuilder_ == null) {
                    return filterNodes_.get(index);
                } else {
                    return filterNodesBuilder_.getMessageOrBuilder(index);
                }
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public java.util.List<? extends PushDownPb.FilterNodeOrBuilder>
            getFilterNodesOrBuilderList() {
                if (filterNodesBuilder_ != null) {
                    return filterNodesBuilder_.getMessageOrBuilderList();
                } else {
                    return java.util.Collections.unmodifiableList(filterNodes_);
                }
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNode.Builder addFilterNodesBuilder() {
                return getFilterNodesFieldBuilder().addBuilder(
                    PushDownPb.FilterNode.getDefaultInstance());
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public PushDownPb.FilterNode.Builder addFilterNodesBuilder(
                int index) {
                return getFilterNodesFieldBuilder().addBuilder(
                    index, PushDownPb.FilterNode.getDefaultInstance());
            }

            /**
             * <code>repeated .FilterNode filter_nodes = 2;</code>
             */
            public java.util.List<PushDownPb.FilterNode.Builder>
            getFilterNodesBuilderList() {
                return getFilterNodesFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder>
            getFilterNodesFieldBuilder() {
                if (filterNodesBuilder_ == null) {
                    filterNodesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                        PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder>(
                        filterNodes_,
                        ((bitField0_ & 0x00000002) != 0),
                        getParentForChildren(),
                        isClean());
                    filterNodes_ = null;
                }
                return filterNodesBuilder_;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:FilterNodes)
        }

        // @@protoc_insertion_point(class_scope:FilterNodes)
        private static final PushDownPb.FilterNodes DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.FilterNodes();
        }

        public static PushDownPb.FilterNodes getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<FilterNodes>
            PARSER = new com.google.protobuf.AbstractParser<FilterNodes>() {
            @java.lang.Override
            public FilterNodes parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new FilterNodes(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<FilterNodes> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<FilterNodes> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.FilterNodes getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface FilterNodeOrBuilder extends
        // @@protoc_insertion_point(interface_extends:FilterNode)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>.FilterType filter_type = 1;</code>
         */
        int getFilterTypeValue();

        /**
         * <code>.FilterType filter_type = 1;</code>
         */
        PushDownPb.FilterType getFilterType();

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        java.util.List<PushDownPb.FilterNode>
        getFiltersList();

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        PushDownPb.FilterNode getFilters(int index);

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        int getFiltersCount();

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        java.util.List<? extends PushDownPb.FilterNodeOrBuilder>
        getFiltersOrBuilderList();

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        PushDownPb.FilterNodeOrBuilder getFiltersOrBuilder(
            int index);

        /**
         * <code>.IntList int_content = 3;</code>
         */
        boolean hasIntContent();

        /**
         * <code>.IntList int_content = 3;</code>
         */
        PushDownPb.IntList getIntContent();

        /**
         * <code>.IntList int_content = 3;</code>
         */
        PushDownPb.IntListOrBuilder getIntContentOrBuilder();

        /**
         * <code>.LongList long_content = 4;</code>
         */
        boolean hasLongContent();

        /**
         * <code>.LongList long_content = 4;</code>
         */
        PushDownPb.LongList getLongContent();

        /**
         * <code>.LongList long_content = 4;</code>
         */
        PushDownPb.LongListOrBuilder getLongContentOrBuilder();

        /**
         * <code>.StringList str_content = 5;</code>
         */
        boolean hasStrContent();

        /**
         * <code>.StringList str_content = 5;</code>
         */
        PushDownPb.StringList getStrContent();

        /**
         * <code>.StringList str_content = 5;</code>
         */
        PushDownPb.StringListOrBuilder getStrContentOrBuilder();

        /**
         * <code>.BytesList bytes_content = 6;</code>
         */
        boolean hasBytesContent();

        /**
         * <code>.BytesList bytes_content = 6;</code>
         */
        PushDownPb.BytesList getBytesContent();

        /**
         * <code>.BytesList bytes_content = 6;</code>
         */
        PushDownPb.BytesListOrBuilder getBytesContentOrBuilder();

        public PushDownPb.FilterNode.ContentCase getContentCase();
    }

    /**
     * Protobuf type {@code FilterNode}
     */
    public static final class FilterNode extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:FilterNode)
        FilterNodeOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use FilterNode.newBuilder() to construct.
        private FilterNode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private FilterNode() {
            filterType_ = 0;
            filters_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new FilterNode();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private FilterNode(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 8: {
                            int rawValue = input.readEnum();

                            filterType_ = rawValue;
                            break;
                        }
                        case 18: {
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                filters_ = new java.util.ArrayList<PushDownPb.FilterNode>();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            filters_.add(
                                input.readMessage(PushDownPb.FilterNode.parser(), extensionRegistry));
                            break;
                        }
                        case 26: {
                            PushDownPb.IntList.Builder subBuilder = null;
                            if (contentCase_ == 3) {
                                subBuilder = ((PushDownPb.IntList) content_).toBuilder();
                            }
                            content_ =
                                input.readMessage(PushDownPb.IntList.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom((PushDownPb.IntList) content_);
                                content_ = subBuilder.buildPartial();
                            }
                            contentCase_ = 3;
                            break;
                        }
                        case 34: {
                            PushDownPb.LongList.Builder subBuilder = null;
                            if (contentCase_ == 4) {
                                subBuilder = ((PushDownPb.LongList) content_).toBuilder();
                            }
                            content_ =
                                input.readMessage(PushDownPb.LongList.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom((PushDownPb.LongList) content_);
                                content_ = subBuilder.buildPartial();
                            }
                            contentCase_ = 4;
                            break;
                        }
                        case 42: {
                            PushDownPb.StringList.Builder subBuilder = null;
                            if (contentCase_ == 5) {
                                subBuilder = ((PushDownPb.StringList) content_).toBuilder();
                            }
                            content_ =
                                input.readMessage(PushDownPb.StringList.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom((PushDownPb.StringList) content_);
                                content_ = subBuilder.buildPartial();
                            }
                            contentCase_ = 5;
                            break;
                        }
                        case 50: {
                            PushDownPb.BytesList.Builder subBuilder = null;
                            if (contentCase_ == 6) {
                                subBuilder = ((PushDownPb.BytesList) content_).toBuilder();
                            }
                            content_ =
                                input.readMessage(PushDownPb.BytesList.parser(), extensionRegistry);
                            if (subBuilder != null) {
                                subBuilder.mergeFrom((PushDownPb.BytesList) content_);
                                content_ = subBuilder.buildPartial();
                            }
                            contentCase_ = 6;
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    filters_ = java.util.Collections.unmodifiableList(filters_);
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_FilterNode_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_FilterNode_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.FilterNode.class, PushDownPb.FilterNode.Builder.class);
        }

        private int contentCase_ = 0;
        private java.lang.Object content_;

        public enum ContentCase
            implements com.google.protobuf.Internal.EnumLite {
            INT_CONTENT(3),
            LONG_CONTENT(4),
            STR_CONTENT(5),
            BYTES_CONTENT(6),
            CONTENT_NOT_SET(0);
            private final int value;

            private ContentCase(int value) {
                this.value = value;
            }

            /**
             * @deprecated Use {@link #forNumber(int)} instead.
             */
            @java.lang.Deprecated
            public static ContentCase valueOf(int value) {
                return forNumber(value);
            }

            public static ContentCase forNumber(int value) {
                switch (value) {
                    case 3:
                        return INT_CONTENT;
                    case 4:
                        return LONG_CONTENT;
                    case 5:
                        return STR_CONTENT;
                    case 6:
                        return BYTES_CONTENT;
                    case 0:
                        return CONTENT_NOT_SET;
                    default:
                        return null;
                }
            }

            public int getNumber() {
                return this.value;
            }
        }

        ;

        public ContentCase
        getContentCase() {
            return ContentCase.forNumber(
                contentCase_);
        }

        public static final int FILTER_TYPE_FIELD_NUMBER = 1;
        private int filterType_;

        /**
         * <code>.FilterType filter_type = 1;</code>
         */
        public int getFilterTypeValue() {
            return filterType_;
        }

        /**
         * <code>.FilterType filter_type = 1;</code>
         */
        public PushDownPb.FilterType getFilterType() {
            @SuppressWarnings("deprecation")
            PushDownPb.FilterType result = PushDownPb.FilterType.valueOf(filterType_);
            return result == null ? PushDownPb.FilterType.UNRECOGNIZED : result;
        }

        public static final int FILTERS_FIELD_NUMBER = 2;
        private java.util.List<PushDownPb.FilterNode> filters_;

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        public java.util.List<PushDownPb.FilterNode> getFiltersList() {
            return filters_;
        }

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        public java.util.List<? extends PushDownPb.FilterNodeOrBuilder>
        getFiltersOrBuilderList() {
            return filters_;
        }

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        public int getFiltersCount() {
            return filters_.size();
        }

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        public PushDownPb.FilterNode getFilters(int index) {
            return filters_.get(index);
        }

        /**
         * <code>repeated .FilterNode filters = 2;</code>
         */
        public PushDownPb.FilterNodeOrBuilder getFiltersOrBuilder(
            int index) {
            return filters_.get(index);
        }

        public static final int INT_CONTENT_FIELD_NUMBER = 3;

        /**
         * <code>.IntList int_content = 3;</code>
         */
        public boolean hasIntContent() {
            return contentCase_ == 3;
        }

        /**
         * <code>.IntList int_content = 3;</code>
         */
        public PushDownPb.IntList getIntContent() {
            if (contentCase_ == 3) {
                return (PushDownPb.IntList) content_;
            }
            return PushDownPb.IntList.getDefaultInstance();
        }

        /**
         * <code>.IntList int_content = 3;</code>
         */
        public PushDownPb.IntListOrBuilder getIntContentOrBuilder() {
            if (contentCase_ == 3) {
                return (PushDownPb.IntList) content_;
            }
            return PushDownPb.IntList.getDefaultInstance();
        }

        public static final int LONG_CONTENT_FIELD_NUMBER = 4;

        /**
         * <code>.LongList long_content = 4;</code>
         */
        public boolean hasLongContent() {
            return contentCase_ == 4;
        }

        /**
         * <code>.LongList long_content = 4;</code>
         */
        public PushDownPb.LongList getLongContent() {
            if (contentCase_ == 4) {
                return (PushDownPb.LongList) content_;
            }
            return PushDownPb.LongList.getDefaultInstance();
        }

        /**
         * <code>.LongList long_content = 4;</code>
         */
        public PushDownPb.LongListOrBuilder getLongContentOrBuilder() {
            if (contentCase_ == 4) {
                return (PushDownPb.LongList) content_;
            }
            return PushDownPb.LongList.getDefaultInstance();
        }

        public static final int STR_CONTENT_FIELD_NUMBER = 5;

        /**
         * <code>.StringList str_content = 5;</code>
         */
        public boolean hasStrContent() {
            return contentCase_ == 5;
        }

        /**
         * <code>.StringList str_content = 5;</code>
         */
        public PushDownPb.StringList getStrContent() {
            if (contentCase_ == 5) {
                return (PushDownPb.StringList) content_;
            }
            return PushDownPb.StringList.getDefaultInstance();
        }

        /**
         * <code>.StringList str_content = 5;</code>
         */
        public PushDownPb.StringListOrBuilder getStrContentOrBuilder() {
            if (contentCase_ == 5) {
                return (PushDownPb.StringList) content_;
            }
            return PushDownPb.StringList.getDefaultInstance();
        }

        public static final int BYTES_CONTENT_FIELD_NUMBER = 6;

        /**
         * <code>.BytesList bytes_content = 6;</code>
         */
        public boolean hasBytesContent() {
            return contentCase_ == 6;
        }

        /**
         * <code>.BytesList bytes_content = 6;</code>
         */
        public PushDownPb.BytesList getBytesContent() {
            if (contentCase_ == 6) {
                return (PushDownPb.BytesList) content_;
            }
            return PushDownPb.BytesList.getDefaultInstance();
        }

        /**
         * <code>.BytesList bytes_content = 6;</code>
         */
        public PushDownPb.BytesListOrBuilder getBytesContentOrBuilder() {
            if (contentCase_ == 6) {
                return (PushDownPb.BytesList) content_;
            }
            return PushDownPb.BytesList.getDefaultInstance();
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            if (filterType_ != PushDownPb.FilterType.EMPTY.getNumber()) {
                output.writeEnum(1, filterType_);
            }
            for (int i = 0; i < filters_.size(); i++) {
                output.writeMessage(2, filters_.get(i));
            }
            if (contentCase_ == 3) {
                output.writeMessage(3, (PushDownPb.IntList) content_);
            }
            if (contentCase_ == 4) {
                output.writeMessage(4, (PushDownPb.LongList) content_);
            }
            if (contentCase_ == 5) {
                output.writeMessage(5, (PushDownPb.StringList) content_);
            }
            if (contentCase_ == 6) {
                output.writeMessage(6, (PushDownPb.BytesList) content_);
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (filterType_ != PushDownPb.FilterType.EMPTY.getNumber()) {
                size += com.google.protobuf.CodedOutputStream
                    .computeEnumSize(1, filterType_);
            }
            for (int i = 0; i < filters_.size(); i++) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(2, filters_.get(i));
            }
            if (contentCase_ == 3) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(3, (PushDownPb.IntList) content_);
            }
            if (contentCase_ == 4) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(4, (PushDownPb.LongList) content_);
            }
            if (contentCase_ == 5) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(5, (PushDownPb.StringList) content_);
            }
            if (contentCase_ == 6) {
                size += com.google.protobuf.CodedOutputStream
                    .computeMessageSize(6, (PushDownPb.BytesList) content_);
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.FilterNode)) {
                return super.equals(obj);
            }
            PushDownPb.FilterNode other = (PushDownPb.FilterNode) obj;

            if (filterType_ != other.filterType_) return false;
            if (!getFiltersList()
                .equals(other.getFiltersList())) return false;
            if (!getContentCase().equals(other.getContentCase())) return false;
            switch (contentCase_) {
                case 3:
                    if (!getIntContent()
                        .equals(other.getIntContent())) return false;
                    break;
                case 4:
                    if (!getLongContent()
                        .equals(other.getLongContent())) return false;
                    break;
                case 5:
                    if (!getStrContent()
                        .equals(other.getStrContent())) return false;
                    break;
                case 6:
                    if (!getBytesContent()
                        .equals(other.getBytesContent())) return false;
                    break;
                case 0:
                default:
            }
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + FILTER_TYPE_FIELD_NUMBER;
            hash = (53 * hash) + filterType_;
            if (getFiltersCount() > 0) {
                hash = (37 * hash) + FILTERS_FIELD_NUMBER;
                hash = (53 * hash) + getFiltersList().hashCode();
            }
            switch (contentCase_) {
                case 3:
                    hash = (37 * hash) + INT_CONTENT_FIELD_NUMBER;
                    hash = (53 * hash) + getIntContent().hashCode();
                    break;
                case 4:
                    hash = (37 * hash) + LONG_CONTENT_FIELD_NUMBER;
                    hash = (53 * hash) + getLongContent().hashCode();
                    break;
                case 5:
                    hash = (37 * hash) + STR_CONTENT_FIELD_NUMBER;
                    hash = (53 * hash) + getStrContent().hashCode();
                    break;
                case 6:
                    hash = (37 * hash) + BYTES_CONTENT_FIELD_NUMBER;
                    hash = (53 * hash) + getBytesContent().hashCode();
                    break;
                case 0:
                default:
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.FilterNode parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.FilterNode parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.FilterNode parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.FilterNode parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.FilterNode parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.FilterNode parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.FilterNode parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.FilterNode parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.FilterNode parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.FilterNode parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.FilterNode parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.FilterNode parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.FilterNode prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code FilterNode}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:FilterNode)
            PushDownPb.FilterNodeOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_FilterNode_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_FilterNode_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.FilterNode.class, PushDownPb.FilterNode.Builder.class);
            }

            // Construct using PushDownPb.FilterNode.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
                if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
                    getFiltersFieldBuilder();
                }
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                filterType_ = 0;

                if (filtersBuilder_ == null) {
                    filters_ = java.util.Collections.emptyList();
                    bitField0_ = (bitField0_ & ~0x00000001);
                } else {
                    filtersBuilder_.clear();
                }
                contentCase_ = 0;
                content_ = null;
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_FilterNode_descriptor;
            }

            @java.lang.Override
            public PushDownPb.FilterNode getDefaultInstanceForType() {
                return PushDownPb.FilterNode.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.FilterNode build() {
                PushDownPb.FilterNode result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.FilterNode buildPartial() {
                PushDownPb.FilterNode result = new PushDownPb.FilterNode(this);
                result.filterType_ = filterType_;
                if (filtersBuilder_ == null) {
                    if (((bitField0_ & 0x00000001) != 0)) {
                        filters_ = java.util.Collections.unmodifiableList(filters_);
                        bitField0_ = (bitField0_ & ~0x00000001);
                    }
                    result.filters_ = filters_;
                } else {
                    result.filters_ = filtersBuilder_.build();
                }
                if (contentCase_ == 3) {
                    if (intContentBuilder_ == null) {
                        result.content_ = content_;
                    } else {
                        result.content_ = intContentBuilder_.build();
                    }
                }
                if (contentCase_ == 4) {
                    if (longContentBuilder_ == null) {
                        result.content_ = content_;
                    } else {
                        result.content_ = longContentBuilder_.build();
                    }
                }
                if (contentCase_ == 5) {
                    if (strContentBuilder_ == null) {
                        result.content_ = content_;
                    } else {
                        result.content_ = strContentBuilder_.build();
                    }
                }
                if (contentCase_ == 6) {
                    if (bytesContentBuilder_ == null) {
                        result.content_ = content_;
                    } else {
                        result.content_ = bytesContentBuilder_.build();
                    }
                }
                result.contentCase_ = contentCase_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.FilterNode) {
                    return mergeFrom((PushDownPb.FilterNode) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.FilterNode other) {
                if (other == PushDownPb.FilterNode.getDefaultInstance()) return this;
                if (other.filterType_ != 0) {
                    setFilterTypeValue(other.getFilterTypeValue());
                }
                if (filtersBuilder_ == null) {
                    if (!other.filters_.isEmpty()) {
                        if (filters_.isEmpty()) {
                            filters_ = other.filters_;
                            bitField0_ = (bitField0_ & ~0x00000001);
                        } else {
                            ensureFiltersIsMutable();
                            filters_.addAll(other.filters_);
                        }
                        onChanged();
                    }
                } else {
                    if (!other.filters_.isEmpty()) {
                        if (filtersBuilder_.isEmpty()) {
                            filtersBuilder_.dispose();
                            filtersBuilder_ = null;
                            filters_ = other.filters_;
                            bitField0_ = (bitField0_ & ~0x00000001);
                            filtersBuilder_ =
                                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                                    getFiltersFieldBuilder() : null;
                        } else {
                            filtersBuilder_.addAllMessages(other.filters_);
                        }
                    }
                }
                switch (other.getContentCase()) {
                    case INT_CONTENT: {
                        mergeIntContent(other.getIntContent());
                        break;
                    }
                    case LONG_CONTENT: {
                        mergeLongContent(other.getLongContent());
                        break;
                    }
                    case STR_CONTENT: {
                        mergeStrContent(other.getStrContent());
                        break;
                    }
                    case BYTES_CONTENT: {
                        mergeBytesContent(other.getBytesContent());
                        break;
                    }
                    case CONTENT_NOT_SET: {
                        break;
                    }
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.FilterNode parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.FilterNode) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int contentCase_ = 0;
            private java.lang.Object content_;

            public ContentCase
            getContentCase() {
                return ContentCase.forNumber(
                    contentCase_);
            }

            public Builder clearContent() {
                contentCase_ = 0;
                content_ = null;
                onChanged();
                return this;
            }

            private int bitField0_;

            private int filterType_ = 0;

            /**
             * <code>.FilterType filter_type = 1;</code>
             */
            public int getFilterTypeValue() {
                return filterType_;
            }

            /**
             * <code>.FilterType filter_type = 1;</code>
             */
            public Builder setFilterTypeValue(int value) {
                filterType_ = value;
                onChanged();
                return this;
            }

            /**
             * <code>.FilterType filter_type = 1;</code>
             */
            public PushDownPb.FilterType getFilterType() {
                @SuppressWarnings("deprecation")
                PushDownPb.FilterType result = PushDownPb.FilterType.valueOf(filterType_);
                return result == null ? PushDownPb.FilterType.UNRECOGNIZED : result;
            }

            /**
             * <code>.FilterType filter_type = 1;</code>
             */
            public Builder setFilterType(PushDownPb.FilterType value) {
                if (value == null) {
                    throw new NullPointerException();
                }

                filterType_ = value.getNumber();
                onChanged();
                return this;
            }

            /**
             * <code>.FilterType filter_type = 1;</code>
             */
            public Builder clearFilterType() {

                filterType_ = 0;
                onChanged();
                return this;
            }

            private java.util.List<PushDownPb.FilterNode> filters_ =
                java.util.Collections.emptyList();

            private void ensureFiltersIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    filters_ = new java.util.ArrayList<PushDownPb.FilterNode>(filters_);
                    bitField0_ |= 0x00000001;
                }
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder> filtersBuilder_;

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public java.util.List<PushDownPb.FilterNode> getFiltersList() {
                if (filtersBuilder_ == null) {
                    return java.util.Collections.unmodifiableList(filters_);
                } else {
                    return filtersBuilder_.getMessageList();
                }
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public int getFiltersCount() {
                if (filtersBuilder_ == null) {
                    return filters_.size();
                } else {
                    return filtersBuilder_.getCount();
                }
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public PushDownPb.FilterNode getFilters(int index) {
                if (filtersBuilder_ == null) {
                    return filters_.get(index);
                } else {
                    return filtersBuilder_.getMessage(index);
                }
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder setFilters(
                int index, PushDownPb.FilterNode value) {
                if (filtersBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    ensureFiltersIsMutable();
                    filters_.set(index, value);
                    onChanged();
                } else {
                    filtersBuilder_.setMessage(index, value);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder setFilters(
                int index, PushDownPb.FilterNode.Builder builderForValue) {
                if (filtersBuilder_ == null) {
                    ensureFiltersIsMutable();
                    filters_.set(index, builderForValue.build());
                    onChanged();
                } else {
                    filtersBuilder_.setMessage(index, builderForValue.build());
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder addFilters(PushDownPb.FilterNode value) {
                if (filtersBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    ensureFiltersIsMutable();
                    filters_.add(value);
                    onChanged();
                } else {
                    filtersBuilder_.addMessage(value);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder addFilters(
                int index, PushDownPb.FilterNode value) {
                if (filtersBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    ensureFiltersIsMutable();
                    filters_.add(index, value);
                    onChanged();
                } else {
                    filtersBuilder_.addMessage(index, value);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder addFilters(
                PushDownPb.FilterNode.Builder builderForValue) {
                if (filtersBuilder_ == null) {
                    ensureFiltersIsMutable();
                    filters_.add(builderForValue.build());
                    onChanged();
                } else {
                    filtersBuilder_.addMessage(builderForValue.build());
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder addFilters(
                int index, PushDownPb.FilterNode.Builder builderForValue) {
                if (filtersBuilder_ == null) {
                    ensureFiltersIsMutable();
                    filters_.add(index, builderForValue.build());
                    onChanged();
                } else {
                    filtersBuilder_.addMessage(index, builderForValue.build());
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder addAllFilters(
                java.lang.Iterable<? extends PushDownPb.FilterNode> values) {
                if (filtersBuilder_ == null) {
                    ensureFiltersIsMutable();
                    com.google.protobuf.AbstractMessageLite.Builder.addAll(
                        values, filters_);
                    onChanged();
                } else {
                    filtersBuilder_.addAllMessages(values);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder clearFilters() {
                if (filtersBuilder_ == null) {
                    filters_ = java.util.Collections.emptyList();
                    bitField0_ = (bitField0_ & ~0x00000001);
                    onChanged();
                } else {
                    filtersBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public Builder removeFilters(int index) {
                if (filtersBuilder_ == null) {
                    ensureFiltersIsMutable();
                    filters_.remove(index);
                    onChanged();
                } else {
                    filtersBuilder_.remove(index);
                }
                return this;
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public PushDownPb.FilterNode.Builder getFiltersBuilder(
                int index) {
                return getFiltersFieldBuilder().getBuilder(index);
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public PushDownPb.FilterNodeOrBuilder getFiltersOrBuilder(
                int index) {
                if (filtersBuilder_ == null) {
                    return filters_.get(index);
                } else {
                    return filtersBuilder_.getMessageOrBuilder(index);
                }
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public java.util.List<? extends PushDownPb.FilterNodeOrBuilder>
            getFiltersOrBuilderList() {
                if (filtersBuilder_ != null) {
                    return filtersBuilder_.getMessageOrBuilderList();
                } else {
                    return java.util.Collections.unmodifiableList(filters_);
                }
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public PushDownPb.FilterNode.Builder addFiltersBuilder() {
                return getFiltersFieldBuilder().addBuilder(
                    PushDownPb.FilterNode.getDefaultInstance());
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public PushDownPb.FilterNode.Builder addFiltersBuilder(
                int index) {
                return getFiltersFieldBuilder().addBuilder(
                    index, PushDownPb.FilterNode.getDefaultInstance());
            }

            /**
             * <code>repeated .FilterNode filters = 2;</code>
             */
            public java.util.List<PushDownPb.FilterNode.Builder>
            getFiltersBuilderList() {
                return getFiltersFieldBuilder().getBuilderList();
            }

            private com.google.protobuf.RepeatedFieldBuilderV3<
                PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder>
            getFiltersFieldBuilder() {
                if (filtersBuilder_ == null) {
                    filtersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                        PushDownPb.FilterNode, PushDownPb.FilterNode.Builder, PushDownPb.FilterNodeOrBuilder>(
                        filters_,
                        ((bitField0_ & 0x00000001) != 0),
                        getParentForChildren(),
                        isClean());
                    filters_ = null;
                }
                return filtersBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.IntList, PushDownPb.IntList.Builder, PushDownPb.IntListOrBuilder> intContentBuilder_;

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public boolean hasIntContent() {
                return contentCase_ == 3;
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public PushDownPb.IntList getIntContent() {
                if (intContentBuilder_ == null) {
                    if (contentCase_ == 3) {
                        return (PushDownPb.IntList) content_;
                    }
                    return PushDownPb.IntList.getDefaultInstance();
                } else {
                    if (contentCase_ == 3) {
                        return intContentBuilder_.getMessage();
                    }
                    return PushDownPb.IntList.getDefaultInstance();
                }
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public Builder setIntContent(PushDownPb.IntList value) {
                if (intContentBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    content_ = value;
                    onChanged();
                } else {
                    intContentBuilder_.setMessage(value);
                }
                contentCase_ = 3;
                return this;
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public Builder setIntContent(
                PushDownPb.IntList.Builder builderForValue) {
                if (intContentBuilder_ == null) {
                    content_ = builderForValue.build();
                    onChanged();
                } else {
                    intContentBuilder_.setMessage(builderForValue.build());
                }
                contentCase_ = 3;
                return this;
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public Builder mergeIntContent(PushDownPb.IntList value) {
                if (intContentBuilder_ == null) {
                    if (contentCase_ == 3 &&
                        content_ != PushDownPb.IntList.getDefaultInstance()) {
                        content_ = PushDownPb.IntList.newBuilder((PushDownPb.IntList) content_)
                            .mergeFrom(value).buildPartial();
                    } else {
                        content_ = value;
                    }
                    onChanged();
                } else {
                    if (contentCase_ == 3) {
                        intContentBuilder_.mergeFrom(value);
                    }
                    intContentBuilder_.setMessage(value);
                }
                contentCase_ = 3;
                return this;
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public Builder clearIntContent() {
                if (intContentBuilder_ == null) {
                    if (contentCase_ == 3) {
                        contentCase_ = 0;
                        content_ = null;
                        onChanged();
                    }
                } else {
                    if (contentCase_ == 3) {
                        contentCase_ = 0;
                        content_ = null;
                    }
                    intContentBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public PushDownPb.IntList.Builder getIntContentBuilder() {
                return getIntContentFieldBuilder().getBuilder();
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            public PushDownPb.IntListOrBuilder getIntContentOrBuilder() {
                if ((contentCase_ == 3) && (intContentBuilder_ != null)) {
                    return intContentBuilder_.getMessageOrBuilder();
                } else {
                    if (contentCase_ == 3) {
                        return (PushDownPb.IntList) content_;
                    }
                    return PushDownPb.IntList.getDefaultInstance();
                }
            }

            /**
             * <code>.IntList int_content = 3;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.IntList, PushDownPb.IntList.Builder, PushDownPb.IntListOrBuilder>
            getIntContentFieldBuilder() {
                if (intContentBuilder_ == null) {
                    if (!(contentCase_ == 3)) {
                        content_ = PushDownPb.IntList.getDefaultInstance();
                    }
                    intContentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.IntList, PushDownPb.IntList.Builder, PushDownPb.IntListOrBuilder>(
                        (PushDownPb.IntList) content_,
                        getParentForChildren(),
                        isClean());
                    content_ = null;
                }
                contentCase_ = 3;
                onChanged();
                return intContentBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.LongList, PushDownPb.LongList.Builder, PushDownPb.LongListOrBuilder> longContentBuilder_;

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public boolean hasLongContent() {
                return contentCase_ == 4;
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public PushDownPb.LongList getLongContent() {
                if (longContentBuilder_ == null) {
                    if (contentCase_ == 4) {
                        return (PushDownPb.LongList) content_;
                    }
                    return PushDownPb.LongList.getDefaultInstance();
                } else {
                    if (contentCase_ == 4) {
                        return longContentBuilder_.getMessage();
                    }
                    return PushDownPb.LongList.getDefaultInstance();
                }
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public Builder setLongContent(PushDownPb.LongList value) {
                if (longContentBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    content_ = value;
                    onChanged();
                } else {
                    longContentBuilder_.setMessage(value);
                }
                contentCase_ = 4;
                return this;
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public Builder setLongContent(
                PushDownPb.LongList.Builder builderForValue) {
                if (longContentBuilder_ == null) {
                    content_ = builderForValue.build();
                    onChanged();
                } else {
                    longContentBuilder_.setMessage(builderForValue.build());
                }
                contentCase_ = 4;
                return this;
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public Builder mergeLongContent(PushDownPb.LongList value) {
                if (longContentBuilder_ == null) {
                    if (contentCase_ == 4 &&
                        content_ != PushDownPb.LongList.getDefaultInstance()) {
                        content_ = PushDownPb.LongList.newBuilder((PushDownPb.LongList) content_)
                            .mergeFrom(value).buildPartial();
                    } else {
                        content_ = value;
                    }
                    onChanged();
                } else {
                    if (contentCase_ == 4) {
                        longContentBuilder_.mergeFrom(value);
                    }
                    longContentBuilder_.setMessage(value);
                }
                contentCase_ = 4;
                return this;
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public Builder clearLongContent() {
                if (longContentBuilder_ == null) {
                    if (contentCase_ == 4) {
                        contentCase_ = 0;
                        content_ = null;
                        onChanged();
                    }
                } else {
                    if (contentCase_ == 4) {
                        contentCase_ = 0;
                        content_ = null;
                    }
                    longContentBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public PushDownPb.LongList.Builder getLongContentBuilder() {
                return getLongContentFieldBuilder().getBuilder();
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            public PushDownPb.LongListOrBuilder getLongContentOrBuilder() {
                if ((contentCase_ == 4) && (longContentBuilder_ != null)) {
                    return longContentBuilder_.getMessageOrBuilder();
                } else {
                    if (contentCase_ == 4) {
                        return (PushDownPb.LongList) content_;
                    }
                    return PushDownPb.LongList.getDefaultInstance();
                }
            }

            /**
             * <code>.LongList long_content = 4;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.LongList, PushDownPb.LongList.Builder, PushDownPb.LongListOrBuilder>
            getLongContentFieldBuilder() {
                if (longContentBuilder_ == null) {
                    if (!(contentCase_ == 4)) {
                        content_ = PushDownPb.LongList.getDefaultInstance();
                    }
                    longContentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.LongList, PushDownPb.LongList.Builder, PushDownPb.LongListOrBuilder>(
                        (PushDownPb.LongList) content_,
                        getParentForChildren(),
                        isClean());
                    content_ = null;
                }
                contentCase_ = 4;
                onChanged();
                return longContentBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.StringList, PushDownPb.StringList.Builder, PushDownPb.StringListOrBuilder> strContentBuilder_;

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public boolean hasStrContent() {
                return contentCase_ == 5;
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public PushDownPb.StringList getStrContent() {
                if (strContentBuilder_ == null) {
                    if (contentCase_ == 5) {
                        return (PushDownPb.StringList) content_;
                    }
                    return PushDownPb.StringList.getDefaultInstance();
                } else {
                    if (contentCase_ == 5) {
                        return strContentBuilder_.getMessage();
                    }
                    return PushDownPb.StringList.getDefaultInstance();
                }
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public Builder setStrContent(PushDownPb.StringList value) {
                if (strContentBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    content_ = value;
                    onChanged();
                } else {
                    strContentBuilder_.setMessage(value);
                }
                contentCase_ = 5;
                return this;
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public Builder setStrContent(
                PushDownPb.StringList.Builder builderForValue) {
                if (strContentBuilder_ == null) {
                    content_ = builderForValue.build();
                    onChanged();
                } else {
                    strContentBuilder_.setMessage(builderForValue.build());
                }
                contentCase_ = 5;
                return this;
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public Builder mergeStrContent(PushDownPb.StringList value) {
                if (strContentBuilder_ == null) {
                    if (contentCase_ == 5 &&
                        content_ != PushDownPb.StringList.getDefaultInstance()) {
                        content_ = PushDownPb.StringList.newBuilder((PushDownPb.StringList) content_)
                            .mergeFrom(value).buildPartial();
                    } else {
                        content_ = value;
                    }
                    onChanged();
                } else {
                    if (contentCase_ == 5) {
                        strContentBuilder_.mergeFrom(value);
                    }
                    strContentBuilder_.setMessage(value);
                }
                contentCase_ = 5;
                return this;
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public Builder clearStrContent() {
                if (strContentBuilder_ == null) {
                    if (contentCase_ == 5) {
                        contentCase_ = 0;
                        content_ = null;
                        onChanged();
                    }
                } else {
                    if (contentCase_ == 5) {
                        contentCase_ = 0;
                        content_ = null;
                    }
                    strContentBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public PushDownPb.StringList.Builder getStrContentBuilder() {
                return getStrContentFieldBuilder().getBuilder();
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            public PushDownPb.StringListOrBuilder getStrContentOrBuilder() {
                if ((contentCase_ == 5) && (strContentBuilder_ != null)) {
                    return strContentBuilder_.getMessageOrBuilder();
                } else {
                    if (contentCase_ == 5) {
                        return (PushDownPb.StringList) content_;
                    }
                    return PushDownPb.StringList.getDefaultInstance();
                }
            }

            /**
             * <code>.StringList str_content = 5;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.StringList, PushDownPb.StringList.Builder, PushDownPb.StringListOrBuilder>
            getStrContentFieldBuilder() {
                if (strContentBuilder_ == null) {
                    if (!(contentCase_ == 5)) {
                        content_ = PushDownPb.StringList.getDefaultInstance();
                    }
                    strContentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.StringList, PushDownPb.StringList.Builder, PushDownPb.StringListOrBuilder>(
                        (PushDownPb.StringList) content_,
                        getParentForChildren(),
                        isClean());
                    content_ = null;
                }
                contentCase_ = 5;
                onChanged();
                return strContentBuilder_;
            }

            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.BytesList, PushDownPb.BytesList.Builder, PushDownPb.BytesListOrBuilder> bytesContentBuilder_;

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public boolean hasBytesContent() {
                return contentCase_ == 6;
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public PushDownPb.BytesList getBytesContent() {
                if (bytesContentBuilder_ == null) {
                    if (contentCase_ == 6) {
                        return (PushDownPb.BytesList) content_;
                    }
                    return PushDownPb.BytesList.getDefaultInstance();
                } else {
                    if (contentCase_ == 6) {
                        return bytesContentBuilder_.getMessage();
                    }
                    return PushDownPb.BytesList.getDefaultInstance();
                }
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public Builder setBytesContent(PushDownPb.BytesList value) {
                if (bytesContentBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    content_ = value;
                    onChanged();
                } else {
                    bytesContentBuilder_.setMessage(value);
                }
                contentCase_ = 6;
                return this;
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public Builder setBytesContent(
                PushDownPb.BytesList.Builder builderForValue) {
                if (bytesContentBuilder_ == null) {
                    content_ = builderForValue.build();
                    onChanged();
                } else {
                    bytesContentBuilder_.setMessage(builderForValue.build());
                }
                contentCase_ = 6;
                return this;
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public Builder mergeBytesContent(PushDownPb.BytesList value) {
                if (bytesContentBuilder_ == null) {
                    if (contentCase_ == 6 &&
                        content_ != PushDownPb.BytesList.getDefaultInstance()) {
                        content_ = PushDownPb.BytesList.newBuilder((PushDownPb.BytesList) content_)
                            .mergeFrom(value).buildPartial();
                    } else {
                        content_ = value;
                    }
                    onChanged();
                } else {
                    if (contentCase_ == 6) {
                        bytesContentBuilder_.mergeFrom(value);
                    }
                    bytesContentBuilder_.setMessage(value);
                }
                contentCase_ = 6;
                return this;
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public Builder clearBytesContent() {
                if (bytesContentBuilder_ == null) {
                    if (contentCase_ == 6) {
                        contentCase_ = 0;
                        content_ = null;
                        onChanged();
                    }
                } else {
                    if (contentCase_ == 6) {
                        contentCase_ = 0;
                        content_ = null;
                    }
                    bytesContentBuilder_.clear();
                }
                return this;
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public PushDownPb.BytesList.Builder getBytesContentBuilder() {
                return getBytesContentFieldBuilder().getBuilder();
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            public PushDownPb.BytesListOrBuilder getBytesContentOrBuilder() {
                if ((contentCase_ == 6) && (bytesContentBuilder_ != null)) {
                    return bytesContentBuilder_.getMessageOrBuilder();
                } else {
                    if (contentCase_ == 6) {
                        return (PushDownPb.BytesList) content_;
                    }
                    return PushDownPb.BytesList.getDefaultInstance();
                }
            }

            /**
             * <code>.BytesList bytes_content = 6;</code>
             */
            private com.google.protobuf.SingleFieldBuilderV3<
                PushDownPb.BytesList, PushDownPb.BytesList.Builder, PushDownPb.BytesListOrBuilder>
            getBytesContentFieldBuilder() {
                if (bytesContentBuilder_ == null) {
                    if (!(contentCase_ == 6)) {
                        content_ = PushDownPb.BytesList.getDefaultInstance();
                    }
                    bytesContentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                        PushDownPb.BytesList, PushDownPb.BytesList.Builder, PushDownPb.BytesListOrBuilder>(
                        (PushDownPb.BytesList) content_,
                        getParentForChildren(),
                        isClean());
                    content_ = null;
                }
                contentCase_ = 6;
                onChanged();
                return bytesContentBuilder_;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:FilterNode)
        }

        // @@protoc_insertion_point(class_scope:FilterNode)
        private static final PushDownPb.FilterNode DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.FilterNode();
        }

        public static PushDownPb.FilterNode getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<FilterNode>
            PARSER = new com.google.protobuf.AbstractParser<FilterNode>() {
            @java.lang.Override
            public FilterNode parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new FilterNode(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<FilterNode> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<FilterNode> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.FilterNode getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface IntListOrBuilder extends
        // @@protoc_insertion_point(interface_extends:IntList)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>repeated int32 int = 1;</code>
         */
        java.util.List<java.lang.Integer> getIntList();

        /**
         * <code>repeated int32 int = 1;</code>
         */
        int getIntCount();

        /**
         * <code>repeated int32 int = 1;</code>
         */
        int getInt(int index);
    }

    /**
     * Protobuf type {@code IntList}
     */
    public static final class IntList extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:IntList)
        IntListOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use IntList.newBuilder() to construct.
        private IntList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private IntList() {
            int_ = emptyIntList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new IntList();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private IntList(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 8: {
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                int_ = newIntList();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            int_.addInt(input.readInt32());
                            break;
                        }
                        case 10: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                                int_ = newIntList();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            while (input.getBytesUntilLimit() > 0) {
                                int_.addInt(input.readInt32());
                            }
                            input.popLimit(limit);
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    int_.makeImmutable(); // C
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_IntList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_IntList_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.IntList.class, PushDownPb.IntList.Builder.class);
        }

        public static final int INT_FIELD_NUMBER = 1;
        private com.google.protobuf.Internal.IntList int_;

        /**
         * <code>repeated int32 int = 1;</code>
         */
        public java.util.List<java.lang.Integer>
        getIntList() {
            return int_;
        }

        /**
         * <code>repeated int32 int = 1;</code>
         */
        public int getIntCount() {
            return int_.size();
        }

        /**
         * <code>repeated int32 int = 1;</code>
         */
        public int getInt(int index) {
            return int_.getInt(index);
        }

        private int intMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            getSerializedSize();
            if (getIntList().size() > 0) {
                output.writeUInt32NoTag(10);
                output.writeUInt32NoTag(intMemoizedSerializedSize);
            }
            for (int i = 0; i < int_.size(); i++) {
                output.writeInt32NoTag(int_.getInt(i));
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
                int dataSize = 0;
                for (int i = 0; i < int_.size(); i++) {
                    dataSize += com.google.protobuf.CodedOutputStream
                        .computeInt32SizeNoTag(int_.getInt(i));
                }
                size += dataSize;
                if (!getIntList().isEmpty()) {
                    size += 1;
                    size += com.google.protobuf.CodedOutputStream
                        .computeInt32SizeNoTag(dataSize);
                }
                intMemoizedSerializedSize = dataSize;
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.IntList)) {
                return super.equals(obj);
            }
            PushDownPb.IntList other = (PushDownPb.IntList) obj;

            if (!getIntList()
                .equals(other.getIntList())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getIntCount() > 0) {
                hash = (37 * hash) + INT_FIELD_NUMBER;
                hash = (53 * hash) + getIntList().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.IntList parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.IntList parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.IntList parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.IntList parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.IntList parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.IntList parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.IntList parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.IntList parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.IntList parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.IntList parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.IntList parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.IntList parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.IntList prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code IntList}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:IntList)
            PushDownPb.IntListOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_IntList_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_IntList_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.IntList.class, PushDownPb.IntList.Builder.class);
            }

            // Construct using PushDownPb.IntList.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                int_ = emptyIntList();
                bitField0_ = (bitField0_ & ~0x00000001);
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_IntList_descriptor;
            }

            @java.lang.Override
            public PushDownPb.IntList getDefaultInstanceForType() {
                return PushDownPb.IntList.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.IntList build() {
                PushDownPb.IntList result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.IntList buildPartial() {
                PushDownPb.IntList result = new PushDownPb.IntList(this);
                if (((bitField0_ & 0x00000001) != 0)) {
                    int_.makeImmutable();
                    bitField0_ = (bitField0_ & ~0x00000001);
                }
                result.int_ = int_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.IntList) {
                    return mergeFrom((PushDownPb.IntList) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.IntList other) {
                if (other == PushDownPb.IntList.getDefaultInstance()) return this;
                if (!other.int_.isEmpty()) {
                    if (int_.isEmpty()) {
                        int_ = other.int_;
                        bitField0_ = (bitField0_ & ~0x00000001);
                    } else {
                        ensureIntIsMutable();
                        int_.addAll(other.int_);
                    }
                    onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.IntList parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.IntList) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int bitField0_;

            private com.google.protobuf.Internal.IntList int_ = emptyIntList();

            private void ensureIntIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    int_ = mutableCopy(int_);
                    bitField0_ |= 0x00000001;
                }
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public java.util.List<java.lang.Integer>
            getIntList() {
                return ((bitField0_ & 0x00000001) != 0) ?
                    java.util.Collections.unmodifiableList(int_) : int_;
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public int getIntCount() {
                return int_.size();
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public int getInt(int index) {
                return int_.getInt(index);
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public Builder setInt(
                int index, int value) {
                ensureIntIsMutable();
                int_.setInt(index, value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public Builder addInt(int value) {
                ensureIntIsMutable();
                int_.addInt(value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public Builder addAllInt(
                java.lang.Iterable<? extends java.lang.Integer> values) {
                ensureIntIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                    values, int_);
                onChanged();
                return this;
            }

            /**
             * <code>repeated int32 int = 1;</code>
             */
            public Builder clearInt() {
                int_ = emptyIntList();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:IntList)
        }

        // @@protoc_insertion_point(class_scope:IntList)
        private static final PushDownPb.IntList DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.IntList();
        }

        public static PushDownPb.IntList getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<IntList>
            PARSER = new com.google.protobuf.AbstractParser<IntList>() {
            @java.lang.Override
            public IntList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new IntList(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<IntList> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<IntList> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.IntList getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface LongListOrBuilder extends
        // @@protoc_insertion_point(interface_extends:LongList)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>repeated int64 long = 1;</code>
         */
        java.util.List<java.lang.Long> getLongList();

        /**
         * <code>repeated int64 long = 1;</code>
         */
        int getLongCount();

        /**
         * <code>repeated int64 long = 1;</code>
         */
        long getLong(int index);
    }

    /**
     * Protobuf type {@code LongList}
     */
    public static final class LongList extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:LongList)
        LongListOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use LongList.newBuilder() to construct.
        private LongList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private LongList() {
            long_ = emptyLongList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new LongList();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private LongList(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 8: {
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                long_ = newLongList();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            long_.addLong(input.readInt64());
                            break;
                        }
                        case 10: {
                            int length = input.readRawVarint32();
                            int limit = input.pushLimit(length);
                            if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                                long_ = newLongList();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            while (input.getBytesUntilLimit() > 0) {
                                long_.addLong(input.readInt64());
                            }
                            input.popLimit(limit);
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    long_.makeImmutable(); // C
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_LongList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_LongList_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.LongList.class, PushDownPb.LongList.Builder.class);
        }

        public static final int LONG_FIELD_NUMBER = 1;
        private com.google.protobuf.Internal.LongList long_;

        /**
         * <code>repeated int64 long = 1;</code>
         */
        public java.util.List<java.lang.Long>
        getLongList() {
            return long_;
        }

        /**
         * <code>repeated int64 long = 1;</code>
         */
        public int getLongCount() {
            return long_.size();
        }

        /**
         * <code>repeated int64 long = 1;</code>
         */
        public long getLong(int index) {
            return long_.getLong(index);
        }

        private int longMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            getSerializedSize();
            if (getLongList().size() > 0) {
                output.writeUInt32NoTag(10);
                output.writeUInt32NoTag(longMemoizedSerializedSize);
            }
            for (int i = 0; i < long_.size(); i++) {
                output.writeInt64NoTag(long_.getLong(i));
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
                int dataSize = 0;
                for (int i = 0; i < long_.size(); i++) {
                    dataSize += com.google.protobuf.CodedOutputStream
                        .computeInt64SizeNoTag(long_.getLong(i));
                }
                size += dataSize;
                if (!getLongList().isEmpty()) {
                    size += 1;
                    size += com.google.protobuf.CodedOutputStream
                        .computeInt32SizeNoTag(dataSize);
                }
                longMemoizedSerializedSize = dataSize;
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.LongList)) {
                return super.equals(obj);
            }
            PushDownPb.LongList other = (PushDownPb.LongList) obj;

            if (!getLongList()
                .equals(other.getLongList())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getLongCount() > 0) {
                hash = (37 * hash) + LONG_FIELD_NUMBER;
                hash = (53 * hash) + getLongList().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.LongList parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.LongList parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.LongList parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.LongList parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.LongList parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.LongList parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.LongList parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.LongList parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.LongList parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.LongList parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.LongList parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.LongList parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.LongList prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code LongList}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:LongList)
            PushDownPb.LongListOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_LongList_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_LongList_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.LongList.class, PushDownPb.LongList.Builder.class);
            }

            // Construct using PushDownPb.LongList.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                long_ = emptyLongList();
                bitField0_ = (bitField0_ & ~0x00000001);
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_LongList_descriptor;
            }

            @java.lang.Override
            public PushDownPb.LongList getDefaultInstanceForType() {
                return PushDownPb.LongList.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.LongList build() {
                PushDownPb.LongList result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.LongList buildPartial() {
                PushDownPb.LongList result = new PushDownPb.LongList(this);
                if (((bitField0_ & 0x00000001) != 0)) {
                    long_.makeImmutable();
                    bitField0_ = (bitField0_ & ~0x00000001);
                }
                result.long_ = long_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.LongList) {
                    return mergeFrom((PushDownPb.LongList) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.LongList other) {
                if (other == PushDownPb.LongList.getDefaultInstance()) return this;
                if (!other.long_.isEmpty()) {
                    if (long_.isEmpty()) {
                        long_ = other.long_;
                        bitField0_ = (bitField0_ & ~0x00000001);
                    } else {
                        ensureLongIsMutable();
                        long_.addAll(other.long_);
                    }
                    onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.LongList parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.LongList) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int bitField0_;

            private com.google.protobuf.Internal.LongList long_ = emptyLongList();

            private void ensureLongIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    long_ = mutableCopy(long_);
                    bitField0_ |= 0x00000001;
                }
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public java.util.List<java.lang.Long>
            getLongList() {
                return ((bitField0_ & 0x00000001) != 0) ?
                    java.util.Collections.unmodifiableList(long_) : long_;
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public int getLongCount() {
                return long_.size();
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public long getLong(int index) {
                return long_.getLong(index);
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public Builder setLong(
                int index, long value) {
                ensureLongIsMutable();
                long_.setLong(index, value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public Builder addLong(long value) {
                ensureLongIsMutable();
                long_.addLong(value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public Builder addAllLong(
                java.lang.Iterable<? extends java.lang.Long> values) {
                ensureLongIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                    values, long_);
                onChanged();
                return this;
            }

            /**
             * <code>repeated int64 long = 1;</code>
             */
            public Builder clearLong() {
                long_ = emptyLongList();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:LongList)
        }

        // @@protoc_insertion_point(class_scope:LongList)
        private static final PushDownPb.LongList DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.LongList();
        }

        public static PushDownPb.LongList getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<LongList>
            PARSER = new com.google.protobuf.AbstractParser<LongList>() {
            @java.lang.Override
            public LongList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new LongList(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<LongList> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<LongList> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.LongList getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface StringListOrBuilder extends
        // @@protoc_insertion_point(interface_extends:StringList)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>repeated string str = 1;</code>
         */
        java.util.List<java.lang.String>
        getStrList();

        /**
         * <code>repeated string str = 1;</code>
         */
        int getStrCount();

        /**
         * <code>repeated string str = 1;</code>
         */
        java.lang.String getStr(int index);

        /**
         * <code>repeated string str = 1;</code>
         */
        com.google.protobuf.ByteString
        getStrBytes(int index);
    }

    /**
     * Protobuf type {@code StringList}
     */
    public static final class StringList extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:StringList)
        StringListOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use StringList.newBuilder() to construct.
        private StringList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private StringList() {
            str_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new StringList();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private StringList(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 10: {
                            java.lang.String s = input.readStringRequireUtf8();
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                str_ = new com.google.protobuf.LazyStringArrayList();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            str_.add(s);
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    str_ = str_.getUnmodifiableView();
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_StringList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_StringList_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.StringList.class, PushDownPb.StringList.Builder.class);
        }

        public static final int STR_FIELD_NUMBER = 1;
        private com.google.protobuf.LazyStringList str_;

        /**
         * <code>repeated string str = 1;</code>
         */
        public com.google.protobuf.ProtocolStringList
        getStrList() {
            return str_;
        }

        /**
         * <code>repeated string str = 1;</code>
         */
        public int getStrCount() {
            return str_.size();
        }

        /**
         * <code>repeated string str = 1;</code>
         */
        public java.lang.String getStr(int index) {
            return str_.get(index);
        }

        /**
         * <code>repeated string str = 1;</code>
         */
        public com.google.protobuf.ByteString
        getStrBytes(int index) {
            return str_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            for (int i = 0; i < str_.size(); i++) {
                com.google.protobuf.GeneratedMessageV3.writeString(output, 1, str_.getRaw(i));
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
                int dataSize = 0;
                for (int i = 0; i < str_.size(); i++) {
                    dataSize += computeStringSizeNoTag(str_.getRaw(i));
                }
                size += dataSize;
                size += 1 * getStrList().size();
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.StringList)) {
                return super.equals(obj);
            }
            PushDownPb.StringList other = (PushDownPb.StringList) obj;

            if (!getStrList()
                .equals(other.getStrList())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getStrCount() > 0) {
                hash = (37 * hash) + STR_FIELD_NUMBER;
                hash = (53 * hash) + getStrList().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.StringList parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.StringList parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.StringList parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.StringList parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.StringList parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.StringList parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.StringList parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.StringList parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.StringList parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.StringList parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.StringList parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.StringList parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.StringList prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code StringList}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:StringList)
            PushDownPb.StringListOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_StringList_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_StringList_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.StringList.class, PushDownPb.StringList.Builder.class);
            }

            // Construct using PushDownPb.StringList.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                str_ = com.google.protobuf.LazyStringArrayList.EMPTY;
                bitField0_ = (bitField0_ & ~0x00000001);
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_StringList_descriptor;
            }

            @java.lang.Override
            public PushDownPb.StringList getDefaultInstanceForType() {
                return PushDownPb.StringList.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.StringList build() {
                PushDownPb.StringList result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.StringList buildPartial() {
                PushDownPb.StringList result = new PushDownPb.StringList(this);
                if (((bitField0_ & 0x00000001) != 0)) {
                    str_ = str_.getUnmodifiableView();
                    bitField0_ = (bitField0_ & ~0x00000001);
                }
                result.str_ = str_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.StringList) {
                    return mergeFrom((PushDownPb.StringList) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.StringList other) {
                if (other == PushDownPb.StringList.getDefaultInstance()) return this;
                if (!other.str_.isEmpty()) {
                    if (str_.isEmpty()) {
                        str_ = other.str_;
                        bitField0_ = (bitField0_ & ~0x00000001);
                    } else {
                        ensureStrIsMutable();
                        str_.addAll(other.str_);
                    }
                    onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.StringList parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.StringList) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int bitField0_;

            private com.google.protobuf.LazyStringList str_ = com.google.protobuf.LazyStringArrayList.EMPTY;

            private void ensureStrIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    str_ = new com.google.protobuf.LazyStringArrayList(str_);
                    bitField0_ |= 0x00000001;
                }
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public com.google.protobuf.ProtocolStringList
            getStrList() {
                return str_.getUnmodifiableView();
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public int getStrCount() {
                return str_.size();
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public java.lang.String getStr(int index) {
                return str_.get(index);
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public com.google.protobuf.ByteString
            getStrBytes(int index) {
                return str_.getByteString(index);
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public Builder setStr(
                int index, java.lang.String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureStrIsMutable();
                str_.set(index, value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public Builder addStr(
                java.lang.String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureStrIsMutable();
                str_.add(value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public Builder addAllStr(
                java.lang.Iterable<java.lang.String> values) {
                ensureStrIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                    values, str_);
                onChanged();
                return this;
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public Builder clearStr() {
                str_ = com.google.protobuf.LazyStringArrayList.EMPTY;
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }

            /**
             * <code>repeated string str = 1;</code>
             */
            public Builder addStrBytes(
                com.google.protobuf.ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                checkByteStringIsUtf8(value);
                ensureStrIsMutable();
                str_.add(value);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:StringList)
        }

        // @@protoc_insertion_point(class_scope:StringList)
        private static final PushDownPb.StringList DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.StringList();
        }

        public static PushDownPb.StringList getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<StringList>
            PARSER = new com.google.protobuf.AbstractParser<StringList>() {
            @java.lang.Override
            public StringList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new StringList(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<StringList> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<StringList> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.StringList getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    public interface BytesListOrBuilder extends
        // @@protoc_insertion_point(interface_extends:BytesList)
        com.google.protobuf.MessageOrBuilder {

        /**
         * <code>repeated bytes bytes = 1;</code>
         */
        java.util.List<com.google.protobuf.ByteString> getBytesList();

        /**
         * <code>repeated bytes bytes = 1;</code>
         */
        int getBytesCount();

        /**
         * <code>repeated bytes bytes = 1;</code>
         */
        com.google.protobuf.ByteString getBytes(int index);
    }

    /**
     * Protobuf type {@code BytesList}
     */
    public static final class BytesList extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:BytesList)
        BytesListOrBuilder {
        private static final long serialVersionUID = 0L;

        // Use BytesList.newBuilder() to construct.
        private BytesList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BytesList() {
            bytes_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(
            UnusedPrivateParameter unused) {
            return new BytesList();
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
            return this.unknownFields;
        }

        private BytesList(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            this();
            if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
            }
            int mutable_bitField0_ = 0;
            com.google.protobuf.UnknownFieldSet.Builder unknownFields =
                com.google.protobuf.UnknownFieldSet.newBuilder();
            try {
                boolean done = false;
                while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0:
                            done = true;
                            break;
                        case 10: {
                            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                                bytes_ = new java.util.ArrayList<com.google.protobuf.ByteString>();
                                mutable_bitField0_ |= 0x00000001;
                            }
                            bytes_.add(input.readBytes());
                            break;
                        }
                        default: {
                            if (!parseUnknownField(
                                input, unknownFields, extensionRegistry, tag)) {
                                done = true;
                            }
                            break;
                        }
                    }
                }
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(this);
            } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(
                    e).setUnfinishedMessage(this);
            } finally {
                if (((mutable_bitField0_ & 0x00000001) != 0)) {
                    bytes_ = java.util.Collections.unmodifiableList(bytes_); // C
                }
                this.unknownFields = unknownFields.build();
                makeExtensionsImmutable();
            }
        }

        public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
            return PushDownPb.internal_static_BytesList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
            return PushDownPb.internal_static_BytesList_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    PushDownPb.BytesList.class, PushDownPb.BytesList.Builder.class);
        }

        public static final int BYTES_FIELD_NUMBER = 1;
        private java.util.List<com.google.protobuf.ByteString> bytes_;

        /**
         * <code>repeated bytes bytes = 1;</code>
         */
        public java.util.List<com.google.protobuf.ByteString>
        getBytesList() {
            return bytes_;
        }

        /**
         * <code>repeated bytes bytes = 1;</code>
         */
        public int getBytesCount() {
            return bytes_.size();
        }

        /**
         * <code>repeated bytes bytes = 1;</code>
         */
        public com.google.protobuf.ByteString getBytes(int index) {
            return bytes_.get(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
            for (int i = 0; i < bytes_.size(); i++) {
                output.writeBytes(1, bytes_.get(i));
            }
            unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            {
                int dataSize = 0;
                for (int i = 0; i < bytes_.size(); i++) {
                    dataSize += com.google.protobuf.CodedOutputStream
                        .computeBytesSizeNoTag(bytes_.get(i));
                }
                size += dataSize;
                size += 1 * getBytesList().size();
            }
            size += unknownFields.getSerializedSize();
            memoizedSize = size;
            return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PushDownPb.BytesList)) {
                return super.equals(obj);
            }
            PushDownPb.BytesList other = (PushDownPb.BytesList) obj;

            if (!getBytesList()
                .equals(other.getBytesList())) return false;
            if (!unknownFields.equals(other.unknownFields)) return false;
            return true;
        }

        @java.lang.Override
        public int hashCode() {
            if (memoizedHashCode != 0) {
                return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            if (getBytesCount() > 0) {
                hash = (37 * hash) + BYTES_FIELD_NUMBER;
                hash = (53 * hash) + getBytesList().hashCode();
            }
            hash = (29 * hash) + unknownFields.hashCode();
            memoizedHashCode = hash;
            return hash;
        }

        public static PushDownPb.BytesList parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.BytesList parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.BytesList parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.BytesList parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.BytesList parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static PushDownPb.BytesList parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static PushDownPb.BytesList parseFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.BytesList parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.BytesList parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input);
        }

        public static PushDownPb.BytesList parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static PushDownPb.BytesList parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input);
        }

        public static PushDownPb.BytesList parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3
                .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
            return newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PushDownPb.BytesList prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE
                ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        /**
         * Protobuf type {@code BytesList}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
            // @@protoc_insertion_point(builder_implements:BytesList)
            PushDownPb.BytesListOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
                return PushDownPb.internal_static_BytesList_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
                return PushDownPb.internal_static_BytesList_fieldAccessorTable
                    .ensureFieldAccessorsInitialized(
                        PushDownPb.BytesList.class, PushDownPb.BytesList.Builder.class);
            }

            // Construct using PushDownPb.BytesList.newBuilder()
            private Builder() {
                maybeForceBuilderInitialization();
            }

            private Builder(
                com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
                super(parent);
                maybeForceBuilderInitialization();
            }

            private void maybeForceBuilderInitialization() {
            }

            @java.lang.Override
            public Builder clear() {
                super.clear();
                bytes_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);
                return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
                return PushDownPb.internal_static_BytesList_descriptor;
            }

            @java.lang.Override
            public PushDownPb.BytesList getDefaultInstanceForType() {
                return PushDownPb.BytesList.getDefaultInstance();
            }

            @java.lang.Override
            public PushDownPb.BytesList build() {
                PushDownPb.BytesList result = buildPartial();
                if (!result.isInitialized()) {
                    throw newUninitializedMessageException(result);
                }
                return result;
            }

            @java.lang.Override
            public PushDownPb.BytesList buildPartial() {
                PushDownPb.BytesList result = new PushDownPb.BytesList(this);
                if (((bitField0_ & 0x00000001) != 0)) {
                    bytes_ = java.util.Collections.unmodifiableList(bytes_);
                    bitField0_ = (bitField0_ & ~0x00000001);
                }
                result.bytes_ = bytes_;
                onBuilt();
                return result;
            }

            @java.lang.Override
            public Builder clone() {
                return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(
                com.google.protobuf.Descriptors.FieldDescriptor field) {
                return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(
                com.google.protobuf.Descriptors.OneofDescriptor oneof) {
                return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index, java.lang.Object value) {
                return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                java.lang.Object value) {
                return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
                if (other instanceof PushDownPb.BytesList) {
                    return mergeFrom((PushDownPb.BytesList) other);
                } else {
                    super.mergeFrom(other);
                    return this;
                }
            }

            public Builder mergeFrom(PushDownPb.BytesList other) {
                if (other == PushDownPb.BytesList.getDefaultInstance()) return this;
                if (!other.bytes_.isEmpty()) {
                    if (bytes_.isEmpty()) {
                        bytes_ = other.bytes_;
                        bitField0_ = (bitField0_ & ~0x00000001);
                    } else {
                        ensureBytesIsMutable();
                        bytes_.addAll(other.bytes_);
                    }
                    onChanged();
                }
                this.mergeUnknownFields(other.unknownFields);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
                return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
                PushDownPb.BytesList parsedMessage = null;
                try {
                    parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    parsedMessage = (PushDownPb.BytesList) e.getUnfinishedMessage();
                    throw e.unwrapIOException();
                } finally {
                    if (parsedMessage != null) {
                        mergeFrom(parsedMessage);
                    }
                }
                return this;
            }

            private int bitField0_;

            private java.util.List<com.google.protobuf.ByteString> bytes_ = java.util.Collections.emptyList();

            private void ensureBytesIsMutable() {
                if (!((bitField0_ & 0x00000001) != 0)) {
                    bytes_ = new java.util.ArrayList<com.google.protobuf.ByteString>(bytes_);
                    bitField0_ |= 0x00000001;
                }
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public java.util.List<com.google.protobuf.ByteString>
            getBytesList() {
                return ((bitField0_ & 0x00000001) != 0) ?
                    java.util.Collections.unmodifiableList(bytes_) : bytes_;
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public int getBytesCount() {
                return bytes_.size();
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public com.google.protobuf.ByteString getBytes(int index) {
                return bytes_.get(index);
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public Builder setBytes(
                int index, com.google.protobuf.ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureBytesIsMutable();
                bytes_.set(index, value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public Builder addBytes(com.google.protobuf.ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                ensureBytesIsMutable();
                bytes_.add(value);
                onChanged();
                return this;
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public Builder addAllBytes(
                java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
                ensureBytesIsMutable();
                com.google.protobuf.AbstractMessageLite.Builder.addAll(
                    values, bytes_);
                onChanged();
                return this;
            }

            /**
             * <code>repeated bytes bytes = 1;</code>
             */
            public Builder clearBytes() {
                bytes_ = java.util.Collections.emptyList();
                bitField0_ = (bitField0_ & ~0x00000001);
                onChanged();
                return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
                return super.mergeUnknownFields(unknownFields);
            }


            // @@protoc_insertion_point(builder_scope:BytesList)
        }

        // @@protoc_insertion_point(class_scope:BytesList)
        private static final PushDownPb.BytesList DEFAULT_INSTANCE;

        static {
            DEFAULT_INSTANCE = new PushDownPb.BytesList();
        }

        public static PushDownPb.BytesList getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<BytesList>
            PARSER = new com.google.protobuf.AbstractParser<BytesList>() {
            @java.lang.Override
            public BytesList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
                return new BytesList(input, extensionRegistry);
            }
        };

        public static com.google.protobuf.Parser<BytesList> parser() {
            return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<BytesList> getParserForType() {
            return PARSER;
        }

        @java.lang.Override
        public PushDownPb.BytesList getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

    }

    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_PushDown_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_PushDown_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_EdgeLimit_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_EdgeLimit_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_FilterNodes_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_FilterNodes_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_FilterNode_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_FilterNode_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_IntList_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_IntList_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_LongList_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_LongList_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_StringList_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_StringList_fieldAccessorTable;
    private static final com.google.protobuf.Descriptors.Descriptor
        internal_static_BytesList_descriptor;
    private static final
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internal_static_BytesList_fieldAccessorTable;

    public static com.google.protobuf.Descriptors.FileDescriptor
    getDescriptor() {
        return descriptor;
    }

    private static com.google.protobuf.Descriptors.FileDescriptor
        descriptor;

    static {
        java.lang.String[] descriptorData = {
            "\n\016pushdown.proto\"\234\001\n\010PushDown\022\"\n\013filter_" +
                "node\030\001 \001(\0132\013.FilterNodeH\000\022$\n\014filter_node" +
                "s\030\002 \001(\0132\014.FilterNodesH\000\022\036\n\nedge_limit\030\003 " +
                "\001(\0132\n.EdgeLimit\022\034\n\tsort_type\030\004 \003(\0162\t.Sor" +
                "tTypeB\010\n\006filter\"7\n\tEdgeLimit\022\n\n\002in\030\001 \001(\004" +
                "\022\013\n\003out\030\002 \001(\004\022\021\n\tis_single\030\003 \001(\010\">\n\013Filt" +
                "erNodes\022\014\n\004keys\030\001 \003(\014\022!\n\014filter_nodes\030\002 " +
                "\003(\0132\013.FilterNode\"\344\001\n\nFilterNode\022 \n\013filte" +
                "r_type\030\001 \001(\0162\013.FilterType\022\034\n\007filters\030\002 \003" +
                "(\0132\013.FilterNode\022\037\n\013int_content\030\003 \001(\0132\010.I" +
                "ntListH\000\022!\n\014long_content\030\004 \001(\0132\t.LongLis" +
                "tH\000\022\"\n\013str_content\030\005 \001(\0132\013.StringListH\000\022" +
                "#\n\rbytes_content\030\006 \001(\0132\n.BytesListH\000B\t\n\007" +
                "content\"\026\n\007IntList\022\013\n\003int\030\001 \003(\005\"\030\n\010LongL" +
                "ist\022\014\n\004long\030\001 \003(\003\"\031\n\nStringList\022\013\n\003str\030\001" +
                " \003(\t\"\032\n\tBytesList\022\r\n\005bytes\030\001 \003(\014*\215\002\n\nFil" +
                "terType\022\t\n\005EMPTY\020\000\022\017\n\013ONLY_VERTEX\020\001\022\013\n\007I" +
                "N_EDGE\020\002\022\014\n\010OUT_EDGE\020\003\022\r\n\tVERTEX_TS\020\004\022\013\n" +
                "\007EDGE_TS\020\005\022\021\n\rMULTI_EDGE_TS\020\006\022\020\n\014VERTEX_" +
                "LABEL\020\007\022\016\n\nEDGE_LABEL\020\010\022\025\n\021VERTEX_VALUE_" +
                "DROP\020\t\022\023\n\017EDGE_VALUE_DROP\020\n\022\007\n\003TTL\020\013\022\007\n\003" +
                "AND\020\014\022\006\n\002OR\020\r\022\027\n\023VERTEX_MUST_CONTAIN\020\016\022\r" +
                "\n\tGENERATED\020\017\022\t\n\005OTHER\020\020*U\n\010SortType\022\n\n\006" +
                "SRC_ID\020\000\022\r\n\tDIRECTION\020\001\022\r\n\tDESC_TIME\020\002\022\010" +
                "\n\004TIME\020\003\022\t\n\005LABEL\020\004\022\n\n\006DST_ID\020\005B\014B\nPushD" +
                "ownPbb\006proto3"
        };
        descriptor = com.google.protobuf.Descriptors.FileDescriptor
            .internalBuildGeneratedFileFrom(descriptorData,
                new com.google.protobuf.Descriptors.FileDescriptor[]{
                });
        internal_static_PushDown_descriptor =
            getDescriptor().getMessageTypes().get(0);
        internal_static_PushDown_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_PushDown_descriptor,
            new java.lang.String[]{"FilterNode", "FilterNodes", "EdgeLimit", "SortType", "Filter",});
        internal_static_EdgeLimit_descriptor =
            getDescriptor().getMessageTypes().get(1);
        internal_static_EdgeLimit_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_EdgeLimit_descriptor,
            new java.lang.String[]{"In", "Out", "IsSingle",});
        internal_static_FilterNodes_descriptor =
            getDescriptor().getMessageTypes().get(2);
        internal_static_FilterNodes_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_FilterNodes_descriptor,
            new java.lang.String[]{"Keys", "FilterNodes",});
        internal_static_FilterNode_descriptor =
            getDescriptor().getMessageTypes().get(3);
        internal_static_FilterNode_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_FilterNode_descriptor,
            new java.lang.String[]{"FilterType", "Filters", "IntContent", "LongContent", "StrContent", "BytesContent", "Content",});
        internal_static_IntList_descriptor =
            getDescriptor().getMessageTypes().get(4);
        internal_static_IntList_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_IntList_descriptor,
            new java.lang.String[]{"Int",});
        internal_static_LongList_descriptor =
            getDescriptor().getMessageTypes().get(5);
        internal_static_LongList_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_LongList_descriptor,
            new java.lang.String[]{"Long",});
        internal_static_StringList_descriptor =
            getDescriptor().getMessageTypes().get(6);
        internal_static_StringList_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_StringList_descriptor,
            new java.lang.String[]{"Str",});
        internal_static_BytesList_descriptor =
            getDescriptor().getMessageTypes().get(7);
        internal_static_BytesList_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
            internal_static_BytesList_descriptor,
            new java.lang.String[]{"Bytes",});
    }

    // @@protoc_insertion_point(outer_class_scope)
}
