/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecluster.memberlist.agent.IAgent;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMember;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basekv.Constants;
import org.apache.bifromq.basekv.proto.KVRangeMessage;
import org.apache.bifromq.basekv.proto.StoreMessage;
import org.apache.bifromq.basekv.store.IStoreMessenger;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class AgentHostStoreMessenger
implements IStoreMessenger {
    private final Logger log;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final IAgentHost agentHost;
    private final IAgent agent;
    private final IAgentMember agentMember;
    private final Subject<StoreMessage> receiveSubject = PublishSubject.create().toSerialized();
    private final String clusterId;
    private final String storeId;
    private final CompositeDisposable disposables = new CompositeDisposable();

    AgentHostStoreMessenger(IAgentHost agentHost, String clusterId, String storeId) {
        this.agentHost = agentHost;
        this.clusterId = clusterId;
        this.storeId = storeId;
        this.agent = agentHost.host(Constants.toBaseKVAgentId((String)clusterId));
        this.agentMember = this.agent.register(storeId);
        this.log = MDCLogger.getLogger(AgentHostStoreMessenger.class, (String[])new String[]{"clusterId", clusterId, "storeId", storeId});
        this.disposables.add(this.agentMember.receive().mapOptional(agentMessage -> {
            try {
                StoreMessage message = (StoreMessage)ZeroCopyParser.parse((ByteString)agentMessage.getPayload(), (Parser)StoreMessage.parser());
                KVRangeMessage payload = message.getPayload();
                if (!payload.hasHostStoreId()) {
                    message = message.toBuilder().setPayload(payload.toBuilder().setHostStoreId(storeId).build()).build();
                }
                return Optional.of(message);
            }
            catch (InvalidProtocolBufferException e) {
                this.log.warn("Unable to parse store message", (Throwable)e);
                return Optional.empty();
            }
        }).subscribe(arg_0 -> this.receiveSubject.onNext(arg_0)));
    }

    static String agentId(String clusterId) {
        return "BaseKV:" + clusterId;
    }

    @Override
    public void send(StoreMessage message) {
        if (message.getPayload().hasHostStoreId()) {
            if (message.getPayload().getHostStoreId().equals(this.storeId)) {
                this.receiveSubject.onNext((Object)message);
                return;
            }
            this.agentMember.multicast(message.getPayload().getHostStoreId(), message.toByteString(), true);
        } else {
            this.agentMember.broadcast(message.toByteString(), true);
        }
    }

    @Override
    public Observable<StoreMessage> receive() {
        return this.receiveSubject;
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            this.disposables.dispose();
            this.receiveSubject.onComplete();
            this.agent.deregister(this.agentMember).join();
        }
    }
}

