/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.TenantAwareHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.rpc.proto.SubReply;
import org.apache.bifromq.sessiondict.rpc.proto.SubRequest;
import org.apache.bifromq.type.QoS;

@Path(value="/sub")
final class SubHandler
extends TenantAwareHandler {
    private final ISessionDictClient sessionDictClient;

    SubHandler(ISettingProvider settingProvider, ISessionDictClient sessionDictClient) {
        super(settingProvider);
        this.sessionDictClient = sessionDictClient;
    }

    @Override
    @PUT
    @Operation(summary="Add a topic subscription to a mqtt session")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="tenant_id", in=ParameterIn.HEADER, required=true, description="the id of tenant", schema=@Schema(implementation=String.class)), @Parameter(name="user_id", in=ParameterIn.HEADER, required=true, description="the id of user who established the session", schema=@Schema(implementation=String.class)), @Parameter(name="client_id", in=ParameterIn.HEADER, required=true, description="the client id of the mqtt session", schema=@Schema(implementation=String.class)), @Parameter(name="topic_filter", in=ParameterIn.HEADER, required=true, description="the topic filter to add", schema=@Schema(implementation=String.class)), @Parameter(name="sub_qos", in=ParameterIn.HEADER, description="the qos of the subscription", schema=@Schema(implementation=Integer.class, allowableValues={"0", "1", "2"}), required=true)})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success"), @ApiResponse(responseCode="400", description="Request is invalid"), @ApiResponse(responseCode="401", description="Unauthorized to make subscription using the given topic filter"), @ApiResponse(responseCode="404", description="No session found for the given user and client id")})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) String tenantId, @Parameter(hidden=true) FullHttpRequest req) {
        String topicFilter = HeaderUtils.getHeader(Headers.HEADER_TOPIC_FILTER, (HttpRequest)req, true);
        QoS subQoS = HeaderUtils.getRequiredSubQoS((HttpRequest)req);
        String userId = HeaderUtils.getHeader(Headers.HEADER_USER_ID, (HttpRequest)req, true);
        String clientId = HeaderUtils.getHeader(Headers.HEADER_CLIENT_ID, (HttpRequest)req, true);
        return this.sessionDictClient.sub(SubRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setUserId(userId).setClientId(clientId).setTopicFilter(topicFilter).setQos(subQoS).build()).thenApply(reply -> switch (reply.getResult()) {
            case SubReply.Result.OK, SubReply.Result.EXISTS -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])reply.getResult().name().getBytes()));
            case SubReply.Result.EXCEED_LIMIT, SubReply.Result.TOPIC_FILTER_INVALID, SubReply.Result.BACK_PRESSURE_REJECTED -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer((byte[])reply.getResult().name().getBytes()));
            case SubReply.Result.NOT_AUTHORIZED -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.UNAUTHORIZED, Unpooled.EMPTY_BUFFER);
            case SubReply.Result.NO_SESSION -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.EMPTY_BUFFER);
            default -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER);
        });
    }
}

