/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficGovernor;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;

abstract class AbstractTrafficRulesHandler
implements IHTTPRequestHandler {
    protected final Map<String, IRPCServiceTrafficGovernor> governorMap = new ConcurrentHashMap<String, IRPCServiceTrafficGovernor>();
    private final IRPCServiceTrafficService trafficService;
    private final CompositeDisposable disposable = new CompositeDisposable();

    public AbstractTrafficRulesHandler(IRPCServiceTrafficService trafficService) {
        this.trafficService = trafficService;
    }

    @Override
    public void start() {
        this.disposable.add(this.trafficService.services().subscribe(serviceUniqueNames -> {
            this.governorMap.keySet().removeIf(serviceUniqueName -> !serviceUniqueNames.contains(serviceUniqueName));
            for (String serviceUniqueName2 : serviceUniqueNames) {
                if (!this.isRPCService(serviceUniqueName2)) continue;
                this.governorMap.computeIfAbsent(this.shortServiceName(serviceUniqueName2), k -> this.trafficService.getTrafficGovernor(serviceUniqueName2));
            }
        }));
    }

    @Override
    public void close() {
        this.disposable.dispose();
    }

    protected boolean isTrafficGovernable(String serviceName) {
        return !serviceName.equals("BrokerService");
    }

    private boolean isRPCService(String serviceUniqueName) {
        return !serviceUniqueName.endsWith("@basekv.BaseKVStoreService");
    }

    private String shortServiceName(String serviceUniqueName) {
        return serviceUniqueName.substring(serviceUniqueName.lastIndexOf(46) + 1);
    }
}

