/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

public interface ValueStrategy<V> {
    public int hash(V var1);

    public boolean equivalent(V var1, V var2);

    public static <T> ValueStrategy<T> natural() {
        return new ValueStrategy<T>(){

            @Override
            public int hash(T value) {
                return value == null ? 0 : value.hashCode();
            }

            @Override
            public boolean equivalent(T a, T b) {
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                return a.equals(b);
            }
        };
    }

    public static <T> ValueStrategy<T> identity() {
        return new ValueStrategy<T>(){

            @Override
            public int hash(T value) {
                return System.identityHashCode(value);
            }

            @Override
            public boolean equivalent(T a, T b) {
                return a == b;
            }
        };
    }
}

