/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.store.schema;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.bifromq.retain.store.schema.LevelHash;
import org.apache.bifromq.util.BSUtil;
import org.apache.bifromq.util.TopicUtil;

public class KVSchemaUtil {
    public static final ByteString SCHEMA_VER = ByteString.copyFrom((byte[])new byte[]{0});
    private static final int TENANT_ID_PREFIX_LENGTH = SCHEMA_VER.size() + 2;

    public static ByteString tenantBeginKey(String tenantId) {
        ByteString tenantIdBS = UnsafeByteOperations.unsafeWrap((byte[])tenantId.getBytes(StandardCharsets.UTF_8));
        return SCHEMA_VER.concat(BSUtil.toByteString((short)((short)tenantIdBS.size()))).concat(tenantIdBS);
    }

    public static ByteString retainMessageKey(String tenantId, String topic) {
        List topicLevels = TopicUtil.parse((String)topic, (boolean)false);
        short levels = (short)topicLevels.size();
        return KVSchemaUtil.tenantBeginKey(tenantId).concat(BSUtil.toByteString((short)levels)).concat(LevelHash.hash(topicLevels)).concat(ByteString.copyFromUtf8((String)TopicUtil.escape((String)topic)));
    }

    public static List<String> filterPrefix(List<String> filterLevels) {
        int firstWildcard = filterLevels.indexOf("+");
        if (firstWildcard == -1) {
            if (filterLevels.get(filterLevels.size() - 1).equals("#")) {
                firstWildcard = filterLevels.size() - 1;
                return filterLevels.subList(0, firstWildcard);
            }
            return filterLevels;
        }
        return filterLevels.subList(0, firstWildcard);
    }

    public static ByteString retainKeyPrefix(String tenantId, short levels, List<String> filterPrefix) {
        return KVSchemaUtil.tenantBeginKey(tenantId).concat(BSUtil.toByteString((short)levels)).concat(LevelHash.hash(filterPrefix));
    }

    public static String parseTenantId(ByteString key) {
        return key.substring(TENANT_ID_PREFIX_LENGTH, TENANT_ID_PREFIX_LENGTH + KVSchemaUtil.tenantIdLength(key)).toStringUtf8();
    }

    public static ByteString parseLevelHash(ByteString key) {
        short tenantIdLength = KVSchemaUtil.tenantIdLength(key);
        int levelBytesIdx = TENANT_ID_PREFIX_LENGTH + tenantIdLength;
        int levelHashIdx = TENANT_ID_PREFIX_LENGTH + tenantIdLength + 2;
        short levels = BSUtil.toShort((ByteString)key.substring(levelBytesIdx, levelHashIdx));
        return key.substring(levelHashIdx, levelHashIdx + levels);
    }

    private static short tenantIdLength(ByteString key) {
        return BSUtil.toShort((ByteString)key.substring(SCHEMA_VER.size(), TENANT_ID_PREFIX_LENGTH));
    }
}

